/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.partitioner;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class PHPPartitionTypes {
    public static final String PHP_DEFAULT = "org.eclipse.php.PHP_DEFAULT";
    public static final String PHP_SINGLE_LINE_COMMENT = "org.eclipse.php.PHP_SINGLE_LINE_COMMENT";
    public static final String PHP_MULTI_LINE_COMMENT = "org.eclipse.php.PHP_MULTI_LINE_COMMENT";
    public static final String PHP_DOC = "org.eclipse.php.PHP_DOC";
    public static final String PHP_QUOTED_STRING = "org.eclipse.php.PHP_QUOTED_STRING";

    public static boolean isPHPCommentState(String type) {
        return type == null ? false : PHPPartitionTypes.isPHPMultiLineCommentState(type) || PHPPartitionTypes.isPHPLineCommentState(type) || PHPPartitionTypes.isPHPDocState(type);
    }

    public static boolean isPHPDocState(String type) {
        return type == null ? false : type.startsWith("PHPDOC");
    }

    public static boolean isPHPDocTagState(String type) {
        return PHPPartitionTypes.isPHPDocState(type) && !type.startsWith("PHPDOC_COMMENT");
    }

    public static boolean isPHPLineCommentState(String type) {
        return type == "PHP_LINE_COMMENT";
    }

    public static boolean isPHPMultiLineCommentState(String type) {
        return type == "PHP_COMMENT" || type == "PHP_COMMENT_START" || type == "PHP_COMMENT_END";
    }

    public static boolean isPHPQuotesState(String type) {
        return type == "PHP_CONSTANT_ENCAPSED_STRING" || type == "PHP_HEREDOC_TAG";
    }

    public static final boolean isPHPRegularState(String type) {
        return type != null && !PHPPartitionTypes.isPHPCommentState(type) && !PHPPartitionTypes.isPHPQuotesState(type);
    }

    public static final ITextRegion getPartitionStartRegion(IPhpScriptRegion region, int offset) throws BadLocationException {
        ITextRegion internalRegion;
        String partitionType = region.getPartition(offset);
        ITextRegion startRegion = internalRegion = region.getPhpToken(offset);
        while (internalRegion.getStart() != 0) {
            if (region.getPartition((internalRegion = region.getPhpToken(internalRegion.getStart() - 1)).getStart()) != partitionType) break;
            startRegion = internalRegion;
        }
        return startRegion;
    }

    public static final int getPartitionStart(IPhpScriptRegion region, int offset) throws BadLocationException {
        ITextRegion startRegion = PHPPartitionTypes.getPartitionStartRegion(region, offset);
        return startRegion.getStart();
    }

    public static final ITextRegion getPartitionEndRegion(IPhpScriptRegion region, int offset) throws BadLocationException {
        ITextRegion internalRegion;
        String partitionType = region.getPartition(offset);
        ITextRegion endRegion = internalRegion = region.getPhpToken(offset);
        while (internalRegion.getEnd() != region.getLength()) {
            if (region.getPartition((internalRegion = region.getPhpToken(internalRegion.getEnd())).getStart()) != partitionType) break;
            endRegion = internalRegion;
        }
        return endRegion;
    }

    public static final int getPartitionEnd(IPhpScriptRegion region, int offset) throws BadLocationException {
        ITextRegion endRegion = PHPPartitionTypes.getPartitionEndRegion(region, offset);
        return endRegion.getEnd();
    }

    public static final ITypedRegion getPartition(IPhpScriptRegion region, int offset) throws BadLocationException {
        String partitionType = region.getPartition(offset);
        int startOffset = PHPPartitionTypes.getPartitionStart(region, offset);
        int endOffset = PHPPartitionTypes.getPartitionEnd(region, offset);
        return new TypedRegion(startOffset, endOffset - startOffset, partitionType);
    }

    public static boolean isPHPDocCommentState(String type) {
        return type == "PHPDOC_COMMENT";
    }
}

