/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.util.TreeSet;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;

public abstract class CompositePhpModel
implements IPhpModel {
    private IPhpModel[] models = new IPhpModel[0];

    public void addModel(IPhpModel newModel) {
        if (this.indexOf(newModel.getID()) != -1) {
            return;
        }
        IPhpModel[] tmp = new IPhpModel[this.models.length + 1];
        System.arraycopy(this.models, 0, tmp, 0, this.models.length);
        tmp[tmp.length - 1] = newModel;
        this.models = tmp;
    }

    public IPhpModel remove(String modelId) {
        if (modelId == null) {
            return null;
        }
        int index = this.indexOf(modelId);
        if (index == -1) {
            return null;
        }
        IPhpModel[] tmp = new IPhpModel[this.models.length - 1];
        int i = 0;
        while (i < index) {
            tmp[i] = this.models[i];
            ++i;
        }
        i = index + 1;
        while (i < this.models.length) {
            tmp[i - 1] = this.models[i];
            ++i;
        }
        IPhpModel rv = this.models[index];
        this.models = tmp;
        return rv;
    }

    public IPhpModel getModel(String modelId) {
        int index = this.indexOf(modelId);
        if (index == -1) {
            return null;
        }
        return this.models[index];
    }

    public IPhpModel[] getModels() {
        return this.models;
    }

    private int indexOf(String modelId) {
        int i = 0;
        while (i < this.models.length) {
            if (this.models[i].getID().equals(modelId)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public CodeData[] getFileDatas() {
        TreeSet<CodeData> tempResult = new TreeSet<CodeData>();
        int i = 0;
        while (i < this.models.length) {
            CodeData[] res = this.models[i].getFileDatas();
            if (res != null) {
                int j = 0;
                while (j < res.length) {
                    tempResult.add(res[j]);
                    ++j;
                }
            }
            ++i;
        }
        return tempResult.toArray(new CodeData[tempResult.size()]);
    }

    public PHPFileData getFileData(String fileName) {
        int i = 0;
        while (i < this.models.length) {
            PHPFileData res = this.models[i].getFileData(fileName);
            if (res != null) {
                return res;
            }
            ++i;
        }
        return null;
    }

    public CodeData[] getClasses() {
        TreeSet<CodeData> tempResult = new TreeSet<CodeData>();
        int i = 0;
        while (i < this.models.length) {
            CodeData[] res = this.models[i].getClasses();
            if (res != null) {
                int j = 0;
                while (j < res.length) {
                    tempResult.add(res[j]);
                    ++j;
                }
            }
            ++i;
        }
        return tempResult.toArray(new CodeData[tempResult.size()]);
    }

    public CodeData[] getClasses(String startsWith) {
        TreeSet<CodeData> tempResult = new TreeSet<CodeData>();
        int i = 0;
        while (i < this.models.length) {
            CodeData[] res = this.models[i].getClasses(startsWith);
            if (res != null) {
                int j = 0;
                while (j < res.length) {
                    tempResult.add(res[j]);
                    ++j;
                }
            }
            ++i;
        }
        return tempResult.toArray(new CodeData[tempResult.size()]);
    }

    public CodeData[] getClass(String className) {
        TreeSet<CodeData> tempResult = new TreeSet<CodeData>();
        int i = 0;
        while (i < this.models.length) {
            CodeData[] res = this.models[i].getClass(className);
            if (res != null) {
                int j = 0;
                while (j < res.length) {
                    tempResult.add(res[j]);
                    ++j;
                }
            }
            ++i;
        }
        return tempResult.toArray(new CodeData[tempResult.size()]);
    }

    public PHPClassData getClass(String fileName, String className) {
        int i = 0;
        while (i < this.models.length) {
            PHPClassData exactClass = this.models[i].getClass(fileName, className);
            if (exactClass != null && exactClass.getUserData() != null && exactClass.getUserData().getFileName().equals(fileName)) {
                return exactClass;
            }
            ++i;
        }
        return null;
    }

    public CodeData[] getFunctions() {
        TreeSet<CodeData> tempResult = new TreeSet<CodeData>();
        int i = 0;
        while (i < this.models.length) {
            CodeData[] res = this.models[i].getFunctions();
            if (res != null) {
                int j = 0;
                while (j < res.length) {
                    tempResult.add(res[j]);
                    ++j;
                }
            }
            ++i;
        }
        return tempResult.toArray(new CodeData[tempResult.size()]);
    }

    public CodeData[] getFunctions(String startsWith) {
        TreeSet<CodeData> tempResult = new TreeSet<CodeData>();
        int i = 0;
        while (i < this.models.length) {
            CodeData[] res = this.models[i].getFunctions(startsWith);
            if (res != null) {
                int j = 0;
                while (j < res.length) {
                    tempResult.add(res[j]);
                    ++j;
                }
            }
            ++i;
        }
        return tempResult.toArray(new CodeData[tempResult.size()]);
    }

    public CodeData[] getFunction(String functionName) {
        TreeSet<CodeData> tempResult = new TreeSet<CodeData>();
        int i = 0;
        while (i < this.models.length) {
            CodeData[] res = this.models[i].getFunction(functionName);
            if (res != null) {
                int j = 0;
                while (j < res.length) {
                    tempResult.add(res[j]);
                    ++j;
                }
            }
            ++i;
        }
        return tempResult.toArray(new CodeData[tempResult.size()]);
    }

    public PHPFunctionData getFunction(String fileName, String functionName) {
        int i = 0;
        while (i < this.models.length) {
            PHPFunctionData exactFunction = this.models[i].getFunction(fileName, functionName);
            if (exactFunction != null && exactFunction.getUserData() != null && exactFunction.getUserData().getFileName().equals(fileName)) {
                return exactFunction;
            }
            ++i;
        }
        return null;
    }

    public CodeData[] getConstants() {
        TreeSet<CodeData> tempResult = new TreeSet<CodeData>();
        int i = 0;
        while (i < this.models.length) {
            CodeData[] res = this.models[i].getConstants();
            if (res != null) {
                int j = 0;
                while (j < res.length) {
                    tempResult.add(res[j]);
                    ++j;
                }
            }
            ++i;
        }
        return tempResult.toArray(new CodeData[tempResult.size()]);
    }

    public CodeData[] getConstants(String startsWith, boolean caseSensitive) {
        TreeSet<CodeData> tempResult = new TreeSet<CodeData>();
        int i = 0;
        while (i < this.models.length) {
            CodeData[] res = this.models[i].getConstants(startsWith, caseSensitive);
            if (res != null) {
                int j = 0;
                while (j < res.length) {
                    tempResult.add(res[j]);
                    ++j;
                }
            }
            ++i;
        }
        return tempResult.toArray(new CodeData[tempResult.size()]);
    }

    public CodeData[] getConstant(String constantName) {
        TreeSet<CodeData> tempResult = new TreeSet<CodeData>();
        int i = 0;
        while (i < this.models.length) {
            CodeData[] res = this.models[i].getConstant(constantName);
            if (res != null) {
                int j = 0;
                while (j < res.length) {
                    tempResult.add(res[j]);
                    ++j;
                }
            }
            ++i;
        }
        return tempResult.toArray(new CodeData[tempResult.size()]);
    }

    public PHPConstantData getConstant(String fileName, String constantName) {
        int i = 0;
        while (i < this.models.length) {
            PHPConstantData exactConstant = this.models[i].getConstant(fileName, constantName);
            if (exactConstant != null && exactConstant.getUserData() != null && exactConstant.getUserData().getFileName().equals(fileName)) {
                return exactConstant;
            }
            ++i;
        }
        return null;
    }

    public CodeData[] getGlobalVariables(String fileName, String startsWith, boolean showVariablesFromOtherFiles) {
        TreeSet<CodeData> tempResult = new TreeSet<CodeData>();
        int i = 0;
        while (i < this.models.length) {
            CodeData[] res = this.models[i].getGlobalVariables(fileName, startsWith, showVariablesFromOtherFiles);
            if (res != null) {
                int j = 0;
                while (j < res.length) {
                    tempResult.add(res[j]);
                    ++j;
                }
            }
            ++i;
        }
        return tempResult.toArray(new CodeData[tempResult.size()]);
    }

    public CodeData[] getVariables(String fileName, PHPCodeContext context, String startsWith, boolean showVariablesFromOtherFiles) {
        TreeSet<CodeData> tempResult = new TreeSet<CodeData>();
        int i = 0;
        while (i < this.models.length) {
            CodeData[] res = this.models[i].getVariables(fileName, context, startsWith, showVariablesFromOtherFiles);
            if (res != null) {
                int j = 0;
                while (j < res.length) {
                    tempResult.add(res[j]);
                    ++j;
                }
            }
            ++i;
        }
        return tempResult.toArray(new CodeData[tempResult.size()]);
    }

    public String getVariableType(String fileName, PHPCodeContext context, String variableName, int line, boolean showObjectsFromOtherFiles) {
        int i = 0;
        while (i < this.models.length) {
            String res = this.models[i].getVariableType(fileName, context, variableName, line, showObjectsFromOtherFiles);
            if (res != null && !res.equals("")) {
                return res;
            }
            ++i;
        }
        return null;
    }

    public IPHPMarker[] getMarkers() {
        TreeSet<IPHPMarker> tempResult = new TreeSet<IPHPMarker>();
        int i = 0;
        while (i < this.models.length) {
            IPHPMarker[] res = this.models[i].getMarkers();
            if (res != null) {
                int j = 0;
                while (j < res.length) {
                    tempResult.add(res[j]);
                    ++j;
                }
            }
            ++i;
        }
        return tempResult.toArray(new IPHPMarker[tempResult.size()]);
    }

    public void clear() {
        int i = 0;
        while (i < this.models.length) {
            this.models[i].clear();
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.models.length) {
            this.models[i].dispose();
            ++i;
        }
    }
}

