/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.phpModel.parser.CompletionLexer;
import org.eclipse.php.internal.core.phpModel.parser.PHPParserManager;
import org.eclipse.php.internal.core.phpModel.parser.ParserClient;
import org.eclipse.php.internal.core.phpModel.parser.PhpParser;

public final class ParserExecuter
implements Runnable {
    private static final ILock parserClientLock = Job.getJobManager().newLock();
    public final PHPParserManager parserManager;
    public final ParserClient client;
    public final String filename;
    private final Reader reader;
    public final long lastModified;
    public final Pattern[] tasksPatterns;
    public final boolean useAspTagsAsPhp;
    private PhpParser phpParser;

    public ParserExecuter(PHPParserManager parserManager, PhpParser phpParser, ParserClient client, String filename, Reader reader, Pattern[] tasksPatterns, long lastModified, boolean useAspTagsAsPhp) {
        this.parserManager = parserManager;
        this.phpParser = phpParser;
        this.client = client;
        this.filename = filename;
        this.reader = reader;
        this.tasksPatterns = tasksPatterns;
        this.lastModified = lastModified;
        this.useAspTagsAsPhp = useAspTagsAsPhp;
    }

    public final void run() {
        try {
            try {
                parserClientLock.acquire();
                CompletionLexer lexer = this.parserManager.createCompletionLexer(this.reader);
                lexer.setUseAspTagsAsPhp(this.useAspTagsAsPhp);
                lexer.setParserClient(this.client);
                lexer.setTasksPatterns(this.tasksPatterns);
                if (this.phpParser == null) {
                    this.phpParser = this.parserManager.createPhpParser();
                }
                this.phpParser.setScanner(lexer);
                this.phpParser.setParserClient(this.client);
                this.client.startParsing(this.filename);
                this.phpParser.parse();
            }
            catch (Exception e) {
                block39: {
                    Logger.logException(e);
                    try {
                        try {
                            if (this.client != null && this.phpParser != null) {
                                this.client.finishParsing(this.phpParser.getLength(), this.phpParser.getCurrentLine(), this.lastModified);
                            }
                        }
                        catch (Exception ex) {
                            Logger.logException(ex);
                            try {
                                this.reader.close();
                            }
                            catch (IOException exception) {
                                Logger.logException(exception);
                            }
                            break block39;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            this.reader.close();
                        }
                        catch (IOException exception) {
                            Logger.logException(exception);
                        }
                        throw throwable;
                    }
                    try {
                        this.reader.close();
                    }
                    catch (IOException exception) {
                        Logger.logException(exception);
                    }
                }
                parserClientLock.release();
            }
        }
        finally {
            block42: {
                try {
                    try {
                        if (this.client != null && this.phpParser != null) {
                            this.client.finishParsing(this.phpParser.getLength(), this.phpParser.getCurrentLine(), this.lastModified);
                        }
                    }
                    catch (Exception ex) {
                        Logger.logException(ex);
                        try {
                            this.reader.close();
                        }
                        catch (IOException exception) {
                            Logger.logException(exception);
                        }
                        break block42;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException exception) {
                        Logger.logException(exception);
                    }
                    throw throwable;
                }
                try {
                    this.reader.close();
                }
                catch (IOException exception) {
                    Logger.logException(exception);
                }
            }
            parserClientLock.release();
        }
    }
}

