/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.phpElementData;

import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;

public abstract class AbstractCodeData
implements CodeData {
    protected String name;
    private boolean isUserCode;
    protected UserData userData;

    public AbstractCodeData(String name) {
        this(name, null);
    }

    public AbstractCodeData(String name, UserData userData) {
        this.name = name;
        this.userData = userData;
        this.isUserCode = userData != null;
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isUserCode() {
        return this.isUserCode;
    }

    public final UserData getUserData() {
        return this.userData;
    }

    public int compareTo(CodeData other) {
        int compared = this.name.compareToIgnoreCase(other.getName());
        if (compared != 0) {
            return compared;
        }
        boolean otherIsUserCode = other.isUserCode();
        if (!this.isUserCode) {
            if (!otherIsUserCode) {
                return 0;
            }
            return -1;
        }
        if (!otherIsUserCode) {
            return 1;
        }
        return this.userData.getFileName().compareTo(other.getUserData().getFileName());
    }

    public String toString() {
        if (this.getUserData() == null) {
            return this.name;
        }
        return String.valueOf(this.name) + " in " + this.getUserData().getFileName();
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

