/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.core.project.build.IPHPBuilderExtension;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.project.build.FullPhpProjectBuildVisitor;
import org.eclipse.php.internal.core.project.build.PhpResourceDeltaBuildVisitor;

public class DefaultPHPBuilderExtension
implements IPHPBuilderExtension {
    public boolean isEnabled() {
        return true;
    }

    public void startupOnInitialize(IncrementalProjectBuilder builder) {
    }

    public void clean(IProject project, IProgressMonitor monitor) throws CoreException {
        this.cleanBuild(project.getProject());
    }

    public IProject[] build(IProject project, IResourceDelta delta, int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(project, monitor);
            return null;
        }
        if (delta == null) {
            return null;
        }
        this.buildDelta(delta, monitor);
        return null;
    }

    private void fullBuild(IProject project, IProgressMonitor monitor) {
        try {
            project.accept((IResourceVisitor)new FullPhpProjectBuildVisitor(monitor));
            PHPWorkspaceModelManager.getInstance().fireProjectModelChanged(project);
        }
        catch (CoreException e) {
            PHPCorePlugin.log(e);
            return;
        }
    }

    private void buildDelta(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new PhpResourceDeltaBuildVisitor(monitor));
    }

    private void cleanBuild(IProject project) {
        try {
            if (!project.hasNature("org.eclipse.php.core.PHPNature")) {
                return;
            }
        }
        catch (CoreException e) {
            PHPCorePlugin.log(e);
            return;
        }
        PHPProjectModel modelForProject = PHPWorkspaceModelManager.getInstance().getModelForProject(project);
        if (modelForProject != null) {
            modelForProject.clear();
            return;
        }
    }
}

