/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.part.FileEditorInput;

public class PHPProjectBuildJobWrapper {
    private IProject project;

    public PHPProjectBuildJobWrapper(IProject project) {
        this.project = project;
    }

    public void runJob() {
        WorkspaceJob cleanJob = new WorkspaceJob(CoreMessages.getString("PHPProjectBuildJobWrapper_0")){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    PHPProjectBuildJobWrapper.this.project.build(15, monitor);
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            private void handleEditorReferences(IEditorReference[] editorReferences) {
                int i = 0;
                while (i < editorReferences.length) {
                    IContentDescription contentDescription;
                    IEditorReference reference = editorReferences[i];
                    IEditorPart editorPart = reference.getEditor(false);
                    IEditorInput editorInput = editorPart.getEditorInput();
                    if (!(editorInput instanceof FileEditorInput)) {
                        return;
                    }
                    IFile file = ((FileEditorInput)editorInput).getFile();
                    try {
                        contentDescription = file.getContentDescription();
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                        return;
                    }
                    if (contentDescription == null) {
                        return;
                    }
                    if (!ContentTypeIdForPHP.ContentTypeID_PHP.equals(contentDescription.getContentType().getId())) {
                        return;
                    }
                    ++i;
                }
            }
        };
        cleanJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        cleanJob.setUser(false);
        cleanJob.schedule();
    }
}

