/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.options.includepath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.core.IIncludePathVariableInitializer;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariablesListener;

public class IncludePathVariableManager {
    private static IncludePathVariableManager instance;
    IPreferenceStore preferenceStore = PHPCorePlugin.getDefault().getPreferenceStore();
    HashMap variables = new HashMap();
    HashMap reservedVariables = new HashMap();
    private ArrayList listeners;

    public static IncludePathVariableManager instance() {
        if (instance == null) {
            instance = new IncludePathVariableManager();
        }
        return instance;
    }

    private IncludePathVariableManager() {
    }

    public IPath getIncludePathVariable(String variableName) {
        IPath varPath = null;
        Path path = new Path(variableName);
        if (path.segmentCount() == 1) {
            varPath = (IPath)this.variables.get(variableName);
        } else {
            varPath = (IPath)this.variables.get(path.segment(0));
            if (varPath != null) {
                varPath = varPath.append(path.removeFirstSegments(1));
            }
        }
        return varPath;
    }

    public void setIncludePathVariables(String[] names, IPath[] paths, SubProgressMonitor monitor) {
        this.variables.clear();
        StringBuffer namesString = new StringBuffer();
        StringBuffer pathsString = new StringBuffer();
        int i = 0;
        while (i < names.length) {
            if (paths[i] != null) {
                this.variables.put(names[i], paths[i]);
                if (i > 0) {
                    namesString.append(",");
                    pathsString.append(",");
                }
                namesString.append(names[i]);
                pathsString.append(paths[i].toOSString());
            }
            ++i;
        }
        this.preferenceStore.setValue("org.eclipse.php.core.includePathVariableNames", namesString.toString());
        this.preferenceStore.setValue("org.eclipse.php.core.includePathVariablePaths", pathsString.toString());
        this.fireIncludePathVariablesChanged(names, paths);
    }

    private void fireIncludePathVariablesChanged(String[] names, IPath[] paths) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((IncludePathVariablesListener)i.next()).includePathVariablesChanged(names, paths);
        }
    }

    public void addListener(IncludePathVariablesListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IncludePathVariablesListener listener) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public String[] getIncludePathVariableNames() {
        ArrayList list = new ArrayList();
        list.addAll(this.variables.keySet());
        return list.toArray(new String[list.size()]);
    }

    public void startUp() {
        String namesString = this.preferenceStore.getString("org.eclipse.php.core.includePathVariableNames");
        String pathsString = this.preferenceStore.getString("org.eclipse.php.core.includePathVariablePaths");
        String[] names = new String[]{};
        if (namesString.length() > 0) {
            names = namesString.split(",");
        }
        String[] paths = new String[]{};
        if (pathsString.length() > 0) {
            paths = pathsString.split(",");
        }
        int i = 0;
        while (i < names.length) {
            String path = i < paths.length ? paths[i] : "";
            this.variables.put(names[i], new Path(path));
            ++i;
        }
        this.initExtensionPoints();
    }

    private void initExtensionPoints() {
        IConfigurationElement[] elements;
        PHPCorePlugin phpCorePlugin = PHPCorePlugin.getDefault();
        if (phpCorePlugin == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.core", "includePathVariables");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("variable".equals(element.getName())) {
                String name = element.getAttribute("name");
                String value = element.getAttribute("value");
                if (element.getAttribute("initializer") != null) {
                    try {
                        IIncludePathVariableInitializer initializer = (IIncludePathVariableInitializer)element.createExecutableExtension("initializer");
                        value = initializer.initialize(name);
                    }
                    catch (CoreException e) {
                        PHPCorePlugin.log(e);
                    }
                }
                if (value != null) {
                    this.putVariable(name, (IPath)new Path(value));
                    this.reservedVariables.put(name, null);
                }
            }
            ++n2;
        }
    }

    public synchronized void putVariable(String name, IPath path) {
        this.variables.put(name, path);
    }

    public boolean isReserved(String variableName) {
        return this.reservedVariables.containsKey(variableName);
    }

    public String[] getReservedVariables() {
        Set reservedVariables = this.reservedVariables.keySet();
        return reservedVariables.toArray(new String[reservedVariables.size()]);
    }

    public IPath resolveVariablePath(String path) {
        int index = path.indexOf(47);
        if (index != -1) {
            String var = path.substring(0, index);
            IPath varPath = this.getIncludePathVariable(var);
            if (varPath != null && index + 1 < path.length()) {
                varPath = varPath.append(path.substring(index + 1));
            }
            return varPath;
        }
        return this.getIncludePathVariable(path);
    }
}

