/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;

public class ExternalFileWrapper
implements IFile,
IAdaptable,
IResource,
ICoreConstants,
Cloneable,
IPathRequestor {
    private IPath path;
    private IFile file;
    private IContentDescription dummyDescription;

    ExternalFileWrapper(String pathString) {
        this.path = Path.fromOSString((String)pathString);
        Path p = new Path(this.path.toOSString());
        if (this.path.segmentCount() == 1) {
            p = new Path(ExternalFilesRegistry.getInstance().getExternalFilesProject().getFullPath().toOSString());
            p = p.append(this.path.segment(0));
            p = p.setDevice(this.path.getDevice());
        }
        this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)p);
    }

    public IPath getFullPath() {
        return this.path;
    }

    public IPath getLocation() {
        return this.path;
    }

    public void accept(IResourceProxyVisitor visitor, int memberFlags) throws CoreException {
        this.file.accept(visitor, memberFlags);
    }

    public void accept(IResourceVisitor visitor, int depth, boolean includePhantoms) throws CoreException {
        this.file.accept(visitor, depth, includePhantoms);
    }

    public void accept(IResourceVisitor visitor, int depth, int memberFlags) throws CoreException {
        this.file.accept(visitor, depth, memberFlags);
    }

    public void accept(IResourceVisitor visitor) throws CoreException {
        this.file.accept(visitor);
    }

    public void appendContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.file.appendContents(source, force, keepHistory, monitor);
    }

    public void appendContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.file.appendContents(source, updateFlags, monitor);
    }

    public void clearHistory(IProgressMonitor monitor) {
        try {
            this.file.clearHistory(monitor);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    public boolean contains(ISchedulingRule rule) {
        return this.file.contains(rule);
    }

    public void copy(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        this.file.copy(destination, force, monitor);
    }

    public void copy(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.file.copy(destination, updateFlags, monitor);
    }

    public void copy(IProjectDescription description, boolean force, IProgressMonitor monitor) throws CoreException {
        this.file.copy(description, force, monitor);
    }

    public void copy(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.file.copy(description, updateFlags, monitor);
    }

    public void create(InputStream source, boolean force, IProgressMonitor monitor) throws CoreException {
        this.file.create(source, force, monitor);
    }

    public void create(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.file.create(source, updateFlags, monitor);
    }

    public void createLink(IPath localLocation, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.file.createLink(localLocation, updateFlags, monitor);
    }

    public void createLink(URI location, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.file.createLink(location, updateFlags, monitor);
    }

    public IMarker createMarker(String type) throws CoreException {
        return this.file.createMarker(type);
    }

    public IResourceProxy createProxy() {
        return this.file.createProxy();
    }

    public void delete(boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.file.delete(force, keepHistory, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CoreException {
        this.file.delete(force, monitor);
    }

    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.file.delete(updateFlags, monitor);
    }

    public void deleteMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        this.file.deleteMarkers(type, includeSubtypes, depth);
    }

    public boolean equals(Object other) {
        if (other instanceof ExternalFileWrapper) {
            ExternalFileWrapper externalOther = (ExternalFileWrapper)other;
            return this.path.equals((Object)externalOther.path);
        }
        return false;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public IMarker findMarker(long id) {
        try {
            return this.file.findMarker(id);
        }
        catch (CoreException e) {
            Logger.logException(e);
            return null;
        }
    }

    public IMarker[] findMarkers(String type, boolean includeSubtypes, int depth) throws CoreException {
        try {
            return this.file.findMarkers(type, includeSubtypes, depth);
        }
        catch (Exception exception) {
            return new IMarker[0];
        }
    }

    public Object getAdapter(Class adapter) {
        return this.file.getAdapter(adapter);
    }

    public String getCharset() throws CoreException {
        return this.file.getCharset();
    }

    public String getCharset(boolean checkImplicit) throws CoreException {
        return this.file.getCharset(checkImplicit);
    }

    public String getCharsetFor(Reader reader) throws CoreException {
        return this.file.getCharsetFor(reader);
    }

    public IContentDescription getContentDescription() throws CoreException {
        try {
            return this.file.getContentDescription();
        }
        catch (CoreException coreException) {
            return this.getDummyContentDescription();
        }
    }

    private IContentDescription getDummyContentDescription() {
        if (this.dummyDescription == null) {
            this.dummyDescription = new DummyContentDescription();
        }
        return this.dummyDescription;
    }

    public InputStream getContents() throws CoreException {
        try {
            return new FileInputStream(this.path.toFile());
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.core", 4, e.getMessage(), (Throwable)e));
        }
    }

    public InputStream getContents(boolean force) throws CoreException {
        return this.file.getContents(force);
    }

    public int getEncoding() throws CoreException {
        return this.file.getEncoding();
    }

    public String getFileExtension() {
        return this.file.getFileExtension();
    }

    public IFileState[] getHistory(IProgressMonitor monitor) {
        try {
            return this.file.getHistory(monitor);
        }
        catch (CoreException e) {
            Logger.logException(e);
            return new IFileState[0];
        }
    }

    public long getLocalTimeStamp() {
        return this.file.getLocalTimeStamp();
    }

    public URI getLocationURI() {
        return this.file.getLocationURI();
    }

    public IMarker getMarker(long id) {
        return this.file.getMarker(id);
    }

    public long getModificationStamp() {
        return this.file.getModificationStamp();
    }

    public String getName() {
        return this.file.getName();
    }

    public IContainer getParent() {
        return this.file.getParent();
    }

    public String getPersistentProperty(QualifiedName key) throws CoreException {
        return this.file.getPersistentProperty(key);
    }

    public IProject getProject() {
        return ExternalFilesRegistry.getInstance().getExternalFilesProject();
    }

    public IPath getProjectRelativePath() {
        return this.file.getProjectRelativePath();
    }

    public IPath getRawLocation() {
        return this.file.getRawLocation();
    }

    public URI getRawLocationURI() {
        return this.file.getRawLocationURI();
    }

    public ResourceAttributes getResourceAttributes() {
        return this.file.getResourceAttributes();
    }

    public Object getSessionProperty(QualifiedName key) throws CoreException {
        return this.file.getSessionProperty(key);
    }

    public int getType() {
        return this.file.getType();
    }

    public IWorkspace getWorkspace() {
        return this.file.getWorkspace();
    }

    public boolean isAccessible() {
        return this.file.isAccessible();
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return this.file.isConflicting(rule);
    }

    public boolean isDerived() {
        return this.file.isDerived();
    }

    public boolean isLinked() {
        return this.file.isLinked();
    }

    public boolean isLinked(int options) {
        return this.file.isLinked(options);
    }

    public boolean isLocal(int depth) {
        return this.file.isLocal(depth);
    }

    public boolean isPhantom() {
        return this.file.isPhantom();
    }

    public boolean isReadOnly() {
        return this.file.isReadOnly();
    }

    public boolean isSynchronized(int depth) {
        return this.file.isSynchronized(depth);
    }

    public boolean isTeamPrivateMember() {
        return this.file.isTeamPrivateMember();
    }

    public void move(IPath destination, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.file.move(destination, force, keepHistory, monitor);
    }

    public void move(IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        this.file.move(destination, force, monitor);
    }

    public void move(IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.file.move(destination, updateFlags, monitor);
    }

    public void move(IProjectDescription description, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.file.move(description, force, keepHistory, monitor);
    }

    public void move(IProjectDescription description, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.file.move(description, updateFlags, monitor);
    }

    public void refreshLocal(int depth, IProgressMonitor monitor) throws CoreException {
        this.file.refreshLocal(depth, monitor);
    }

    public void revertModificationStamp(long value) throws CoreException {
        this.file.revertModificationStamp(value);
    }

    public void setCharset(String newCharset, IProgressMonitor monitor) throws CoreException {
        this.file.setCharset(newCharset, monitor);
    }

    public void setCharset(String newCharset) throws CoreException {
        this.file.setCharset(newCharset);
    }

    public void setContents(IFileState source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.file.setContents(source, force, keepHistory, monitor);
    }

    public void setContents(IFileState source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.file.setContents(source, updateFlags, monitor);
    }

    public void setContents(InputStream source, boolean force, boolean keepHistory, IProgressMonitor monitor) throws CoreException {
        this.file.setContents(source, force, keepHistory, monitor);
    }

    public void setContents(InputStream source, int updateFlags, IProgressMonitor monitor) throws CoreException {
        this.file.setContents(source, updateFlags, monitor);
    }

    public void setDerived(boolean isDerived) throws CoreException {
        this.file.setDerived(isDerived);
    }

    public void setLocal(boolean flag, int depth, IProgressMonitor monitor) throws CoreException {
        this.file.setLocal(flag, depth, monitor);
    }

    public long setLocalTimeStamp(long value) throws CoreException {
        return this.file.setLocalTimeStamp(value);
    }

    public void setPersistentProperty(QualifiedName key, String value) throws CoreException {
        this.file.setPersistentProperty(key, value);
    }

    public void setReadOnly(boolean readOnly) {
        this.file.setReadOnly(readOnly);
    }

    public void setResourceAttributes(ResourceAttributes attributes) throws CoreException {
        this.file.setResourceAttributes(attributes);
    }

    public void setSessionProperty(QualifiedName key, Object value) throws CoreException {
        this.file.setSessionProperty(key, value);
    }

    public void setTeamPrivateMember(boolean isTeamPrivate) throws CoreException {
        this.file.setTeamPrivateMember(isTeamPrivate);
    }

    public void touch(IProgressMonitor monitor) throws CoreException {
        this.file.touch(monitor);
    }

    public String requestName() {
        return this.getName();
    }

    public IPath requestPath() {
        return this.getFullPath();
    }

    public String toString() {
        return this.getFullPath().toOSString();
    }

    public static synchronized IFile createFile(String pathString) {
        if (File.separatorChar != '\\') {
            pathString = pathString.replace('\\', '/');
        }
        return new ExternalFileWrapper(pathString);
    }

    public int findMaxProblemSeverity(String type, boolean includeSubtypes, int depth) throws CoreException {
        return this.file.findMaxProblemSeverity(type, includeSubtypes, depth);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public Map getPersistentProperties() throws CoreException {
        return this.file.getPersistentProperties();
    }

    public Map getSessionProperties() throws CoreException {
        return this.file.getSessionProperties();
    }

    public boolean isDerived(int options) {
        return this.file.isDerived(options);
    }

    public boolean isHidden() {
        return this.file.isHidden();
    }

    public void setHidden(boolean isHidden) throws CoreException {
        this.file.setHidden(isHidden);
    }

    private static class DummyContentDescription
    implements IContentDescription {
        IContentType contentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);

        public String getCharset() {
            return null;
        }

        public IContentType getContentType() {
            return this.contentType;
        }

        public Object getProperty(QualifiedName key) {
            return null;
        }

        public boolean isRequested(QualifiedName key) {
            return false;
        }

        public void setProperty(QualifiedName key, Object value) {
        }
    }
}

