/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/
package org.eclipse.php.internal.ui.actions;

import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IIDEHelpContextIds;
import org.eclipse.wst.jsdt.internal.core.JavaElement;

public class OpenAction extends SelectionDispatchAction {

	private OpenActionPHP fOpenPHP;
	private org.eclipse.wst.jsdt.ui.actions.OpenAction fOpenJS;

	/**
	 * Creates a new <code>OpenAction</code>. The action requires
	 * that the selection provided by the site's selection provider is of type <code>
	 * org.eclipse.jface.viewers.IStructuredSelection</code>.
	 * 
	 * @param site the site providing context information for this action
	 */
	public OpenAction(IWorkbenchSite site) {
		super(site);
		setText(PHPUIMessages.getString("OpenAction_label"));
		setToolTipText(PHPUIMessages.getString("OpenAction_tooltip"));
		setDescription(PHPUIMessages.getString("OpenAction_description"));
		PlatformUI.getWorkbench().getHelpSystem().setHelp(this, IIDEHelpContextIds.OPEN_RESOURCE_ACTION);
		fOpenPHP = new OpenActionPHP(site);
		fOpenJS = new org.eclipse.wst.jsdt.ui.actions.OpenAction(site);
	}

	/* 
	 * We override this function since we've changed isEnabled() to check its status according to the selection
	 */
	public void selectionChanged(ITextSelection selection) {
		fOpenPHP.selectionChanged(selection);
		fOpenJS.selectionChanged(selection);
	}

	/* 
	 * We override this function since we've changed isEnabled() to check its status according to the selection
	 */
	public void selectionChanged(IStructuredSelection selection) {
		fOpenPHP.selectionChanged(selection);
		fOpenJS.selectionChanged(selection);
	}

	public boolean isEnabled() {
		return fOpenPHP.isEnabled() || fOpenJS.isEnabled();
	}

	/* (non-Javadoc)
	 * Method declared on SelectionDispatchAction.
	 */
	public void run(ITextSelection selection) {
		if (fOpenPHP.isEnabled()) {
			fOpenPHP.run(selection);
		} else if (fOpenJS.isEnabled()) {
			fOpenJS.run(selection);
		}
	}

	/* (non-Javadoc)
	 * Method declared on SelectionDispatchAction.
	 */
	public void run(IStructuredSelection selection) {
		Object firstElement = selection.getFirstElement();
		if (firstElement instanceof JavaElement) {
			fOpenJS.run(selection);
		} else {
			fOpenPHP.run(selection);
		}
	}
}
