/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/
package org.eclipse.php.internal.ui.wizards;

import org.eclipse.php.internal.core.PHPCoreConstants;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class PHPRichProjectWizardBasePage extends PHPProjectWizardBasePage {

	public PHPRichProjectWizardBasePage(IDataModel dataModel, String pageName) {
		super(dataModel, pageName);
	}

	/**
	 * GUI for controlling whether a new PHP project should include JavaScript support or not 
	 * @author alon
	 *
	 */
	public class JavaScriptSupportGroup {

		private final Group fGroup;
		protected Button fEnableJavaScriptSupport;
		protected Link fEnableJavaScriptSupportMessage;

		public JavaScriptSupportGroup(Composite composite, PHPRichProjectWizardBasePage page) {

			fGroup = new Group(composite, SWT.NONE);
			fGroup.setFont(composite.getFont());
			GridLayout layout = new GridLayout();

			fGroup.setLayout(layout);
			GridData data = new GridData(GridData.FILL_BOTH);
			fGroup.setLayoutData(data);
			fGroup.setText(PHPUIMessages.getString("JavaScriptSupportGroup_OptionBlockTitle"));

			Composite checkLinkComposite = new Composite(fGroup, SWT.NONE);
			checkLinkComposite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
			checkLinkComposite.setLayout(new GridLayout(1, false));

			fEnableJavaScriptSupportMessage = new Link(checkLinkComposite, SWT.CHECK);
			fEnableJavaScriptSupportMessage.setText(PHPUIMessages.getString("JavaScriptSupportGroup_EnableSupportMessage")); //$NON-NLS-1$
			fEnableJavaScriptSupportMessage.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));
			fEnableJavaScriptSupportMessage.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/org.eclipse.php.help/html/Setting_the_JavaScript_Build_Path.htm"); //$NON-NLS-1$
				}

			});

			fEnableJavaScriptSupport = new Button(checkLinkComposite, SWT.CHECK);
			fEnableJavaScriptSupport.setText(PHPUIMessages.getString("JavaScriptSupportGroup_EnableSupport")); //$NON-NLS-1$
			fEnableJavaScriptSupport.setLayoutData(new GridData(SWT.BEGINNING, SWT.CENTER, false, false));
			fEnableJavaScriptSupport.setSelection(model.getBooleanProperty(PHPCoreConstants.ADD_JS_NATURE));
		}

		// Stores in the model a property based on the selection of the check-box
		public void setPropertiesInDataModel(IDataModel model) {
			model.setBooleanProperty(PHPCoreConstants.ADD_JS_NATURE, fEnableJavaScriptSupport.getSelection());
		}

	}

	protected JavaScriptSupportGroup fJavaScriptSupportGroup;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jem.util.ui.wizard.WTPWizardPage#createTopLevelComposite(org.eclipse.swt.widgets.Composite)
	 */
	protected Composite createTopLevelComposite(Composite parent) {
		Composite top = super.createTopLevelComposite(parent);

		createJavaScriptSupportGroup(top);
		setHelpContext(top);
		return top;
	}

	protected void createJavaScriptSupportGroup(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout(1, false);
		composite.setLayout(layout);
		fJavaScriptSupportGroup = new JavaScriptSupportGroup(parent, this);
	}

	public void setProjectOptionInModel(IDataModel model) {
		super.setProjectOptionInModel(model);
		fJavaScriptSupportGroup.setPropertiesInDataModel(model);
	}

}