package org.eclipse.php.internal.ui.explorer;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.ui.util.PHPElementSorter;
import org.eclipse.wst.jsdt.core.*;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.internal.ui.preferences.MembersOrderPreferenceCache;

public class ExplorerSorter extends PHPElementSorter {

	private static final int PROJECTS = 1;
	private static final int PACKAGEFRAGMENTROOTS = 2;
	private static final int PACKAGEFRAGMENT = 3;

	private static final int JAVASCRIPTUNITS = 4;
	private static final int CLASSFILES = 5;

	private static final int RESOURCEFOLDERS = 7;
	private static final int RESOURCES = 8;

	private static final int PACKAGE_DECL = 10;
	private static final int IMPORT_CONTAINER = 11;
	private static final int IMPORT_DECLARATION = 12;

	private static final int JAVAELEMENTS = 50;

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ViewerComparator#category(java.lang.Object)
	 */
	@Override
	public int category(Object element) {
		int category = super.category(element);
		if (category != OTHERS) {
			return category;
		}
		if (element instanceof IJavaScriptElement) {
			try {
				IJavaScriptElement je = (IJavaScriptElement) element;

				switch (je.getElementType()) {
					case IJavaScriptElement.METHOD: {
						IFunction method = (IFunction) je;
						if (method.isConstructor()) {
							return getMemberCategory(MembersOrderPreferenceCache.CONSTRUCTORS_INDEX);
						}
						int flags = method.getFlags();
						if (Flags.isStatic(flags))
							return getMemberCategory(MembersOrderPreferenceCache.STATIC_METHODS_INDEX);
						else
							return getMemberCategory(MembersOrderPreferenceCache.METHOD_INDEX);
					}
					case IJavaScriptElement.FIELD: {
						int flags = ((IField) je).getFlags();
						if (Flags.isEnum(flags)) {
							return getMemberCategory(MembersOrderPreferenceCache.ENUM_CONSTANTS_INDEX);
						}
						if (Flags.isStatic(flags))
							return getMemberCategory(MembersOrderPreferenceCache.STATIC_FIELDS_INDEX);
						else
							return getMemberCategory(MembersOrderPreferenceCache.FIELDS_INDEX);
					}
					case IJavaScriptElement.INITIALIZER: {
						int flags = ((IInitializer) je).getFlags();
						if (Flags.isStatic(flags))
							return getMemberCategory(MembersOrderPreferenceCache.STATIC_INIT_INDEX);
						else
							return getMemberCategory(MembersOrderPreferenceCache.INIT_INDEX);
					}
					case IJavaScriptElement.TYPE:
						return getMemberCategory(MembersOrderPreferenceCache.TYPE_INDEX);
					case IJavaScriptElement.PACKAGE_DECLARATION:
						return PACKAGE_DECL;
					case IJavaScriptElement.IMPORT_CONTAINER:
						return IMPORT_CONTAINER;
					case IJavaScriptElement.IMPORT_DECLARATION:
						return IMPORT_DECLARATION;
					case IJavaScriptElement.PACKAGE_FRAGMENT:
						return PACKAGEFRAGMENT;
					case IJavaScriptElement.PACKAGE_FRAGMENT_ROOT:
						return PACKAGEFRAGMENTROOTS;
					case IJavaScriptElement.JAVASCRIPT_PROJECT:
						return PROJECTS;
					case IJavaScriptElement.CLASS_FILE:
						return CLASSFILES;
					case IJavaScriptElement.JAVASCRIPT_UNIT:
						return JAVASCRIPTUNITS;
				}

			} catch (JavaScriptModelException e) {
				if (!e.isDoesNotExist())
					JavaScriptPlugin.log(e);
			}
			return JAVAELEMENTS;
		} else if (element instanceof IFile) {
			return RESOURCES;
		} else if (element instanceof IProject) {
			return PROJECTS;
		} else if (element instanceof IContainer) {
			return RESOURCEFOLDERS;
		} else if (element instanceof IJarEntryResource) {
			if (((IJarEntryResource) element).isFile()) {
				return RESOURCES;
			}
			return RESOURCEFOLDERS;
		} else if (element instanceof PackageFragmentRootContainer) {
			return PACKAGEFRAGMENTROOTS;
		}
		return OTHERS;
	}

}
