/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/
package org.eclipse.php.core.project.build;

import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;

/**
 * This type resolver interface enables extender to "help" the type binding mechanism.
 * Given a pattern it may propose a class identifier   
 * 
 * @author Roy, 2008
 */
public interface ITypeResolver {

	/**
	 * This method resolves the expression's type given an environment
	 * 
	 * @param expression - to be resolved
	 * @param position 
	 * @param lineNumber
	 * @param classes
	 * @param functions
	 * @param projectClasses
	 * @param projectFunctions
	 * 
	 * @return the resolved expression
	 */
	public String resolve(String expression, int position, int lineNumber, PHPClassData[] classes, PHPFunctionData[] functions, CodeData[] projectClasses, CodeData[] projectFunctions);

	/**
	 * Sets the project scope of the resolver
	 * @param project
	 */
	public void setProject(IProject project);
}
