/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;

public abstract class PHPElementResourceMapping
extends ResourceMapping {
    PHPElementResourceMapping() {
    }

    public PHPCodeData getPHPElement() {
        Object o = this.getModelObject();
        if (o instanceof PHPCodeData) {
            return (PHPCodeData)o;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PHPElementResourceMapping)) {
            return false;
        }
        return this.getPHPElement().equals(((PHPElementResourceMapping)((Object)obj)).getPHPElement());
    }

    public int hashCode() {
        PHPCodeData phpElement = this.getPHPElement();
        if (phpElement == null) {
            return super.hashCode();
        }
        return phpElement.hashCode();
    }

    public String getModelProviderId() {
        return "org.eclipse.core.resources.modelProvider";
    }

    public static ResourceMapping create(Object element) {
        if (element instanceof PHPWorkspaceModelManager) {
            return PHPElementResourceMapping.create((PHPWorkspaceModelManager)element);
        }
        if (element instanceof PHPProjectModel) {
            return PHPElementResourceMapping.create((PHPProjectModel)element);
        }
        if (element instanceof PHPFileData) {
            return PHPElementResourceMapping.create((PHPFileData)element);
        }
        if (element instanceof PHPClassData) {
            return PHPElementResourceMapping.create((PHPClassData)element);
        }
        if (element instanceof PHPFunctionData) {
            return PHPElementResourceMapping.create((PHPFunctionData)element);
        }
        return null;
    }

    public static ResourceMapping create(PHPWorkspaceModelManager model) {
        return new PHPModelResourceMapping(model);
    }

    public static ResourceMapping create(PHPProjectModel project) {
        return new PHPProjectResourceMapping(project);
    }

    public static ResourceMapping create(PHPFileData unit) {
        if (unit == null) {
            return null;
        }
        return new CompilationUnitResourceMapping(unit);
    }

    public static ResourceMapping create(PHPClassData clasz) {
        PHPCodeData parent = clasz.getContainer();
        if (parent instanceof PHPFileData) {
            return PHPElementResourceMapping.create((PHPFileData)parent);
        }
        return null;
    }

    public static ResourceMapping create(PHPFunctionData function) {
        PHPCodeData parent = function.getContainer();
        if (parent instanceof PHPFileData) {
            return PHPElementResourceMapping.create((PHPFileData)parent);
        }
        return null;
    }

    private static final class CompilationUnitResourceMapping
    extends PHPElementResourceMapping {
        private final PHPFileData fUnit;

        private CompilationUnitResourceMapping(PHPFileData unit) {
            Assert.isNotNull((Object)unit);
            this.fUnit = unit;
        }

        public Object getModelObject() {
            return this.fUnit;
        }

        public IProject[] getProjects() {
            IResource res = PHPModelUtil.getResource((Object)this.fUnit);
            if (res != null && res.exists()) {
                return new IProject[]{res.getProject()};
            }
            return new IProject[0];
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            IResource res = PHPModelUtil.getResource((Object)this.fUnit);
            if (res != null) {
                return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{PHPModelUtil.getResource((Object)this.fUnit)}, 1, 0)};
            }
            return new ResourceTraversal[0];
        }
    }

    private static final class PHPModelResourceMapping
    extends PHPElementResourceMapping {
        private final PHPWorkspaceModelManager fModel;

        private PHPModelResourceMapping(PHPWorkspaceModelManager model) {
            Assert.isNotNull((Object)model);
            this.fModel = model;
        }

        public Object getModelObject() {
            return this.fModel;
        }

        public IProject[] getProjects() {
            PHPProjectModel[] projects = null;
            projects = this.fModel.listModels();
            IProject[] result = new IProject[projects.length];
            int i = 0;
            while (i < projects.length) {
                result[i] = PHPWorkspaceModelManager.getInstance().getProjectForModel(projects[i]);
                ++i;
            }
            return result;
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            PHPProjectModel[] projects = this.fModel.listModels();
            ResourceTraversal[] result = new ResourceTraversal[projects.length];
            PHPWorkspaceModelManager model = PHPWorkspaceModelManager.getInstance();
            int i = 0;
            while (i < projects.length) {
                result[i] = new ResourceTraversal(new IResource[]{model.getProjectForModel(projects[i])}, 2, 0);
                ++i;
            }
            return result;
        }
    }

    private static final class PHPProjectResourceMapping
    extends PHPElementResourceMapping {
        private final PHPProjectModel fProject;

        private PHPProjectResourceMapping(PHPProjectModel project) {
            Assert.isNotNull((Object)project);
            this.fProject = project;
        }

        public Object getModelObject() {
            return this.fProject;
        }

        public IProject[] getProjects() {
            return new IProject[]{PHPWorkspaceModelManager.getInstance().getProjectForModel(this.fProject)};
        }

        public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
            return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{PHPWorkspaceModelManager.getInstance().getProjectForModel(this.fProject)}, 2, 0)};
        }
    }
}

