/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.treecontent.PHPTreeNode;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ConfigureIncludePathAction
extends SelectionDispatchAction {
    public static final String ID_INCLUDES_NODE = "org.eclipse.php.ui.treecontent.IncludesNode";
    private static final String INCLUDEPATH_PREFERENCES_PAGE_ID = "org.eclipse.php.ui.propertyPages.IncludePathPropertyPage";
    private IProject project;

    public ConfigureIncludePathAction(IWorkbenchSite site) {
        super(site);
        this.setText(PHPUIMessages.getString("ConfigureIncludePathAction_label"));
        this.setToolTipText(PHPUIMessages.getString("ConfigureIncludePathAction_tooltip"));
        this.setDescription(PHPUIMessages.getString("ConfigureIncludePathAction_description"));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.checkEnabled(selection));
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Object firstElement = selection.getFirstElement();
        this.project = this.getProjectFromSelectedElement(firstElement);
        return this.project != null;
    }

    private IProject getProjectFromSelectedElement(Object element) {
        if (element instanceof IProject) {
            return (IProject)element;
        }
        if (element instanceof PHPCodeData) {
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            UserData userData = ((PHPCodeData)element).getUserData();
            if (userData != null) {
                String fileName = userData.getFileName();
                IFile file = wsRoot.getFile((IPath)new Path(fileName));
                return file.getProject();
            }
        }
        if (element instanceof PHPTreeNode && ID_INCLUDES_NODE.equals(((PHPTreeNode)element).getId())) {
            PHPTreeNode treeNode = (PHPTreeNode)element;
            return (IProject)treeNode.getData();
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        if (this.project != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.project, (String)INCLUDEPATH_PREFERENCES_PAGE_ID, null, null).open();
        }
    }

    public Object getElementToOpen(Object object) {
        return object;
    }
}

