/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.internal.ui.actions.ConfigureIncludePathAction;
import org.eclipse.php.internal.ui.actions.RemoveFromIncludePathAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;

public class ConfigureIncludePathActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private boolean fIsEditorOwner;
    private ConfigureIncludePathAction fConfigureIncludePath;
    private RemoveFromIncludePathAction fRemoveFromIncludePathAction;

    public ConfigureIncludePathActionGroup(IViewPart part) {
        this.fSite = part.getSite();
        this.fConfigureIncludePath = new ConfigureIncludePathAction(this.fSite);
        this.fRemoveFromIncludePathAction = new RemoveFromIncludePathAction(this.fSite);
        this.initialize(this.fSite.getSelectionProvider());
    }

    public IAction getOpenAction() {
        return this.fConfigureIncludePath;
    }

    private void initialize(ISelectionProvider provider) {
        ISelection selection = provider.getSelection();
        this.fConfigureIncludePath.update(selection);
        this.fRemoveFromIncludePathAction.update(selection);
        if (!this.fIsEditorOwner) {
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fConfigureIncludePath);
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fRemoveFromIncludePathAction);
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.appendToGroup(menu, (IAction)this.fConfigureIncludePath);
        this.appendToGroup(menu, (IAction)this.fRemoveFromIncludePathAction);
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fConfigureIncludePath);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this.fRemoveFromIncludePathAction);
        super.dispose();
    }

    private void appendToGroup(IMenuManager menu, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup("group.reorganize", (IContributionItem)new Separator());
            menu.appendToGroup("group.reorganize", action);
        }
    }
}

