/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.DeleteResourceAction;

public class DeleteAction
extends SelectionDispatchAction {
    public DeleteAction(IWorkbenchSite site) {
        super(site);
        this.setText(PHPUIMessages.getString("DeleteAction_text"));
        this.setDescription(PHPUIMessages.getString("DeleteAction_desc"));
        ISharedImages workbenchImages = PHPUiPlugin.getDefault().getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.update(this.getSelection());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.delete_resource_action_context");
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (ActionUtils.containsOnlyProjects(selection.toList())) {
            this.setEnabled(this.createWorkbenchAction(selection).isEnabled());
            return;
        }
        Object[] elements = selection.toArray();
        boolean enabled = ActionUtils.isDeleteAvailable(elements);
        if (enabled) {
            enabled = !ActionUtils.arePHPElements(elements);
        }
        this.setEnabled(enabled);
    }

    private IAction createWorkbenchAction(IStructuredSelection selection) {
        DeleteResourceAction action = new DeleteResourceAction(this.getShell());
        action.selectionChanged(selection);
        return action;
    }

    public void run(IStructuredSelection selection) {
        if (ActionUtils.containsOnlyProjects(selection.toList())) {
            this.createWorkbenchAction(selection).run();
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object element : selection.toList()) {
            if (element instanceof PHPFileData) {
                PHPFileData phpFile = (PHPFileData)element;
                list.add(PHPModelUtil.getResource((Object)phpFile));
                continue;
            }
            if (!(element instanceof IFile) && !(element instanceof IFolder)) continue;
            list.add(element);
        }
        if (list.size() == selection.size()) {
            StructuredSelection sel = new StructuredSelection(list);
            this.createWorkbenchAction((IStructuredSelection)sel).run();
            return;
        }
    }
}

