/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.actions.OpenActionUtil;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class SelectionConverter {
    private static final PHPCodeData[] EMPTY_RESULT = new PHPCodeData[0];

    private SelectionConverter() {
    }

    public static IStructuredSelection getStructuredSelection(IWorkbenchPart part) {
        ISelection selection;
        PHPStructuredEditor structuredEditor = EditorUtility.getPHPStructuredEditor(part);
        if (structuredEditor != null) {
            return new StructuredSelection((Object[])SelectionConverter.codeResolve(structuredEditor));
        }
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    public static PHPCodeData[] getElements(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            PHPCodeData[] result = new PHPCodeData[selection.size()];
            int i = 0;
            for (Object element : selection) {
                if (!(element instanceof PHPCodeData)) {
                    return EMPTY_RESULT;
                }
                result[i] = (PHPCodeData)element;
                ++i;
            }
            return result;
        }
        return EMPTY_RESULT;
    }

    public static boolean canOperateOn(PHPStructuredEditor editor) {
        if (editor == null) {
            return false;
        }
        return SelectionConverter.getInput(editor) != null;
    }

    public static PHPCodeData[] codeResolveOrInput(PHPStructuredEditor editor) {
        ITextSelection selection;
        PHPFileData input = SelectionConverter.getInput(editor);
        PHPCodeData[] result = SelectionConverter.codeResolve((PHPCodeData)input, selection = (ITextSelection)editor.getSelectionProvider().getSelection());
        if (result.length == 0) {
            result = new PHPCodeData[]{input};
        }
        return result;
    }

    public static PHPCodeData[] codeResolveOrInputHandled(PHPStructuredEditor editor, Shell shell, String title) {
        return SelectionConverter.codeResolveOrInput(editor);
    }

    public static PHPCodeData codeResolveOrInput(PHPStructuredEditor editor, Shell shell, String title, String message) {
        PHPCodeData[] elements = SelectionConverter.codeResolveOrInput(editor);
        if (elements == null || elements.length == 0) {
            return null;
        }
        PHPCodeData candidate = elements[0];
        if (elements.length > 1) {
            candidate = OpenActionUtil.selectPHPElement(elements, shell, title, message);
        }
        return candidate;
    }

    public static PHPCodeData codeResolveOrInputHandled(PHPStructuredEditor editor, Shell shell, String title, String message) {
        return SelectionConverter.codeResolveOrInput(editor, shell, title, message);
    }

    public static PHPCodeData[] codeResolve(PHPStructuredEditor editor) {
        return SelectionConverter.codeResolve((PHPCodeData)SelectionConverter.getInput(editor), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static PHPCodeData codeResolve(PHPStructuredEditor editor, Shell shell, String title, String message) {
        PHPCodeData[] elements = SelectionConverter.codeResolve(editor);
        if (elements == null || elements.length == 0) {
            return null;
        }
        PHPCodeData candidate = elements[0];
        if (elements.length > 1) {
            candidate = OpenActionUtil.selectPHPElement(elements, shell, title, message);
        }
        return candidate;
    }

    public static PHPCodeData[] codeResolveHandled(PHPStructuredEditor editor, Shell shell, String title) {
        return SelectionConverter.codeResolve(editor);
    }

    public static PHPCodeData getElementAtOffset(PHPStructuredEditor editor) {
        return SelectionConverter.getElementAtOffset((PHPCodeData)SelectionConverter.getInput(editor), (ITextSelection)editor.getSelectionProvider().getSelection());
    }

    public static PHPFileData getInput(PHPStructuredEditor editor) {
        if (editor == null) {
            return null;
        }
        return editor.getPHPFileData();
    }

    public static PHPFileData getInputAsCompilationUnit(PHPStructuredEditor editor) {
        PHPFileData editorInput = SelectionConverter.getInput(editor);
        if (editorInput instanceof PHPFileData) {
            return editorInput;
        }
        return null;
    }

    public static PHPCodeData[] codeResolve(PHPCodeData input, ITextSelection selection) {
        String text = selection.getText();
        if (text == null) {
            return EMPTY_RESULT;
        }
        if ("".equals(text = text.trim())) {
            return EMPTY_RESULT;
        }
        ArrayList<Object> codeDatas = new ArrayList<Object>();
        if (input instanceof PHPFileData && text.matches("^[\\w]+$")) {
            PHPConstantData constantData;
            PHPFunctionData functionData;
            IProject project;
            PHPWorkspaceModelManager modelManager = PHPWorkspaceModelManager.getInstance();
            PHPProjectModel model = modelManager.getModelForProject(project = modelManager.getProjectForFileData((PHPFileData)input, null));
            PHPClassData classData = model.getClass(input.getName(), text);
            if (classData != null) {
                codeDatas.add(classData);
            }
            if ((functionData = model.getFunction(input.getName(), text)) != null) {
                codeDatas.add(functionData);
            }
            if ((constantData = model.getConstant(input.getName(), text)) != null) {
                codeDatas.add(constantData);
            }
            return codeDatas.toArray(new PHPCodeData[codeDatas.size()]);
        }
        return EMPTY_RESULT;
    }

    public static PHPCodeData getElementAtOffset(PHPCodeData input, ITextSelection selection) {
        if (input instanceof PHPFileData) {
            PHPFileData cunit = (PHPFileData)input;
            PHPCodeData ref = PHPModelUtil.getElementAt((PHPCodeData)cunit, (int)selection.getOffset());
            if (ref == null) {
                return input;
            }
            return ref;
        }
        return null;
    }

    public static PHPCodeData resolveEnclosingElement(PHPStructuredEditor editor, ITextSelection selection) {
        return SelectionConverter.resolveEnclosingElement((PHPCodeData)SelectionConverter.getInput(editor), selection);
    }

    public static PHPCodeData resolveEnclosingElement(PHPCodeData input, ITextSelection selection) {
        PHPCodeData atOffset = null;
        if (!(input instanceof PHPFileData)) {
            return null;
        }
        PHPFileData cunit = (PHPFileData)input;
        atOffset = PHPModelUtil.getElementAt((PHPCodeData)cunit, (int)selection.getOffset());
        if (atOffset == null) {
            return input;
        }
        return atOffset;
    }
}

