/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.autoEdit.CaseDefaultAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.CurlyCloseAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.CurlyOpenAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.DocBlockAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.IndentLineAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.MatchingBracketAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.QuotesAutoEditStrategy;
import org.eclipse.php.internal.ui.autoEdit.TabAutoEditStrategy;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class MainAutoEditStrategy
implements IAutoEditStrategy {
    private static IAutoEditStrategy indentLineAutoEditStrategy = new IndentLineAutoEditStrategy();
    private static IAutoEditStrategy curlyOpenAutoEditStrategy = new CurlyOpenAutoEditStrategy();
    private static IAutoEditStrategy curlyCloseAutoEditStrategy = new CurlyCloseAutoEditStrategy();
    private static IAutoEditStrategy matchingBracketAutoEditStrategy = new MatchingBracketAutoEditStrategy();
    private static IAutoEditStrategy quotesAutoEditStrategy = new QuotesAutoEditStrategy();
    private static IAutoEditStrategy caseDefaultAutoEditStrategy = new CaseDefaultAutoEditStrategy();
    private static IAutoEditStrategy docBlockAutoEditStrategy = new DocBlockAutoEditStrategy();
    private static IAutoEditStrategy tabAutoEditStrategy = new TabAutoEditStrategy();

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text == null) {
            return;
        }
        String partitionType = FormatterUtils.getPartitionType((IStructuredDocument)((IStructuredDocument)document), (int)command.offset);
        if (partitionType.equals("org.eclipse.php.PHP_DOC") || partitionType.equals("org.eclipse.php.PHP_MULTI_LINE_COMMENT")) {
            docBlockAutoEditStrategy.customizeDocumentCommand(document, command);
        } else if (partitionType.equals("org.eclipse.php.PHP_QUOTED_STRING")) {
            indentLineAutoEditStrategy.customizeDocumentCommand(document, command);
            quotesAutoEditStrategy.customizeDocumentCommand(document, command);
        } else if (partitionType.equals("org.eclipse.php.PHP_DEFAULT") || partitionType.equals("org.eclipse.php.PHP_SINGLE_LINE_COMMENT")) {
            caseDefaultAutoEditStrategy.customizeDocumentCommand(document, command);
            matchingBracketAutoEditStrategy.customizeDocumentCommand(document, command);
            curlyOpenAutoEditStrategy.customizeDocumentCommand(document, command);
            curlyCloseAutoEditStrategy.customizeDocumentCommand(document, command);
            indentLineAutoEditStrategy.customizeDocumentCommand(document, command);
            tabAutoEditStrategy.customizeDocumentCommand(document, command);
            quotesAutoEditStrategy.customizeDocumentCommand(document, command);
        }
    }
}

