/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.util.CodeDataResolver;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.ExternalFileHyperlink;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.WorkspaceFileHyperlink;
import org.eclipse.php.internal.ui.editor.hover.PHPCodeHyperLink;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.ui.editor.hover.IHyperlinkDetectorForPHP;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class PHPCodeHyperlinkDetector
implements IHyperlinkDetectorForPHP {
    private static final Pattern QUOTES_PATTERN = Pattern.compile("^[\"']|[\"']$");

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null) {
            return null;
        }
        try {
            IDocument document = textViewer.getDocument();
            if (document instanceof IStructuredDocument) {
                IStructuredDocument sDoc = (IStructuredDocument)document;
                IStructuredDocumentRegion sdRegion = sDoc.getRegionAtCharacterOffset(region.getOffset());
                ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(region.getOffset());
                IStructuredDocumentRegion container = sdRegion;
                if (textRegion instanceof ITextRegionContainer) {
                    container = (ITextRegionContainer)textRegion;
                    textRegion = container.getRegionAtCharacterOffset(region.getOffset());
                }
                if (textRegion.getType() == "PHP_CONTENT") {
                    IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)textRegion;
                    ITextRegion phpToken = phpScriptRegion.getPhpToken(region.getOffset() - container.getStartOffset() - phpScriptRegion.getStart());
                    if (PHPPartitionTypes.isPHPQuotesState((String)phpToken.getType())) {
                        ITextRegion prevRegion = phpScriptRegion.getPhpToken(phpToken.getStart() - 1);
                        if (prevRegion != null && prevRegion != null) {
                            IEditorPart editor;
                            PHPStructuredEditor phpEditor;
                            int startOffset = container.getStartOffset() + phpScriptRegion.getStart() + phpToken.getStart();
                            int offsetLength = phpToken.getLength();
                            String fileName = sDoc.get(startOffset, offsetLength);
                            Matcher quotesMatcher = QUOTES_PATTERN.matcher(fileName);
                            fileName = quotesMatcher.replaceAll("");
                            Path path = new Path(fileName);
                            IWorkbenchPage page = PHPUiPlugin.getActivePage();
                            if (page != null && (phpEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)(editor = page.getActiveEditor()))) != null) {
                                IFile currentFile = phpEditor.getFile();
                                IFile file = currentFile.getParent().getFile((IPath)path);
                                if (file == null || !file.exists()) {
                                    IProject currentProject = currentFile.getProject();
                                    file = currentProject.getFile((IPath)path);
                                }
                                if (file != null && file.exists()) {
                                    return new IHyperlink[]{new WorkspaceFileHyperlink((IRegion)new Region(startOffset, offsetLength), file)};
                                }
                            }
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            IWorkspaceRoot root = workspace.getRoot();
                            IProject[] projects = root.getProjects();
                            int i = 0;
                            while (i < projects.length) {
                                IFile file = projects[i].getFile((IPath)path);
                                if (file != null && file.exists()) {
                                    return new IHyperlink[]{new WorkspaceFileHyperlink((IRegion)new Region(startOffset, offsetLength), file)};
                                }
                                ++i;
                            }
                            File file = new File(fileName);
                            if (file.exists()) {
                                return new IHyperlink[]{new ExternalFileHyperlink((IRegion)new Region(startOffset, offsetLength), file)};
                            }
                        }
                    } else {
                        CodeData[] codeDatas = CodeDataResolver.getInstance().resolve(sDoc, region.getOffset());
                        if (codeDatas != null && codeDatas.length != 0 && codeDatas[0].getUserData() != null) {
                            return new IHyperlink[]{new PHPCodeHyperLink(this.selectWord(document, region.getOffset()), codeDatas)};
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    private IRegion selectWord(IDocument document, int anchor) {
        try {
            char c;
            int offset = anchor;
            while (offset >= 0) {
                c = document.getChar(offset);
                if (!Character.isJavaIdentifierPart(c)) break;
                --offset;
            }
            int start = offset;
            offset = anchor;
            int length = document.getLength();
            while (offset < length) {
                c = document.getChar(offset);
                if (!Character.isJavaIdentifierPart(c)) break;
                ++offset;
            }
            int end = offset;
            if (start == end) {
                return new Region(start, 0);
            }
            return new Region(start + 1, end - start - 1);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }
}

