/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentAdapter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextAnnotationHover;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextProjectionAnnotationHover;
import org.eclipse.php.internal.ui.editor.configuration.PHPStructuredTextViewerConfiguration;
import org.eclipse.php.ui.editor.contentassist.IContentAssistProcessorForPHP;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.wst.jsdt.web.ui.SetupProjectsWizzard;
import org.eclipse.wst.sse.core.internal.parser.ForeignRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.TextRegionListImpl;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.ui.internal.StructuredDocumentToTextAdapter;
import org.eclipse.wst.sse.ui.internal.StructuredTextAnnotationHover;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredRegionProcessor;

public class PHPStructuredTextViewer
extends StructuredTextViewer {
    private static final String FORMAT_DOCUMENT_TEXT = "";
    private SourceViewerConfiguration config;
    private ITextEditor textEditor;
    private IInformationPresenter fOutlinePresenter;
    private IAnnotationHover fProjectionAnnotationHover;
    public boolean isUndoOperation;

    public PHPStructuredTextViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
    }

    public PHPStructuredTextViewer(ITextEditor textEditor, Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.textEditor = textEditor;
    }

    public ITextEditor getTextEditor() {
        return this.textEditor;
    }

    public void doOperation(int operation) {
        Point selection = this.getTextWidget().getSelection();
        int cursorPosition = selection.x;
        int selectionLength = selection.y - selection.x;
        int topLine = this.getTextWidget().getTopIndex();
        if (operation == 23) {
            try {
                this.setRedraw(false);
                this.beginRecording(FORMAT_DOCUMENT_TEXT, FORMAT_DOCUMENT_TEXT, cursorPosition, selectionLength);
                Region region = new Region(0, this.getDocument().getLength());
                if (this.fContentFormatter instanceof IContentFormatterExtension) {
                    IContentFormatterExtension extension = (IContentFormatterExtension)this.fContentFormatter;
                    FormattingContext context = new FormattingContext();
                    context.setProperty((Object)"formatting.context.document", (Object)Boolean.TRUE);
                    context.setProperty((Object)"formatting.context.region", (Object)region);
                    extension.format(this.getDocument(), (IFormattingContext)context);
                }
                this.fContentFormatter.format(this.getDocument(), (IRegion)region);
            }
            finally {
                selection = this.getTextWidget().getSelection();
                selectionLength = selection.y - selection.x;
                this.endRecording(cursorPosition, selectionLength);
                this.getTextWidget().setSelection(cursorPosition);
                this.getTextWidget().setTopIndex(topLine);
                this.setRedraw(true);
            }
        } else if (operation == 5) {
            super.doOperation(operation);
        } else if (operation == 13) {
            if (this.config != null) {
                try {
                    IStructuredDocument sDoc = (IStructuredDocument)this.getDocument();
                    int selectionOffset = this.getSelectedRange().x;
                    IStructuredDocumentRegion sdRegion = sDoc.getRegionAtCharacterOffset(selectionOffset);
                    if (sdRegion != null) {
                        IFile file;
                        boolean isJavaScriptRegion = false;
                        ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(selectionOffset);
                        if (textRegion instanceof ForeignRegion) {
                            isJavaScriptRegion = textRegion.getType() == "BLOCK_TEXT";
                        }
                        boolean hasJavaScriptNature = true;
                        IProject project = null;
                        if (this.textEditor instanceof PHPStructuredEditor && (file = ((PHPStructuredEditor)this.textEditor).getFile()) != null && (project = file.getProject()) != null && project.getNature("org.eclipse.wst.jsdt.core.jsNature") == null) {
                            hasJavaScriptNature = false;
                        }
                        if (isJavaScriptRegion && !hasJavaScriptNature) {
                            int addJavaScriptSupport = OptionalMessageDialog.open((String)"PROMPT_ADD_JAVASCRIPT_SUPPORT", (Shell)PHPUiPlugin.getActiveWorkbenchShell(), (String)PHPUIMessages.getString("PHPStructuredTextViewer.0"), null, (String)PHPUIMessages.getString("PHPStructuredTextViewer.1"), (int)3, (String[])new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, (int)0);
                            if (addJavaScriptSupport == 0 && project != null) {
                                SetupProjectsWizzard wiz = new SetupProjectsWizzard();
                                wiz.selectionChanged(null, (ISelection)new StructuredSelection((Object)project));
                                wiz.run(null);
                            }
                            return;
                        }
                    }
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }
            if (this.config != null) {
                IContentAssistProcessor[] all;
                PHPStructuredTextViewerConfiguration structuredTextViewerConfiguration = (PHPStructuredTextViewerConfiguration)this.config;
                IContentAssistProcessor[] iContentAssistProcessorArray = all = structuredTextViewerConfiguration.getContentAssistProcessors((ISourceViewer)this, "org.eclipse.php.PHP_DEFAULT");
                int n = all.length;
                int n2 = 0;
                while (n2 < n) {
                    IContentAssistProcessor element = iContentAssistProcessorArray[n2];
                    if (element instanceof IContentAssistProcessorForPHP) {
                        ((IContentAssistProcessorForPHP)element).explicitActivationRequest();
                    }
                    ++n2;
                }
            }
            super.doOperation(operation);
        } else if (operation == 22) {
            if (this.fOutlinePresenter != null) {
                this.fOutlinePresenter.showInformation();
            }
        } else if (operation == 1) {
            try {
                this.isUndoOperation = true;
                super.doOperation(operation);
            }
            finally {
                this.isUndoOperation = false;
            }
        } else {
            super.doOperation(operation);
        }
    }

    private void beginRecording(String label, String description, int cursorPosition, int selectionLength) {
        IDocument doc = this.getDocument();
        if (doc instanceof IStructuredDocument) {
            IStructuredDocument structuredDocument = (IStructuredDocument)doc;
            IStructuredTextUndoManager undoManager = structuredDocument.getUndoManager();
            undoManager.beginRecording((Object)this, label, description, cursorPosition, selectionLength);
        }
    }

    private void endRecording(int cursorPosition, int selectionLength) {
        IDocument doc = this.getDocument();
        if (doc instanceof IStructuredDocument) {
            IStructuredDocument structuredDocument = (IStructuredDocument)doc;
            IStructuredTextUndoManager undoManager = structuredDocument.getUndoManager();
            undoManager.endRecording((Object)this, cursorPosition, selectionLength);
        }
    }

    protected IDocumentAdapter createDocumentAdapter() {
        return new StructuredDocumentToTextAdapterForPhp(this.getTextWidget());
    }

    public void addVerticalRulerColumn(IVerticalRulerColumn column) {
        if (this.fProjectionAnnotationHover == null) {
            this.fProjectionAnnotationHover = new PHPStructuredTextProjectionAnnotationHover();
        }
        ((AnnotationRulerColumn)column).setHover(this.fProjectionAnnotationHover);
        super.addVerticalRulerColumn(column);
    }

    public void configure(SourceViewerConfiguration configuration) {
        super.configure(configuration);
        if (this.fAnnotationHover instanceof StructuredTextAnnotationHover) {
            ((StructuredTextAnnotationHover)this.fAnnotationHover).release();
        }
        this.setAnnotationHover((IAnnotationHover)new PHPStructuredTextAnnotationHover());
        this.ensureAnnotationHoverManagerInstalled();
        if (!(configuration instanceof PHPStructuredTextViewerConfiguration)) {
            return;
        }
        this.config = configuration;
        PHPStructuredTextViewerConfiguration phpConfiguration = (PHPStructuredTextViewerConfiguration)configuration;
        IContentAssistant newPHPAssistant = phpConfiguration.getPHPContentAssistant((ISourceViewer)this, true);
        if (this.fContentAssistant != null) {
            this.fContentAssistant.uninstall();
        }
        this.fContentAssistant = newPHPAssistant;
        if (this.fContentAssistant != null) {
            this.fContentAssistant.install((ITextViewer)this);
            this.fContentAssistantInstalled = true;
        } else {
            this.enableOperation(13, false);
        }
        this.fOutlinePresenter = phpConfiguration.getOutlinePresenter((ISourceViewer)this);
        if (this.fOutlinePresenter != null) {
            this.fOutlinePresenter.install((ITextViewer)this);
        }
    }

    protected void ensureAnnotationHoverManagerInstalled() {
        if (this.fAnnotationHover instanceof PHPStructuredTextAnnotationHover) {
            super.ensureAnnotationHoverManagerInstalled();
        }
    }

    public int modelLine2WidgetLine(int modelLine) {
        try {
            return super.modelLine2WidgetLine(modelLine);
        }
        catch (IllegalStateException illegalStateException) {
            return -1;
        }
    }

    protected int getClosestWidgetLineForModelLine(int modelLine) {
        try {
            return super.getClosestWidgetLineForModelLine(modelLine);
        }
        catch (IllegalStateException illegalStateException) {
            return -1;
        }
    }

    public void reconcile() {
        ((StructuredRegionProcessor)this.fReconciler).processDirtyRegion(new DirtyRegion(0, this.getDocument().getLength(), "__insert", this.getDocument().get()));
    }

    public class StructuredDocumentToTextAdapterForPhp
    extends StructuredDocumentToTextAdapter {
        public StructuredDocumentToTextAdapterForPhp() {
        }

        public StructuredDocumentToTextAdapterForPhp(StyledText styledTextWidget) {
            super(styledTextWidget);
        }

        protected void redrawRegionChanged(RegionChangedEvent structuredDocumentEvent) {
            if (structuredDocumentEvent != null && structuredDocumentEvent.getRegion() != null && structuredDocumentEvent.getRegion().getType() == "PHP_CONTENT") {
                IPhpScriptRegion region = (IPhpScriptRegion)structuredDocumentEvent.getRegion();
                if (region.isFullReparsed()) {
                    TextRegionListImpl newList = new TextRegionListImpl();
                    newList.add((ITextRegion)region);
                    IStructuredDocumentRegion structuredDocumentRegion = structuredDocumentEvent.getStructuredDocumentRegion();
                    IStructuredDocument structuredDocument = structuredDocumentEvent.getStructuredDocument();
                    RegionsReplacedEvent regionsReplacedEvent = new RegionsReplacedEvent(structuredDocument, (Object)structuredDocumentRegion, structuredDocumentRegion, null, (ITextRegionList)newList, null, 0, 0);
                    this.redrawRegionsReplaced(regionsReplacedEvent);
                } else {
                    region.setFullReparsed(true);
                }
            }
            super.redrawRegionChanged(structuredDocumentEvent);
        }
    }
}

