/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionRendererVisitor;
import org.eclipse.php.internal.ui.editor.contentassist.PHPContextInfoRendererVisitor;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.util.PHPCodeDataHTMLDescriptionUtilities;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CodeDataCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4 {
    private static final PHPCompletionRendererVisitor rendererVisitor = new PHPCompletionRendererVisitor();
    private static final PHPContextInfoRendererVisitor contextRendererVisitor = new PHPContextInfoRendererVisitor();
    protected static final char[] phpDelimiters = new char[]{'?', ':', ';', '|', '^', '&', '<', '>', '+', '-', '.', '*', '/', '%', '!', '~', '[', ']', '(', ')', '{', '}', '@', '\n', '\t', ' ', ',', '$', '\'', '\"'};
    private String displayText;
    private Image displayImage;
    private CodeData codeData;
    protected int replacementOffset;
    protected int replacementLength;
    protected int selectionLength;
    private String replacementString;
    private String prefix;
    private String suffix;
    private int caretOffsetInSuffix;
    private PHPProjectModel projectModel;
    private ContextInformation contextInfo;
    private boolean showTypeHints;
    private int offset;

    public CodeDataCompletionProposal(PHPProjectModel projectModel, CodeData codeData, int offset, int length, int selectionLength, String prefix, String suffix, int caretOffsetInSuffix, boolean showTypeHints) {
        this.codeData = codeData;
        this.replacementOffset = offset;
        this.replacementLength = length;
        this.selectionLength = selectionLength;
        this.prefix = prefix;
        this.suffix = suffix;
        this.caretOffsetInSuffix = caretOffsetInSuffix;
        this.showTypeHints = showTypeHints;
        this.projectModel = projectModel;
        this.offset = offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    protected String getReplacementString() {
        if (this.replacementString == null) {
            this.replacementString = String.valueOf(this.prefix) + this.codeData.getName() + this.suffix;
        }
        return this.replacementString;
    }

    public void apply(IDocument document) {
        try {
            boolean insertCompletion = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistInsertCompletion");
            if (!insertCompletion) {
                this.removeTrailingCharacters(document);
            }
            document.replace(this.replacementOffset, this.replacementLength + this.selectionLength, this.getReplacementString());
        }
        catch (BadLocationException badLocationException) {}
    }

    protected void removeTrailingCharacters(IDocument document) {
        try {
            int position = this.replacementOffset + this.replacementLength + this.selectionLength;
            IRegion line = document.getLineInformationOfOffset(position);
            int end = line.getOffset() + line.getLength();
            while (position < end) {
                char ch = document.getChar(position);
                if (CodeDataCompletionProposal.isDelimeter(ch, phpDelimiters)) {
                    if (this.suffix.startsWith(String.valueOf(ch))) {
                        this.suffix = "";
                    }
                    break;
                }
                ++this.replacementLength;
                ++position;
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private static final boolean isDelimeter(char ch, char[] delimeters) {
        char[] cArray = delimeters;
        int n = delimeters.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            if (ch == element) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        this.apply(document);
        int replacementPosition = this.replacementOffset + this.getReplacementString().length() - this.suffix.length() + this.caretOffsetInSuffix;
        viewer.getSelectionProvider().setSelection((ISelection)new TextSelection(document, replacementPosition, 0));
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        String enteredText = "";
        try {
            enteredText = document.get(this.replacementOffset, offset - this.replacementOffset);
        }
        catch (BadLocationException badLocationException) {}
        boolean valid = this.codeData.getName().toLowerCase().startsWith(enteredText.toLowerCase());
        if (valid) {
            this.replacementLength = enteredText.length();
        }
        return valid;
    }

    public boolean isAutoInsertable() {
        return true;
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        if (this.projectModel != null) {
            return PHPCodeDataHTMLDescriptionUtilities.getHTMLHyperlinkDescriptionText(this.codeData, this.projectModel);
        }
        return null;
    }

    public IContextInformation getContextInformation() {
        if (!this.showTypeHints) {
            return null;
        }
        if (this.contextInfo == null) {
            contextRendererVisitor.init(this.projectModel, this.codeData);
            String contextInfoString = contextRendererVisitor.getDisplayString().trim();
            if (contextInfoString.length() > 0) {
                this.contextInfo = new ContextInformation(null, contextRendererVisitor.getDisplayString());
            }
        }
        return this.contextInfo;
    }

    public String getDisplayString() {
        this.initialize();
        return this.displayText;
    }

    public Image getImage() {
        this.initialize();
        return this.displayImage;
    }

    private void initialize() {
        if (this.displayText != null) {
            return;
        }
        rendererVisitor.init(this.codeData);
        this.displayText = rendererVisitor.getDisplayString();
        this.displayImage = rendererVisitor.getImage();
    }

    public IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.prefix;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.replacementOffset;
    }

    public CodeData getCodeData() {
        return this.codeData;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("proposal: ").append(this.displayText);
        buffer.append(" name: ").append(this.codeData != null ? this.codeData.getName() : "empty");
        buffer.append(" type: ").append(this.codeData != null ? this.codeData.getClass().toString() : "empty");
        buffer.append(" prefix: ").append(this.prefix);
        buffer.append(" suffix: ").append(this.suffix);
        return buffer.toString();
    }

    PHPProjectModel getProjectModel() {
        return this.projectModel;
    }

    int getOffset() {
        return this.replacementOffset;
    }

    int getLength() {
        return this.replacementLength;
    }

    int getSelectionLength() {
        return this.selectionLength;
    }

    String getPrefix() {
        return this.prefix;
    }

    String getSuffix() {
        return this.suffix;
    }

    int getCaretOffsetInSuffix() {
        return this.caretOffsetInSuffix;
    }

    boolean getShowHints() {
        return this.showTypeHints;
    }
}

