/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.ui.editor.contentassist.ContentAssistSupport;
import org.eclipse.php.internal.ui.editor.contentassist.PHPContextInformationValidator;
import org.eclipse.php.internal.ui.text.PHPCodeReader;
import org.eclipse.php.ui.editor.contentassist.IContentAssistProcessorForPHP;
import org.eclipse.php.ui.editor.contentassist.IContentAssistSupport;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class PHPContentAssistProcessor
implements IContentAssistProcessorForPHP {
    protected IContentAssistSupport support;
    protected PHPContextInformationValidator contextInformationValidator = new PHPContextInformationValidator();
    protected static final char[] contextInformationActivationChars = new char[]{'(', ','};
    private boolean isExplicitRequest = false;

    public PHPContentAssistProcessor() {
        this.support = this.createContentAssistSupport();
    }

    public IContentAssistSupport createContentAssistSupport() {
        return new ContentAssistSupport();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] completionProposals;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        if (modelManager == null) {
            return new ICompletionProposal[0];
        }
        IStructuredModel structuredModel = null;
        structuredModel = modelManager.getExistingModelForRead(viewer.getDocument());
        if (structuredModel == null) {
            return new ICompletionProposal[0];
        }
        try {
            DOMModelForPHP phpDOMModel = (DOMModelForPHP)structuredModel;
            try {
                completionProposals = this.support.getCompletionOption(viewer, phpDOMModel, offset, this.isExplicitRequest);
            }
            catch (Exception e) {
                Logger.logException((Throwable)e);
                ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[]{};
                structuredModel.releaseFromRead();
                this.isExplicitRequest = false;
                return iCompletionProposalArray;
            }
            if (completionProposals == null) {
                completionProposals = new ICompletionProposal[]{};
            }
        }
        finally {
            structuredModel.releaseFromRead();
            this.isExplicitRequest = false;
        }
        return completionProposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        int contextInformationPosition = this.guessContextInformationPosition(viewer, offset);
        if (contextInformationPosition == -1) {
            return null;
        }
        ICompletionProposal[] proposals = this.computeCompletionProposals(viewer, contextInformationPosition);
        ArrayList<ContextInformationWrapper> contextInfo = new ArrayList<ContextInformationWrapper>();
        int shortestName = Integer.MAX_VALUE;
        int i = 0;
        while (i < proposals.length) {
            int nameLength;
            if (proposals[i].getContextInformation() != null && (nameLength = proposals[i].getDisplayString().length()) < shortestName) {
                shortestName = nameLength;
            }
            ++i;
        }
        i = 0;
        while (i < proposals.length) {
            IContextInformation info = proposals[i].getContextInformation();
            if (info != null && proposals[i].getDisplayString().length() == shortestName) {
                ContextInformationWrapper contextInformation = new ContextInformationWrapper(info);
                contextInformation.setContextInformationPosition(contextInformationPosition + 1);
                contextInfo.add(contextInformation);
            }
            ++i;
        }
        return contextInfo.toArray(new IContextInformation[contextInfo.size()]);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.support.getAutoactivationTriggers();
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return contextInformationActivationChars;
    }

    public String getErrorMessage() {
        return null;
    }

    public final IContextInformationValidator getContextInformationValidator() {
        if (this.getClass().equals(PHPContentAssistProcessor.class)) {
            return this.contextInformationValidator;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int guessContextInformationPosition(ITextViewer viewer, int offset) {
        IDocument document = viewer.getDocument();
        try {
            PHPCodeReader reader = new PHPCodeReader();
            reader.configureBackwardReader(document, offset, true, true);
            int nestingLevel = 0;
            int curr = reader.read();
            while (true) {
                if (curr == -1) {
                    return -1;
                }
                if (')' == (char)curr) {
                    ++nestingLevel;
                } else if ('(' == (char)curr && --nestingLevel < 0) {
                    if (!this.looksLikeMethod(reader)) return -1;
                    return reader.getOffset() + 1;
                }
                curr = reader.read();
            }
        }
        catch (IOException iOException) {}
        return -1;
    }

    private boolean looksLikeMethod(PHPCodeReader reader) throws IOException {
        int curr = reader.read();
        while (curr != -1 && Character.isWhitespace((char)curr)) {
            curr = reader.read();
        }
        if (curr == -1) {
            return false;
        }
        return Character.isJavaIdentifierPart((char)curr) || Character.isJavaIdentifierStart((char)curr);
    }

    public void explicitActivationRequest() {
        this.isExplicitRequest = true;
    }

    public void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        this.support.handlePreferenceStoreChanged(event);
    }

    private static final class ContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private final IContextInformation fContextInformation;
        private int fPosition;

        public ContextInformationWrapper(IContextInformation contextInformation) {
            this.fContextInformation = contextInformation;
        }

        public String getContextDisplayString() {
            return this.fContextInformation.getContextDisplayString();
        }

        public Image getImage() {
            return this.fContextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.fContextInformation.getInformationDisplayString();
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public void setContextInformationPosition(int position) {
            this.fPosition = position;
        }

        public boolean equals(Object object) {
            if (object instanceof ContextInformationWrapper) {
                return this.fContextInformation.equals((Object)((ContextInformationWrapper)object).fContextInformation);
            }
            return this.fContextInformation.equals(object);
        }
    }
}

