/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.SimplePHPCodeDataVisitor;
import org.eclipse.php.internal.core.util.Visitor;

public class PHPContextInfoRendererVisitor
extends SimplePHPCodeDataVisitor {
    private String text;
    protected StringBuffer buffer = new StringBuffer();
    private PHPProjectModel projectModel;

    public void init(PHPProjectModel projectModel, CodeData codeData) {
        this.projectModel = projectModel;
        this.buffer.setLength(0);
        codeData.accept((Visitor)this);
        this.text = this.buffer.toString();
    }

    public String getDisplayString() {
        return this.text;
    }

    public void visit(CodeData codeData) {
        this.buffer.append(codeData.getName());
    }

    public void visit(PHPFunctionData codeData) {
        PHPFunctionData.PHPFunctionParameter[] parameters = codeData.getParameters();
        int i = 0;
        while (i < parameters.length) {
            if (i != 0) {
                this.buffer.append(", ");
            }
            this.visit(parameters[i]);
            ++i;
        }
    }

    public void visit(PHPClassVarData codeData) {
    }

    public void visit(PHPClassConstData codeData) {
    }

    public void visit(PHPConstantData codeData) {
    }

    public void visit(PHPClassData codeData) {
        PHPFunctionData constructor;
        PHPFunctionData pHPFunctionData = constructor = codeData.getUserData() != null ? PHPModelUtil.getRealConstructor((PHPProjectModel)this.projectModel, (String)codeData.getUserData().getFileName(), (PHPClassData)codeData) : null;
        if (constructor != null) {
            this.visit(constructor);
        }
    }

    public void visit(PHPKeywordData codeData) {
    }

    public void visit(PHPVariableData codeData) {
    }

    public void visit(PHPFunctionData.PHPFunctionParameter codeData) {
        String classType = codeData.getClassType();
        if (classType != null && classType.length() != 0) {
            this.buffer.append(classType);
            this.buffer.append(" ");
        }
        if (codeData.isConst()) {
            this.buffer.append("const ");
        }
        if (codeData.isReference()) {
            this.buffer.append("&");
        }
        this.buffer.append("$");
        this.buffer.append(codeData.getName());
        String defaultValue = codeData.getDefaultValue();
        if (defaultValue != null && defaultValue.length() != 0) {
            this.buffer.append(" = ");
            this.buffer.append(defaultValue);
        }
    }
}

