/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.ui.editor.contentassist.PHPDocContentAssistSupport;
import org.eclipse.php.ui.editor.contentassist.IContentAssistProcessorForPHP;
import org.eclipse.php.ui.editor.contentassist.IContentAssistSupport;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class PHPDocContentAssistProcessor
implements IContentAssistProcessorForPHP {
    private IContentAssistSupport support = this.createContentAssistSupport();
    private boolean isExplicitRequest = false;

    public IContentAssistSupport createContentAssistSupport() {
        return new PHPDocContentAssistSupport();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] completionProposals;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        if (modelManager == null) {
            return null;
        }
        IStructuredModel structuredModel = null;
        structuredModel = modelManager.getExistingModelForRead(viewer.getDocument());
        if (structuredModel == null) {
            return null;
        }
        try {
            DOMModelForPHP phpDOMModel = (DOMModelForPHP)structuredModel;
            try {
                completionProposals = this.support.getCompletionOption(viewer, phpDOMModel, offset, this.isExplicitRequest);
            }
            catch (Exception e) {
                Logger.logException((Throwable)e);
                structuredModel.releaseFromRead();
                this.isExplicitRequest = false;
                return null;
            }
            if (completionProposals == null) {
                completionProposals = new ICompletionProposal[]{};
            }
        }
        finally {
            structuredModel.releaseFromRead();
            this.isExplicitRequest = false;
        }
        return completionProposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.support.getAutoactivationTriggers();
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public void explicitActivationRequest() {
        this.isExplicitRequest = true;
    }

    public void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        this.support.handlePreferenceStoreChanged(event);
    }
}

