/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hover;

import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.ui.editor.hover.IHoverMessageDecorator;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.derived.HTMLTextPresenter;

public abstract class AbstractPHPTextHover
implements IPHPTextHover,
ITextHoverExtension {
    protected Pattern tab = Pattern.compile("\t");
    protected IEditorPart fEditor;
    private final IBindingService fBindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);

    public IEditorPart getEditorPart() {
        return this.fEditor;
    }

    public void setEditorPart(IEditorPart editorPart) {
        this.fEditor = editorPart;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer == null || textViewer.getDocument() == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = ((IStructuredDocument)textViewer.getDocument()).getRegionAtCharacterOffset(offset);
        ITextRegion region = null;
        if (flatNode != null) {
            region = flatNode.getRegionAtCharacterOffset(offset);
        }
        IStructuredDocumentRegion container = flatNode;
        if (region instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)region;
            region = container.getRegionAtCharacterOffset(offset);
        }
        if (region.getType() == "PHP_CONTENT") {
            IPhpScriptRegion phpScriptRegion = (IPhpScriptRegion)region;
            try {
                region = phpScriptRegion.getPhpToken(offset - container.getStartOffset() - region.getStart());
            }
            catch (BadLocationException badLocationException) {
                region = null;
            }
            if (region != null) {
                return new Region(container.getStartOffset() + phpScriptRegion.getStart() + region.getStart(), region.getLength());
            }
        }
        return null;
    }

    protected String getTooltipAffordanceString() {
        if (this.fBindingService == null) {
            return null;
        }
        String keySequence = this.fBindingService.getBestActiveBindingFormattedFor("org.eclipse.php.ui.edit.text.show.phpdoc");
        if (keySequence == null) {
            return null;
        }
        return NLS.bind((String)PHPUIMessages.getString("HoverFocus_message"), (Object)keySequence);
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true), AbstractPHPTextHover.this.getTooltipAffordanceString());
            }
        };
    }

    public IHoverMessageDecorator getMessageDecorator() {
        return null;
    }
}

