/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.input;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.editors.text.ILocationProvider;

public class NonExistingPHPFileEditorInput
implements IEditorInput,
ILocationProvider {
    private static int fgNonExisting = 0;
    private IFileStore fFileStore;
    private String fName;

    public NonExistingPHPFileEditorInput(IFileStore fileStore, String namePrefix) {
        Assert.isNotNull((Object)fileStore);
        Assert.isTrue((boolean)"file".equals(fileStore.getFileSystem().getScheme()));
        this.fFileStore = fileStore;
        this.fName = String.valueOf(namePrefix) + ++fgNonExisting + ".php";
    }

    public NonExistingPHPFileEditorInput(IPath fullPath) {
        Assert.isNotNull((Object)fullPath);
        IFileStore fileStore = null;
        String pathName = fullPath.toString();
        if (pathName.endsWith(".php")) {
            fileStore = EFS.getLocalFileSystem().getStore(fullPath.removeLastSegments(1));
            this.fName = fullPath.lastSegment();
        } else {
            fileStore = EFS.getLocalFileSystem().getStore(fullPath);
            this.fName = "PHPDocument" + ++fgNonExisting + ".php";
        }
        Assert.isTrue((boolean)"file".equals(fileStore.getFileSystem().getScheme()));
        this.fFileStore = fileStore;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fName;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fName;
    }

    public Object getAdapter(Class adapter) {
        if (ILocationProvider.class == adapter) {
            return this;
        }
        if (IResource.class == adapter) {
            return ExternalFilesRegistry.getInstance().getFileEntry(this.getPath().toOSString());
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IPath getPath() {
        return this.getPath(this);
    }

    public IPath getPath(Object element) {
        if (element instanceof NonExistingPHPFileEditorInput) {
            NonExistingPHPFileEditorInput input = (NonExistingPHPFileEditorInput)element;
            String path = input.fFileStore.toURI().getPath();
            if (path.endsWith(".php")) {
                return new Path(path);
            }
            return new Path(String.valueOf(path) + File.separatorChar + this.fName);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NonExistingPHPFileEditorInput) {
            NonExistingPHPFileEditorInput input = (NonExistingPHPFileEditorInput)o;
            return this.fFileStore.equals(input.fFileStore) && this.fName.equals(input.fName);
        }
        return false;
    }

    public int hashCode() {
        return this.fFileStore.hashCode();
    }
}

