/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.reconcile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredReconcileStep;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

public class ReconcileStepForPHP
extends StructuredReconcileStep {
    protected IReconcileResult[] reconcileModel(DirtyRegion dirtyRegion, IRegion subRegion) {
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead((IDocument)this.getStructuredDocument());
        IReconcileResult[] results = this.EMPTY_RECONCILE_RESULT_SET;
        try {
            if (sModel != null) {
                DOMModelForPHP model = (DOMModelForPHP)sModel;
                model.updateFileData();
                PHPFileData fileData = model.getFileData();
                if (fileData == null) {
                    IReconcileResult[] iReconcileResultArray = this.EMPTY_RECONCILE_RESULT_SET;
                    return iReconcileResultArray;
                }
                IPHPMarker[] markers = fileData.getMarkers();
                ArrayList<IReconcileResult> annotations = new ArrayList<IReconcileResult>();
                if (markers != null) {
                    int i = 0;
                    while (markers.length > i) {
                        IReconcileResult annotation = this.createAnnotation(markers[i]);
                        if (annotation != null) {
                            annotations.add(annotation);
                        }
                        ++i;
                    }
                }
                results = annotations.toArray(new IReconcileResult[annotations.size()]);
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return results;
    }

    protected IReconcileResult[] createAnnotations(List messageList) {
        ArrayList<TemporaryAnnotation> annotations = new ArrayList<TemporaryAnnotation>();
        int i = 0;
        while (i < messageList.size()) {
            block11: {
                IMessage validationMessage = (IMessage)messageList.get(i);
                int offset = validationMessage.getOffset();
                if (offset >= 0) {
                    String messageText = null;
                    try {
                        messageText = validationMessage.getText(validationMessage.getClass().getClassLoader());
                    }
                    catch (Exception t) {
                        Logger.logException((String)"exception reporting message from validator", (Throwable)t);
                        break block11;
                    }
                    String type = "org.eclipse.wst.sse.ui.temp.info";
                    switch (validationMessage.getSeverity()) {
                        case 1: {
                            type = "org.eclipse.wst.sse.ui.temp.error";
                            break;
                        }
                        case 2: {
                            type = "org.eclipse.wst.sse.ui.temp.warning";
                            break;
                        }
                        case 4: {
                            type = "org.eclipse.wst.sse.ui.temp.warning";
                            break;
                        }
                        case 3: {
                            type = "org.eclipse.wst.sse.ui.temp.warning";
                        }
                    }
                    int length = validationMessage.getLength();
                    if (length >= 0) {
                        Position p = new Position(offset, length);
                        IStructuredDocument structuredDocument = this.getStructuredDocument();
                        ReconcileAnnotationKey key = this.createKey(structuredDocument.getRegionAtCharacterOffset(offset), 0);
                        annotations.add(new TemporaryAnnotation(p, type, messageText, key));
                    }
                }
            }
            ++i;
        }
        return annotations.toArray(new IReconcileResult[annotations.size()]);
    }

    protected IReconcileResult createAnnotation(IPHPMarker marker) {
        String descr = marker.getDescription();
        UserData userData = marker.getUserData();
        int offset = userData.getStartPosition();
        int endPos = userData.getEndPosition();
        int length = endPos - offset;
        LocalizedMessage mess = new LocalizedMessage(1, descr);
        if (offset < 0 || length < 0) {
            return null;
        }
        String messageText = null;
        try {
            messageText = mess.getText(mess.getClass().getClassLoader());
        }
        catch (Exception t) {
            Logger.logException((String)"exception reporting message from validator", (Throwable)t);
            return null;
        }
        String type = "org.eclipse.wst.sse.ui.temp.info";
        String markerType = marker.getType();
        if (markerType.equals("TASK")) {
            type = "org.eclipse.wst.sse.ui.temp.info";
        } else if (markerType.equals("ERROR")) {
            type = "org.eclipse.wst.sse.ui.temp.error";
        } else if (markerType.equals("WARNING")) {
            type = "org.eclipse.wst.sse.ui.temp.warning";
        }
        Position p = new Position(offset, length);
        IStructuredDocument structuredDocument = this.getStructuredDocument();
        ReconcileAnnotationKey key = this.createKey(structuredDocument.getRegionAtCharacterOffset(offset), 0);
        return new TemporaryAnnotation(p, type, messageText, key);
    }
}

