/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.templates.resolver;

import java.util.ArrayList;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableTypeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariablesTypeManager;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.editor.templates.PhpTemplateContext;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class PhpTemplateVariableResolver
extends TemplateVariableResolver {
    private static final String DEFAULT_VAR = "var";

    public PhpTemplateVariableResolver() {
        super("variable", PHPUIMessages.getString("PhpTemplateVariableResolver.2"));
    }

    protected String[] resolveAll(TemplateContext context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        PhpTemplateContext phpTemplateContext = (PhpTemplateContext)context;
        IModelManager modelManager = StructuredModelManager.getModelManager();
        if (modelManager == null) {
            return new String[]{DEFAULT_VAR};
        }
        IStructuredModel structuredModel = modelManager.getExistingModelForRead(phpTemplateContext.getDocument());
        if (structuredModel == null) {
            return new String[]{DEFAULT_VAR};
        }
        try {
            DOMModelForPHP phpDOMModel = (DOMModelForPHP)structuredModel;
            PHPFileData fileData = phpDOMModel.getFileData();
            if (fileData == null) {
                String[] stringArray = new String[]{DEFAULT_VAR};
                return stringArray;
            }
            PHPCodeContext phpCodeContext = ModelSupport.createContext((PHPFileData)fileData, (int)phpTemplateContext.getStart());
            PHPVariablesTypeManager variablesTypeManager = fileData.getVariableTypeManager();
            PHPVariableData[] phpVariableDatas = variablesTypeManager.getVariables(phpCodeContext);
            if (phpVariableDatas == null) {
                String[] stringArray = new String[]{DEFAULT_VAR};
                return stringArray;
            }
            int i = 0;
            while (i < phpVariableDatas.length) {
                PHPVariableData phpVariableData = phpVariableDatas[i];
                PHPVariableTypeData variableTypeData = variablesTypeManager.getVariableTypeDataByPosition(phpCodeContext, phpVariableData.getName(), phpTemplateContext.getStart());
                if (variableTypeData != null) {
                    arrayList.add(phpVariableData.getName());
                }
                ++i;
            }
        }
        finally {
            structuredModel.releaseFromRead();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

