/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.StandardPHPElementContentProvider;
import org.eclipse.php.internal.ui.SuperClassTreeContentProvider;
import org.eclipse.php.internal.ui.explorer.ExplorerPart;
import org.eclipse.swt.widgets.Control;

public class ExplorerContentProvider
extends StandardPHPElementContentProvider
implements ITreeContentProvider,
ModelListener,
IResourceChangeListener {
    protected static final int GRANT_PARENT = 2;
    protected static final int ORIGINAL = 0;
    protected static final int PARENT = 1;
    protected static final int PROJECT = 4;
    private Object fInput;
    ExplorerPart fPart;
    private int fPendingChanges;
    TreeViewer fViewer;
    ITreeContentProvider superClassTreeContentProvider = new SuperClassTreeContentProvider(this);

    public ExplorerContentProvider(ExplorerPart part, boolean provideMembers) {
        super(provideMembers);
        this.fPart = part;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private synchronized void addPendingChange() {
        ++this.fPendingChanges;
    }

    public void dataCleared() {
    }

    public void dispose() {
        super.dispose();
        PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void fileDataAdded(PHPFileData fileData) {
        IResource res = PHPModelUtil.getResource((Object)fileData);
        if (res != null) {
            this.postRefresh(res);
        } else {
            this.postRefresh(fileData);
        }
    }

    public void fileDataChanged(PHPFileData fileData) {
        IResource res = PHPModelUtil.getResource((Object)fileData);
        if (res == null) {
            return;
        }
        this.postRefresh(res, true);
    }

    public void fileDataRemoved(PHPFileData fileData) {
    }

    protected Object[] getAllProjects() {
        return ResourcesPlugin.getWorkspace().getRoot().getProjects();
    }

    public Object[] getChildrenInternal(Object parentElement) {
        if (parentElement instanceof PHPWorkspaceModelManager) {
            return this.getAllProjects();
        }
        ArrayList children = new ArrayList(Arrays.asList(super.getChildrenInternal(parentElement)));
        children.addAll(Arrays.asList(this.superClassTreeContentProvider.getChildren(parentElement)));
        return children.toArray();
    }

    protected Object getViewerInput() {
        return this.fInput;
    }

    public synchronized boolean hasPendingChanges() {
        return this.fPendingChanges > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.fViewer = (TreeViewer)viewer;
        if (oldInput == null && newInput != null) {
            PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this);
        } else if (oldInput != null && newInput == null) {
            PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
        }
        this.fInput = newInput;
    }

    protected Object internalGetParent(Object element) {
        IResource file;
        Object parent = super.internalGetParent(element);
        if (parent instanceof PHPFileData && (file = PHPModelUtil.getResource((Object)element)) != null && file.getProject() != null && file.getProject().isAccessible()) {
            return file;
        }
        return parent;
    }

    boolean isParent(Object root, Object child) {
        Object parent = this.getParent(child);
        if (parent == null) {
            return false;
        }
        if (parent.equals(root)) {
            return true;
        }
        return this.isParent(root, parent);
    }

    private void postAdd(final Object parent, final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                if (ExplorerContentProvider.this.fViewer == null) {
                    return;
                }
                if (ExplorerContentProvider.this.fViewer.testFindItem(element) == null) {
                    ExplorerContentProvider.this.fViewer.add(parent, element);
                }
            }
        });
    }

    private void postProjectStateChanged(final Object root) {
        this.postRunnable(new Runnable(){

            public void run() {
                ExplorerContentProvider.this.fPart.projectStateChanged(root);
            }
        });
    }

    void postRefresh(final List toRefresh, final boolean updateLabels) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = ExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed() && ctrl.isVisible()) {
                    Iterator iter = toRefresh.iterator();
                    while (iter.hasNext()) {
                        ExplorerContentProvider.this.fViewer.refresh(iter.next(), updateLabels);
                    }
                }
            }
        });
    }

    public void postRefresh(Object root) {
        if (root instanceof IWorkspaceRoot) {
            root = PHPWorkspaceModelManager.getInstance();
        }
        if (this.isParent(root, this.fInput)) {
            root = this.fInput;
        }
        this.postRefresh(root, true);
    }

    private void postRefresh(final Object root, final boolean updateLabels) {
        this.postRunnable(new Runnable(){

            public void run() {
                ExplorerContentProvider.this.fViewer.refresh(root, updateLabels);
            }
        });
    }

    private void postRemove(final Object parent, final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                ExplorerContentProvider.this.fViewer.remove(parent, new Object[]{element});
            }
        });
    }

    private void postRunnable(final Runnable r) {
        if (this.fViewer == null) {
            return;
        }
        final Control ctrl = this.fViewer.getControl();
        Runnable trackedRunnable = new Runnable(){

            public void run() {
                try {
                    if (ctrl != null && !ctrl.isDisposed() && ctrl.isVisible()) {
                        r.run();
                    }
                }
                finally {
                    ExplorerContentProvider.this.removePendingChange();
                }
            }
        };
        if (ctrl != null && !ctrl.isDisposed()) {
            this.addPendingChange();
            try {
                ctrl.getDisplay().asyncExec(trackedRunnable);
            }
            catch (RuntimeException e) {
                this.removePendingChange();
                throw e;
            }
            catch (Error e) {
                this.removePendingChange();
                throw e;
            }
        }
    }

    private boolean processResourceDelta(IResourceDelta delta, Object parent) {
        int status = delta.getKind();
        int flags = delta.getFlags();
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        if ((status & 2) != 0) {
            IResource removeItem = resource;
            this.postRemove(parent, removeItem);
        }
        if ((status & 1) != 0) {
            IResource addItem = resource;
            this.postAdd(parent, addItem);
        }
        if ((flags & 0x4000) != 0) {
            this.postProjectStateChanged(this.internalGetParent(parent));
            return true;
        }
        this.processResourceDeltas(delta.getAffectedChildren(), resource);
        return false;
    }

    private boolean processResourceDeltas(IResourceDelta[] deltas, Object parent) {
        if (deltas == null) {
            return false;
        }
        if (parent instanceof IWorkspaceRoot) {
            parent = PHPWorkspaceModelManager.getInstance();
        }
        if (deltas.length > 1) {
            this.postRefresh(parent);
            return true;
        }
        int i = 0;
        while (i < deltas.length) {
            if (this.processResourceDelta(deltas[i], parent)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    synchronized void removePendingChange() {
        --this.fPendingChanges;
        if (this.fPendingChanges < 0) {
            this.fPendingChanges = 0;
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            IResource resource = delta.getResource();
            this.processResourceDeltas(delta.getAffectedChildren(), resource);
        }
    }
}

