/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.LinkingSelectionListener;
import org.eclipse.php.internal.ui.explorer.ExplorerActionGroup;
import org.eclipse.php.internal.ui.explorer.ExplorerContentProvider;
import org.eclipse.php.internal.ui.explorer.ExplorerLabelProvider;
import org.eclipse.php.internal.ui.explorer.ExplorerSorter;
import org.eclipse.php.internal.ui.explorer.IMultiElementTreeContentProvider;
import org.eclipse.php.internal.ui.explorer.IParentAwareSorter;
import org.eclipse.php.internal.ui.explorer.PHPNavigatorDropAdapter;
import org.eclipse.php.internal.ui.explorer.PHPTreeViewer;
import org.eclipse.php.internal.ui.explorer.WorkingSetAwareContentProvider;
import org.eclipse.php.internal.ui.explorer.WorkingSetAwarePHPElementSorter;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.treecontent.TreeProvider;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.internal.ui.util.FilterUpdater;
import org.eclipse.php.internal.ui.util.MultiElementSelection;
import org.eclipse.php.internal.ui.util.PHPElementLabels;
import org.eclipse.php.internal.ui.util.PHPElementSorter;
import org.eclipse.php.internal.ui.util.PHPOutlineElementComparer;
import org.eclipse.php.internal.ui.util.StatusBarUpdater;
import org.eclipse.php.internal.ui.util.TreePath;
import org.eclipse.php.internal.ui.workingset.ConfigureWorkingSetAction;
import org.eclipse.php.internal.ui.workingset.WorkingSetModel;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.ui.views.navigator.NavigatorDragAdapter;

public class ExplorerPart
extends ViewPart
implements IMenuListener,
FocusListener,
IPartListener2 {
    private static String MEMENTO_ROOT_MODE = "ExplorerPart.rootMode";
    private static String MEMENTO_WORKING_SET = "ExplorerPart.workingSet";
    private PHPTreeViewer fViewer;
    protected ExplorerContentProvider fContentProvider;
    private IContextActivation contextActivation;
    protected ExplorerLabelProvider fLabelProvider;
    private ExplorerActionGroup fActionSet;
    private Menu fContextMenu;
    private boolean fLinkingEnabled;
    private String fWorkingSetName;
    private ISelection fLastOpenSelection;
    private ISelectionChangedListener fPostSelectionListener;
    private FilterUpdater fFilterUpdater;
    private int fRootMode = 1;
    private WorkingSetModel fWorkingSetModel;
    private IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                ExplorerPart.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    IMemento memento;
    private LinkingSelectionListener fSelectionListener = new LinkingSelectionListener(){

        protected ISelection createSelection(Object element) {
            if (element instanceof PHPCodeData) {
                PHPFileData fileData;
                IResource res;
                PHPClassData interfaceData;
                PHPClassData.PHPInterfaceNameData interfaceNameData;
                PHPClassData classData;
                if (element instanceof PHPClassData.PHPSuperClassNameData) {
                    PHPClassData superClassData;
                    PHPClassData.PHPSuperClassNameData superClassNameData = (PHPClassData.PHPSuperClassNameData)element;
                    classData = (PHPClassData)superClassNameData.getContainer();
                    if (classData != null && (superClassData = PHPModelUtil.discoverSuperClass((PHPClassData)classData, (String)superClassNameData.getName())) != null) {
                        element = superClassData;
                    }
                } else if (element instanceof PHPClassData.PHPInterfaceNameData && (classData = (PHPClassData)(interfaceNameData = (PHPClassData.PHPInterfaceNameData)element).getContainer()) != null && (interfaceData = PHPModelUtil.discoverInterface((PHPClassData)classData, (String)interfaceNameData.getName())) != null) {
                    element = interfaceData;
                }
                if ((res = PHPModelUtil.getResource((Object)(fileData = PHPModelUtil.getPHPFileContainer((PHPCodeData)((PHPCodeData)element))))) != null && res.getProject().isAccessible()) {
                    return new StructuredSelection((Object)res);
                }
                if (fileData != null) {
                    return new StructuredSelection((Object)fileData);
                }
            }
            return super.createSelection(element);
        }
    };

    public void focusGained(FocusEvent e) {
        IContextService service = (IContextService)PHPUiPlugin.getDefault().getWorkbench().getService(IContextService.class);
        if (service != null) {
            this.contextActivation = service.activateContext("org.eclipse.php.ui.contexts.window");
        }
    }

    public void focusLost(FocusEvent e) {
        IContextService service = (IContextService)PHPUiPlugin.getDefault().getWorkbench().getService(IContextService.class);
        if (service != null && this.contextActivation != null) {
            service.deactivateContext(this.contextActivation);
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        if (partRef.getId().equals("org.eclipse.php.ui.explorer")) {
            this.fContentProvider.postRefresh(this.fViewer.getInput());
        }
    }

    public ExplorerPart() {
        this.fPostSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExplorerPart.this.handlePostSelectionChanged(event);
            }
        };
    }

    public void createPartControl(Composite parent) {
        IEditorPart editor;
        IMemento wsMemento;
        this.fViewer = this.createViewer(parent);
        this.fViewer.getControl().addFocusListener((FocusListener)this);
        this.fSelectionListener.setViewer(this.getViewer());
        this.fViewer.setUseHashlookup(true);
        this.initDragAndDrop();
        this.setProviders();
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite site = this.getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
        site.setSelectionProvider((ISelectionProvider)this.fViewer);
        site.getPage().addPartListener(this.fPartListener);
        site.getPage().addPartListener((IPartListener2)this);
        this.initLinkingEnabled();
        this.fActionSet = new ExplorerActionGroup(this);
        if (this.fWorkingSetModel != null) {
            this.fActionSet.getWorkingSetActionGroup().setWorkingSetModel(this.fWorkingSetModel);
        }
        if (this.memento != null && (wsMemento = this.memento.getChild(MEMENTO_WORKING_SET)) != null) {
            this.fActionSet.restoreFilterAndSorterState(this.memento.getChild(MEMENTO_WORKING_SET));
        }
        this.fViewer.setInput(this.findInputElement());
        this.initKeyListener();
        this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ExplorerPart.this.fActionSet.handleDoubleClick(event);
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ExplorerPart.this.fActionSet.handleOpen(event);
                ExplorerPart.this.fLastOpenSelection = event.getSelection();
            }
        });
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener(new StatusBarUpdater(slManager));
        this.fillActionBars();
        this.updateTitle();
        this.fFilterUpdater = new FilterUpdater((StructuredViewer)this.fViewer);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        if (this.isLinkingEnabled() && (editor = this.getViewSite().getPage().getActiveEditor()) != null) {
            this.editorActivated(editor);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.php_explorer_view");
    }

    private PHPTreeViewer createViewer(Composite composite) {
        return new ExplorerTreeViewer(composite, 770);
    }

    Object getElementOfInput(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    protected void initDragAndDrop() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance(), PluginTransfer.getInstance()};
        TreeViewer viewer = this.getViewer();
        viewer.addDragSupport(ops, transfers, (DragSourceListener)new NavigatorDragAdapter((ISelectionProvider)viewer));
        PHPNavigatorDropAdapter adapter = new PHPNavigatorDropAdapter((StructuredViewer)viewer);
        adapter.setFeedbackEnabled(false);
        viewer.addDropSupport(ops | 0x10, transfers, (DropTargetListener)adapter);
    }

    private void initKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                ExplorerPart.this.fActionSet.handleKeyEvent(event);
            }
        });
    }

    private void handlePostSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (this.isLinkingEnabled() && !selection.equals(this.fLastOpenSelection)) {
            this.linkToEditor((IStructuredSelection)selection);
        }
        this.fLastOpenSelection = null;
    }

    private void linkToEditor(IStructuredSelection selection) {
        IEditorPart part;
        if (this != this.getSite().getPage().getActivePart()) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (selection.size() == 1 && (part = EditorUtility.isOpenInEditor(obj)) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            page.bringToTop((IWorkbenchPart)part);
            if (obj instanceof PHPCodeData) {
                EditorUtility.revealInEditor(part, (PHPCodeData)obj);
            }
        }
    }

    private void setProviders() {
        this.fContentProvider = this.createContentProvider();
        IPHPTreeContentProvider[] treeProviders = TreeProvider.getTreeProviders(this.getViewSite().getId());
        this.fContentProvider.setTreeProviders(treeProviders);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setSorter(new ExplorerSorter());
        this.fLabelProvider = this.createLabelProvider();
        this.fLabelProvider.setTreeProviders(treeProviders);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)this.fLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
    }

    void projectStateChanged(Object root) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed() && ctrl.isVisible()) {
            this.fViewer.refresh(root, true);
            this.fViewer.setSelection(this.fViewer.getSelection());
        }
    }

    public ExplorerContentProvider createContentProvider() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean showCUChildren = store.getBoolean("explorerCuchildren");
        if (this.showProjects()) {
            return new ExplorerContentProvider(this, showCUChildren);
        }
        return new WorkingSetAwareContentProvider(this, showCUChildren, this.fWorkingSetModel);
    }

    boolean showProjects() {
        return this.fRootMode == 1;
    }

    boolean showWorkingSets() {
        return this.fRootMode == 2;
    }

    protected ExplorerLabelProvider createLabelProvider() {
        return new ExplorerLabelProvider(1627389963, 3, this.fContentProvider);
    }

    private Object findInputElement() {
        if (this.showWorkingSets()) {
            return this.fWorkingSetModel;
        }
        IAdaptable input = this.getSite().getPage().getInput();
        if (input instanceof IWorkspace || input instanceof IWorkspaceRoot) {
            return PHPWorkspaceModelManager.getInstance();
        }
        if (input instanceof IContainer) {
            return input;
        }
        return PHPWorkspaceModelManager.getInstance();
    }

    public void dispose() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this.fSelectionListener);
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        this.getSite().getPage().removePartListener(this.fPartListener);
        this.getSite().getPage().removePartListener((IPartListener2)this);
        if (this.fActionSet != null) {
            this.fActionSet.dispose();
        }
        if (this.fFilterUpdater != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        }
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.dispose();
        }
        super.dispose();
    }

    public void menuAboutToShow(IMenuManager menu) {
        PHPUiPlugin.createStandardGroups(menu);
        this.fActionSet.setContext(new ActionContext(this.getSelection()));
        this.fActionSet.fillContextMenu(menu);
        this.fActionSet.setContext(null);
    }

    void editorActivated(IEditorPart editor) {
        if (!this.isLinkingEnabled()) {
            return;
        }
        Object input = this.getElementOfInput(editor.getEditorInput());
        if (input == null) {
            return;
        }
        if (!this.inputIsSelected(editor.getEditorInput())) {
            this.showInput(input);
        } else {
            this.fViewer.getTree().showSelection();
        }
    }

    private boolean inputIsSelected(IEditorInput input) {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection.size() != 1) {
            return false;
        }
        IEditorInput selectionAsInput = null;
        selectionAsInput = EditorUtility.getEditorInput(selection.getFirstElement());
        return input.equals(selectionAsInput);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean showInput(Object element) {
        if (element == null) return false;
        StructuredSelection newSelection = new StructuredSelection(element);
        if (this.fViewer.getSelection().equals(newSelection)) {
            this.fViewer.reveal(element);
            return true;
        }
        try {
            block8: {
                block7: {
                    this.fViewer.removePostSelectionChangedListener(this.fPostSelectionListener);
                    this.fViewer.setSelection((ISelection)newSelection, true);
                    if (!true) break block7;
                    if (element == null) return true;
                    if (!this.fViewer.getSelection().isEmpty()) break block8;
                }
                do {
                    if ((element = this.fContentProvider.getParent(element)) != null) {
                        newSelection = new StructuredSelection(element);
                        this.fViewer.setSelection((ISelection)newSelection, true);
                    }
                    if (element == null) return true;
                } while (this.fViewer.getSelection().isEmpty());
            }
            return true;
        }
        finally {
            this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        }
    }

    public TreeViewer getViewer() {
        return this.fViewer;
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fActionSet.fillActionBars(actionBars);
    }

    private ISelection getSelection() {
        return this.fViewer.getSelection();
    }

    public void collapseAll() {
        try {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
        }
        finally {
            this.fViewer.getControl().setRedraw(true);
        }
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void initLinkingEnabled() {
        this.setLinkingEnabled(PreferenceConstants.getPreferenceStore().getBoolean("browsingProjectstoeditor"));
    }

    public void setLinkingEnabled(boolean enabled) {
        this.fLinkingEnabled = enabled;
        PreferenceConstants.getPreferenceStore().setValue("browsingProjectstoeditor", enabled);
        IWorkbenchPartSite site = this.getSite();
        if (site == null) {
            return;
        }
        IWorkbenchPage page = site.getPage();
        if (page == null) {
            return;
        }
        if (enabled) {
            page.addPostSelectionListener((ISelectionListener)this.fSelectionListener);
            IEditorPart editor = page.getActiveEditor();
            if (editor != null) {
                this.editorActivated(editor);
            }
        } else {
            page.removePostSelectionListener((ISelectionListener)this.fSelectionListener);
        }
    }

    String getFrameName(Object element) {
        if (element instanceof PHPCodeData) {
            return ((PHPCodeData)element).getName();
        }
        return this.fLabelProvider.getText(element);
    }

    String getToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? (element instanceof PHPWorkspaceModelManager ? PHPUIMessages.getString("PHPExplorerPart_workspace") : (element instanceof PHPCodeData ? PHPElementLabels.getTextLabel(element, 1090519051L) : this.fLabelProvider.getText(element))) : ((path = ((IResource)element).getFullPath()).isRoot() ? PHPUIMessages.getString("PHPExplorer_title") : path.makeRelative().toString());
        if (this.fWorkingSetName == null) {
            return result;
        }
        String wsstr = MessageFormat.format(PHPUIMessages.getString("PHPExplorer_toolTip"), this.fWorkingSetName);
        if (result.length() == 0) {
            return wsstr;
        }
        return MessageFormat.format(PHPUIMessages.getString("PHPExplorer_toolTip2"), result, this.fWorkingSetName);
    }

    void updateTitle() {
        Object input = this.fViewer.getInput();
        if (input == null || input instanceof PHPWorkspaceModelManager) {
            this.setContentDescription("");
            this.setTitleToolTip("");
        } else {
            String inputText = PHPElementLabels.getTextLabel(input, 1090519051L);
            this.setContentDescription(inputText);
            this.setTitleToolTip(this.getToolTipText(input));
        }
    }

    void setWorkingSetName(String workingSetName) {
        this.fWorkingSetName = workingSetName;
    }

    public void rootModeChanged(int newMode) {
        this.fRootMode = newMode;
        if (this.showWorkingSets() && this.fWorkingSetModel == null) {
            this.createWorkingSetModel();
            if (this.fActionSet != null) {
                this.fActionSet.getWorkingSetActionGroup().setWorkingSetModel(this.fWorkingSetModel);
            }
        }
        ISelection selection = this.fViewer.getSelection();
        Object input = this.fViewer.getInput();
        boolean isRootInputChange = PHPWorkspaceModelManager.getInstance().equals(input) || this.fWorkingSetModel != null && this.fWorkingSetModel.equals(input) || input instanceof IWorkingSet;
        try {
            this.fViewer.getControl().setRedraw(false);
            if (isRootInputChange) {
                this.fViewer.setInput(null);
            }
            this.setProviders();
            this.setSorter();
            this.fActionSet.getWorkingSetActionGroup().fillFilters((StructuredViewer)this.fViewer);
            if (isRootInputChange) {
                this.fViewer.setInput(this.findInputElement());
            }
            this.fViewer.setSelection(selection, true);
        }
        finally {
            this.fViewer.getControl().setRedraw(true);
        }
        if (isRootInputChange && this.fWorkingSetModel != null && this.fWorkingSetModel.needsConfiguration()) {
            ConfigureWorkingSetAction action = new ConfigureWorkingSetAction(this.getSite());
            action.setWorkingSetModel(this.fWorkingSetModel);
            action.run();
            this.fWorkingSetModel.configured();
        }
    }

    private void setSorter() {
        if (this.showWorkingSets()) {
            this.fViewer.setSorter(new WorkingSetAwarePHPElementSorter());
        } else {
            this.fViewer.setSorter(new PHPElementSorter());
        }
    }

    private void createWorkingSetModel(final IMemento memento) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                ExplorerPart.this.fWorkingSetModel = new WorkingSetModel(memento);
            }

            public void handleException(Throwable exception) {
                ExplorerPart.this.fWorkingSetModel = new WorkingSetModel(memento);
            }
        });
    }

    private void createWorkingSetModel() {
        this.createWorkingSetModel(null);
    }

    public WorkingSetModel getWorkingSetModel() {
        return this.fWorkingSetModel;
    }

    public int getRootMode() {
        return this.fRootMode;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        Integer rootModeInteger;
        super.init(site, memento);
        if (memento != null && (rootModeInteger = memento.getInteger(MEMENTO_ROOT_MODE)) != null) {
            this.fRootMode = rootModeInteger;
        }
        if (this.showWorkingSets()) {
            this.createWorkingSetModel(memento.getChild(MEMENTO_WORKING_SET));
        }
        this.memento = memento;
    }

    public void saveState(IMemento memento) {
        if (memento != null) {
            memento.putInteger(MEMENTO_ROOT_MODE, this.fRootMode);
            IMemento wsMemento = memento.createChild(MEMENTO_WORKING_SET);
            if (this.fWorkingSetModel != null) {
                this.fWorkingSetModel.saveState(wsMemento);
            }
            this.fActionSet.saveFilterAndSorterState(wsMemento);
        }
        super.saveState(memento);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IShowInSource.class) {
            return this.getShowInSource();
        }
        if (adapter == IShowInTarget.class) {
            return this.getShowInTarget();
        }
        return super.getAdapter(adapter);
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(ExplorerPart.this.getViewer().getInput(), ExplorerPart.this.getViewer().getSelection());
            }
        };
    }

    protected IShowInTarget getShowInTarget() {
        return new IShowInTarget(){

            public boolean show(ShowInContext context) {
                IAdaptable adaptable;
                Object input;
                Object o2;
                ArrayList toSelect = new ArrayList();
                ISelection sel = context.getSelection();
                if (sel instanceof IStructuredSelection) {
                    IStructuredSelection ssel = (IStructuredSelection)sel;
                    for (Object o2 : ssel) {
                        IResource r;
                        if (o2 instanceof IResource) {
                            toSelect.add(o2);
                            continue;
                        }
                        if (o2 instanceof IMarker) {
                            IResource r2 = ((IMarker)o2).getResource();
                            if (r2.getType() == 8) continue;
                            toSelect.add(r2);
                            continue;
                        }
                        if (!(o2 instanceof IAdaptable)) continue;
                        IAdaptable adaptable2 = (IAdaptable)o2;
                        if ((o2 = adaptable2.getAdapter(IResource.class)) instanceof IResource) {
                            toSelect.add(o2);
                            continue;
                        }
                        o2 = adaptable2.getAdapter(IMarker.class);
                        if (!(o2 instanceof IMarker) || (r = ((IMarker)o2).getResource()).getType() == 8) continue;
                        toSelect.add(r);
                    }
                }
                if (toSelect.isEmpty() && (input = context.getInput()) instanceof IAdaptable && (o2 = (adaptable = (IAdaptable)input).getAdapter(IResource.class)) instanceof IResource) {
                    toSelect.add(o2);
                }
                if (!toSelect.isEmpty()) {
                    ExplorerPart.this.getViewer().setSelection((ISelection)new StructuredSelection(toSelect), true);
                    return true;
                }
                return false;
            }
        };
    }

    private class ExplorerTreeViewer
    extends PHPTreeViewer {
        List fPendingGetChildren;

        public ExplorerTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.fPendingGetChildren = Collections.synchronizedList(new ArrayList());
            this.setComparer(new PHPOutlineElementComparer());
        }

        public void add(Object parentElement, Object[] childElements) {
            if (this.fPendingGetChildren.contains(parentElement)) {
                return;
            }
            super.add(parentElement, childElements);
        }

        protected Object[] getRawChildren(Object parent) {
            try {
                this.fPendingGetChildren.add(parent);
                Object[] objectArray = super.getRawChildren(parent);
                return objectArray;
            }
            finally {
                this.fPendingGetChildren.remove(parent);
            }
        }

        private Object getElement(TreeItem item) {
            Object result = item.getData();
            if (result == null) {
                return null;
            }
            return result;
        }

        private TreePath createTreePath(TreeItem item) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(item.getData());
            TreeItem parent = item.getParentItem();
            while (parent != null) {
                result.add(parent.getData());
                parent = parent.getParentItem();
            }
            Collections.reverse(result);
            return new TreePath(result.toArray());
        }

        public ISelection getSelection() {
            IContentProvider cp = this.getContentProvider();
            if (!(cp instanceof IMultiElementTreeContentProvider)) {
                return super.getSelection();
            }
            Control control = this.getControl();
            if (control == null || control.isDisposed() || !control.isVisible()) {
                return StructuredSelection.EMPTY;
            }
            Tree tree = this.getTree();
            TreeItem[] selection = tree.getSelection();
            ArrayList<Object> result = new ArrayList<Object>(selection.length);
            ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
            int i = 0;
            while (i < selection.length) {
                TreeItem item = selection[i];
                Object element = this.getElement(item);
                if (element != null) {
                    if (!result.contains(element)) {
                        result.add(element);
                    }
                    treePaths.add(this.createTreePath(item));
                }
                ++i;
            }
            return new MultiElementSelection((StructuredViewer)this, result, treePaths.toArray(new TreePath[treePaths.size()]));
        }

        protected Object[] getSortedChildren(Object parent) {
            IParentAwareSorter sorter;
            IParentAwareSorter iParentAwareSorter = sorter = this.getSorter() instanceof IParentAwareSorter ? (IParentAwareSorter)this.getSorter() : null;
            if (sorter != null) {
                sorter.setParent(parent);
            }
            try {
                Object[] objectArray = super.getSortedChildren(parent);
                return objectArray;
            }
            finally {
                if (sorter != null) {
                    sorter.setParent(null);
                }
            }
        }

        public boolean isExpandable(Object parent) {
            ViewerFilter[] filters = ExplorerPart.this.fViewer.getFilters();
            Object[] children = ((ITreeContentProvider)ExplorerPart.this.fViewer.getContentProvider()).getChildren(parent);
            int i = 0;
            while (i < children.length) {
                Object object = children[i];
                if (this.isEssential(object)) {
                    return true;
                }
                if ((object = this.filter(object, parent, filters)) != null) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private Object filter(Object object, Object parent, ViewerFilter[] filters) {
            Object rv = null;
            int i = 0;
            while (i < filters.length) {
                ViewerFilter filter = filters[i];
                if (filter.select((Viewer)ExplorerPart.this.fViewer, parent, object)) {
                    rv = object;
                }
                ++i;
            }
            return rv;
        }

        protected Object[] filter(Object[] elements) {
            ViewerFilter[] filters = this.getFilters();
            if (filters == null || filters.length == 0) {
                return elements;
            }
            ArrayList<Object> filtered = new ArrayList<Object>(elements.length);
            Object root = this.getRoot();
            int i = 0;
            while (i < elements.length) {
                boolean add = true;
                if (!this.isEssential(elements[i])) {
                    int j = 0;
                    while (j < filters.length) {
                        add = filters[j].select((Viewer)this, root, elements[i]);
                        if (!add) break;
                        ++j;
                    }
                }
                if (add) {
                    filtered.add(elements[i]);
                }
                ++i;
            }
            return filtered.toArray();
        }

        private boolean isEssential(Object object) {
            if (object instanceof IContainer) {
                IContainer folder;
                block5: {
                    folder = (IContainer)object;
                    try {
                        if (!(object instanceof IProject)) break block5;
                        IProject project = (IProject)object;
                        if (project.isOpen() && ((IProject)object).hasNature("org.eclipse.php.core.PHPNature")) {
                            return false;
                        }
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                }
                Object obj = this.filter(object, object, ExplorerPart.this.fViewer.getFilters());
                return obj != null && folder.members().length > 0;
            }
            return false;
        }

        protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
            IStructuredSelection is = (IStructuredSelection)invalidSelection;
            ArrayList<Object> ns = null;
            ns = newSelection instanceof IStructuredSelection ? new ArrayList(((IStructuredSelection)newSelection).toList()) : new ArrayList<IProject>();
            boolean changed = false;
            for (Object element : is) {
                IProject project;
                if (element instanceof PHPProjectModel) {
                    project = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)element);
                    if (project.isOpen()) continue;
                    ns.add(project);
                    changed = true;
                    continue;
                }
                if (!(element instanceof IProject) || !(project = (IProject)element).isOpen()) continue;
                changed = true;
            }
            if (changed) {
                newSelection = new StructuredSelection(ns);
                this.setSelection(newSelection);
            }
            super.handleInvalidSelection(invalidSelection, newSelection);
        }
    }
}

