/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.php.internal.ui.dnd.PHPViewerDropAdapter;
import org.eclipse.php.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class SelectionTransferDropAdapter
extends PHPViewerDropAdapter
implements TransferDropTargetListener {
    private List fElements;
    private int fCanMoveElements;
    private int fCanCopyElements;
    private ISelection fSelection;
    private static final long DROP_TIME_DIFF_TRESHOLD = 150L;

    public SelectionTransferDropAdapter(StructuredViewer viewer) {
        super(viewer, 24);
    }

    public Transfer getTransfer() {
        return LocalSelectionTransfer.getInstance();
    }

    public void dragEnter(DropTargetEvent event) {
        this.clear();
        super.dragEnter(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.clear();
        super.dragLeave(event);
    }

    private void clear() {
        this.fElements = null;
        this.fSelection = null;
        this.fCanMoveElements = 0;
        this.fCanCopyElements = 0;
    }

    public void validateDrop(Object target, DropTargetEvent event, int operation) {
        event.detail = 0;
        if (this.tooFast(event)) {
            return;
        }
        this.initializeSelection();
        switch (operation) {
            case 16: {
                event.detail = this.handleValidateDefault(target, event);
                break;
            }
            case 1: {
                event.detail = this.handleValidateCopy(target, event);
                break;
            }
            case 2: {
                event.detail = this.handleValidateMove(target, event);
                break;
            }
            case 4: {
                event.detail = this.handleValidateLink(target, event);
            }
        }
    }

    protected void initializeSelection() {
        if (this.fElements != null) {
            return;
        }
        ISelection s = LocalSelectionTransfer.getInstance().getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        this.fSelection = s;
        this.fElements = ((IStructuredSelection)s).toList();
    }

    protected ISelection getSelection() {
        return this.fSelection;
    }

    private boolean tooFast(DropTargetEvent event) {
        return Math.abs(LocalSelectionTransfer.getInstance().getSelectionSetTime() - ((long)event.time & 0xFFFFFFFFL)) < 150L;
    }

    public void drop(Object target, DropTargetEvent event) {
        try {
            try {
                switch (event.detail) {
                    case 2: {
                        this.handleDropMove(target, event);
                        break;
                    }
                    case 1: {
                        this.handleDropCopy(target, event);
                        break;
                    }
                    case 4: {
                        this.handleDropLink(target, event);
                    }
                }
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                event.detail = 0;
            }
            catch (InterruptedException interruptedException) {
                event.detail = 0;
            }
        }
        finally {
            event.detail = 0;
        }
    }

    private int handleValidateDefault(Object target, DropTargetEvent event) {
        if (target == null) {
            return 0;
        }
        return this.handleValidateMove(target, event);
    }

    private int handleValidateMove(Object target, DropTargetEvent event) {
        if (target == null) {
            return 0;
        }
        if (!this.canMoveElements()) {
            return 0;
        }
        return 0;
    }

    private boolean canMoveElements() {
        if (this.fCanMoveElements == 0) {
            this.fCanMoveElements = 2;
        }
        return this.fCanMoveElements == 2;
    }

    private void handleDropLink(Object target, DropTargetEvent event) {
    }

    private int handleValidateLink(Object target, DropTargetEvent event) {
        return 0;
    }

    private void handleDropMove(Object target, DropTargetEvent event) throws InvocationTargetException, InterruptedException {
    }

    private int handleValidateCopy(Object target, DropTargetEvent event) {
        if (!this.canCopyElements()) {
            return 0;
        }
        return 0;
    }

    private boolean canCopyElements() {
        if (this.fCanCopyElements == 0) {
            this.fCanCopyElements = 2;
        }
        return this.fCanCopyElements == 2;
    }

    private void handleDropCopy(Object target, DropTargetEvent event) throws InvocationTargetException, InterruptedException {
    }

    private Shell getShell() {
        return this.getViewer().getControl().getShell();
    }
}

