/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.filters;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;

public class MemberFilter
extends ViewerFilter {
    public static final int FILTER_NONPUBLIC = 1;
    public static final int FILTER_STATIC = 2;
    public static final int FILTER_VARIABLE = 4;
    private int fFilterProperties;

    public final void addFilter(int filter) {
        this.fFilterProperties |= filter;
    }

    public final void removeFilter(int filter) {
        this.fFilterProperties &= 0xFFFFFFFF ^ filter;
    }

    public final boolean hasFilter(int filter) {
        return (this.fFilterProperties & filter) != 0;
    }

    public boolean isFilterProperty(Object element, Object property) {
        return false;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof PHPCodeData) {
            PHPCodeData member = (PHPCodeData)element;
            if (member instanceof PHPClassData || member instanceof PHPClassConstData || member instanceof PHPFunctionData && !(member.getContainer() instanceof PHPClassData)) {
                return true;
            }
            if (this.hasFilter(4) && member instanceof PHPVariableData) {
                return false;
            }
            int flags = PHPModelUtil.getModifier((PHPCodeData)member);
            if (this.hasFilter(2) && PHPModifier.isStatic((int)flags)) {
                return false;
            }
            if (this.hasFilter(1) && (PHPModifier.isPrivate((int)flags) || PHPModifier.isProtected((int)flags))) {
                return false;
            }
        }
        return true;
    }
}

