/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.projection.IStructuredTextFoldingProvider;

@Deprecated
public class DefaultPHPFoldingStructureProvider
implements IProjectionListener,
IStructuredTextFoldingProvider,
ModelListener {
    private static final PHPWorkspaceModelManager workspaceModelManagerInstance = PHPWorkspaceModelManager.getInstance();
    private ProjectionViewer viewer;
    private boolean collapseClasses = false;
    private boolean collapseFunctions = false;
    private boolean collapsePHPDoc = false;
    private boolean allowCollapsing;
    private IModelStateListener modelStateListener;
    private final ArrayList toRemove = new ArrayList();
    private final Map newFolds = new LinkedHashMap();
    private Timer timer;
    private IDocument document;
    private TimerTask timerTask;
    static int failCount;
    static final int MAX_RETRY = 3;
    static final int THREAD_DELAY = 5000;

    public void projectionEnabled() {
        this.projectionDisabled();
        this.initialize();
        if (this.document != null) {
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
            if (model == null) {
                TimerTask thread = new TimerTask(){

                    public void run() {
                        if (failCount++ < 3) {
                            DefaultPHPFoldingStructureProvider.this.projectionEnabled();
                        }
                    }
                };
                Timer t = new Timer(false);
                t.schedule(thread, 5000L);
                return;
            }
            this.modelStateListener = new PHPModelStateListener();
            model.addModelStateListener(this.modelStateListener);
            model.releaseFromRead();
            failCount = 0;
            this.timer = new Timer(false);
            this.timerTask = new FoldingTimerTask();
        }
    }

    public void projectionDisabled() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            this.timerTask = null;
        }
        if (this.document != null) {
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
            if (model != null) {
                model.removeModelStateListener(this.modelStateListener);
                model.releaseFromRead();
            }
            this.modelStateListener = null;
            this.document = null;
        }
    }

    public void install(ProjectionViewer viewer) {
        if (this.isInstalled()) {
            this.uninstall();
        }
        this.viewer = viewer;
        viewer.addProjectionListener((IProjectionListener)this);
        workspaceModelManagerInstance.addModelListener((ModelListener)this);
    }

    public void uninstall() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.viewer.removeProjectionListener((IProjectionListener)this);
            workspaceModelManagerInstance.removeModelListener((ModelListener)this);
            this.viewer = null;
        }
    }

    protected boolean isInstalled() {
        return this.viewer != null;
    }

    public void initialize() {
        if (!this.isInstalled()) {
            return;
        }
        this.initializePreferences();
        if (this.viewer.getProjectionAnnotationModel() != null) {
            this.viewer.getProjectionAnnotationModel().removeAllAnnotations();
        }
        this.document = this.viewer.getDocument();
        this.allowCollapsing = true;
        if (this.document != null) {
            this.updateFolds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFolds() {
        block18: {
            IStructuredModel sModel = null;
            PHPFileData fileData = null;
            try {
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
                if (sModel == null || !(sModel instanceof DOMModelForPHP)) break block18;
                DOMModelForPHP editorModel = (DOMModelForPHP)sModel;
                fileData = editorModel.getFileData();
                if (editorModel.getProjectModel() == null) {
                    return;
                }
                try {
                    if (fileData == null) {
                        IProject project = editorModel.getProjectModel().getProject();
                        fileData = PHPFileDataUtilities.getFileData((Reader)new DocumentReader(this.document), (IProject)project);
                    }
                    workspaceModelManagerInstance.removeModelListener((ModelListener)this);
                    ProjectionAnnotationModel model = this.viewer.getProjectionAnnotationModel();
                    if (model == null) break block18;
                    Object object = model.getLockObject();
                    synchronized (object) {
                        Map additions = this.computeAdditions(fileData);
                        this.toRemove.clear();
                        this.newFolds.clear();
                        Iterator existing = model.getAnnotationIterator();
                        LinkedHashMap<Position, ProjectionAnnotation> exitingHashMap = new LinkedHashMap<Position, ProjectionAnnotation>();
                        while (existing.hasNext()) {
                            ProjectionAnnotation existingAnnotation = (ProjectionAnnotation)existing.next();
                            Position existingPosition = model.getPosition((Annotation)existingAnnotation);
                            exitingHashMap.put(existingPosition, existingAnnotation);
                        }
                        for (AnnotatedPosition addedPosition : additions.values()) {
                            if (exitingHashMap.remove((Object)addedPosition) != null) continue;
                            this.newFolds.put(addedPosition.getAnnotation(), addedPosition);
                        }
                        boolean removeAnyway = false;
                        for (Map.Entry entry : exitingHashMap.entrySet()) {
                            AnnotatedPosition position = (AnnotatedPosition)((Object)entry.getKey());
                            PHPProjectionAnnotation projectionToRemove = (PHPProjectionAnnotation)((Object)entry.getValue());
                            if (removeAnyway || !projectionToRemove.isCollapsed()) {
                                this.toRemove.add(projectionToRemove);
                                continue;
                            }
                            if (!this.shouldRemoveAnnotation(projectionToRemove, position.offset)) continue;
                            this.toRemove.add(projectionToRemove);
                            removeAnyway = true;
                        }
                        if (this.toRemove.size() > 0 || this.newFolds.size() > 0) {
                            model.replaceAnnotations(this.toRemove.toArray(new Annotation[this.toRemove.size()]), this.newFolds);
                        }
                    }
                }
                catch (ArrayStoreException ase) {
                    ase.printStackTrace();
                }
            }
            finally {
                if (sModel != null) {
                    sModel.releaseFromRead();
                    if (fileData != null) {
                        this.allowCollapsing = false;
                    }
                }
            }
        }
    }

    private boolean shouldRemoveAnnotation(PHPProjectionAnnotation projectionToRemove, int annotationOffset) {
        if (this.document != null) {
            try {
                return this.isInComment((IStructuredDocument)this.document, annotationOffset);
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
        }
        return false;
    }

    private void initializePreferences() {
        IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
        this.collapseClasses = store.getBoolean("foldClasses");
        this.collapseFunctions = store.getBoolean("foldFunctions");
        this.collapsePHPDoc = store.getBoolean("foldPHPDoc");
    }

    protected Map computeAdditions(PHPFileData fileData) {
        LinkedHashMap map = new LinkedHashMap();
        try {
            this.computeClassesAdditions(fileData, map);
            this.computeFunctionsAdditions(fileData, map);
            this.computePHPDocAdditions(fileData, map);
        }
        catch (Exception exception) {}
        return map;
    }

    private void computePHPDocAdditions(PHPFileData fileData, Map map) {
        PHPClassData[] classData;
        PHPFunctionData[] functionsData;
        PHPConstantData[] constants;
        ArrayList<PHPDocBlock> data = new ArrayList<PHPDocBlock>();
        PHPDocBlock fileDataDocBlock = fileData.getDocBlock();
        data.add(fileDataDocBlock);
        PHPConstantData[] pHPConstantDataArray = constants = fileData.getConstants();
        int n = constants.length;
        int n2 = 0;
        while (n2 < n) {
            PHPConstantData element = pHPConstantDataArray[n2];
            data.add(element.getDocBlock());
            ++n2;
        }
        PHPFunctionData[] pHPFunctionDataArray = functionsData = fileData.getFunctions();
        int n3 = functionsData.length;
        n = 0;
        while (n < n3) {
            PHPFunctionData element = pHPFunctionDataArray[n];
            data.add(element.getDocBlock());
            ++n;
        }
        PHPClassData[] pHPClassDataArray = classData = fileData.getClasses();
        int n4 = classData.length;
        n3 = 0;
        while (n3 < n4) {
            PHPClassVarData[] variables;
            PHPClassConstData[] classConstants;
            PHPFunctionData[] functions;
            PHPClassData element = pHPClassDataArray[n3];
            data.add(element.getDocBlock());
            PHPFunctionData[] pHPFunctionDataArray2 = functions = element.getFunctions();
            int n5 = functions.length;
            int n6 = 0;
            while (n6 < n5) {
                PHPFunctionData element2 = pHPFunctionDataArray2[n6];
                data.add(element2.getDocBlock());
                ++n6;
            }
            PHPClassConstData[] pHPClassConstDataArray = classConstants = element.getConsts();
            int n7 = classConstants.length;
            n5 = 0;
            while (n5 < n7) {
                PHPClassConstData element2 = pHPClassConstDataArray[n5];
                data.add(element2.getDocBlock());
                ++n5;
            }
            PHPClassVarData[] pHPClassVarDataArray = variables = element.getVars();
            int n8 = variables.length;
            n7 = 0;
            while (n7 < n8) {
                PHPClassVarData element2 = pHPClassVarDataArray[n7];
                data.add(element2.getDocBlock());
                ++n7;
            }
            ++n3;
        }
        this.addAnnotations(data, map, this.allowCollapsing && this.collapsePHPDoc, true);
    }

    private void computeFunctionsAdditions(PHPFileData fileData, Map map) {
        PHPClassData[] classData;
        PHPFunctionData[] functionsData;
        ArrayList<PHPFunctionData> data = new ArrayList<PHPFunctionData>();
        PHPFunctionData[] pHPFunctionDataArray = functionsData = fileData.getFunctions();
        int n = functionsData.length;
        int n2 = 0;
        while (n2 < n) {
            PHPFunctionData element = pHPFunctionDataArray[n2];
            data.add(element);
            ++n2;
        }
        PHPClassData[] pHPClassDataArray = classData = fileData.getClasses();
        int n3 = classData.length;
        n = 0;
        while (n < n3) {
            PHPFunctionData[] functions;
            PHPClassData element = pHPClassDataArray[n];
            PHPFunctionData[] pHPFunctionDataArray2 = functions = element.getFunctions();
            int n4 = functions.length;
            int n5 = 0;
            while (n5 < n4) {
                PHPFunctionData element2 = pHPFunctionDataArray2[n5];
                data.add(element2);
                ++n5;
            }
            ++n;
        }
        this.addAnnotations(data, map, this.allowCollapsing && this.collapseFunctions, false);
    }

    private void computeClassesAdditions(PHPFileData fileData, Map map) {
        PHPClassData[] classData;
        ArrayList<PHPClassData> data = new ArrayList<PHPClassData>();
        PHPClassData[] pHPClassDataArray = classData = fileData.getClasses();
        int n = classData.length;
        int n2 = 0;
        while (n2 < n) {
            PHPClassData element = pHPClassDataArray[n2];
            data.add(element);
            ++n2;
        }
        this.addAnnotations(data, map, this.allowCollapsing && this.collapseClasses, false);
    }

    private void addAnnotations(ArrayList codeData, Map map, boolean collapsed, boolean isComment) {
        int i = 0;
        while (i < codeData.size()) {
            Object data = codeData.get(i);
            if (data != null) {
                AnnotatedPosition position = null;
                position = isComment ? this.createAnnotatedPosition((PHPDocBlock)data) : this.createAnnotatedPosition((PHPCodeData)data);
                if (position != null) {
                    position.setAnnotation(new PHPProjectionAnnotation(data, collapsed, isComment));
                    map.put(position.getAnnotation(), position);
                }
            }
            ++i;
        }
    }

    private AnnotatedPosition createAnnotatedPosition(PHPCodeData element) {
        if (this.document == null) {
            return null;
        }
        try {
            int start = this.document.getLineOfOffset(element.getUserData().getStopPosition());
            int end = this.document.getLineOfOffset(element.getUserData().getEndPosition());
            return this.createAnnotatedPosition(start, end);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private AnnotatedPosition createAnnotatedPosition(PHPDocBlock element) {
        if (this.document == null) {
            return null;
        }
        try {
            int start = this.document.getLineOfOffset(element.getStartPosition());
            int end = this.document.getLineOfOffset(element.getEndPosition() + 1);
            return this.createCommentAnnotatedPosition(start, end);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private AnnotatedPosition createAnnotatedPosition(int start, int end) throws BadLocationException {
        if (start != end) {
            int endOffset;
            int offset = this.document.getLineOffset(start);
            if (this.document.getNumberOfLines() > end + 1) {
                endOffset = this.document.getLineOffset(end + 1);
            } else if (end > start) {
                endOffset = this.document.getLineOffset(end) + this.document.getLineLength(end);
            } else {
                return null;
            }
            return new AnnotatedPosition(offset, endOffset - offset);
        }
        return null;
    }

    private AnnotatedPosition createCommentAnnotatedPosition(int start, int end) throws BadLocationException {
        if (start != end) {
            int endOffset;
            int offset = this.document.getLineOffset(start);
            if (this.document.getNumberOfLines() > end + 1) {
                endOffset = this.document.getLineOffset(end + 1);
            } else if (end > start) {
                endOffset = this.document.getLineOffset(end) + this.document.getLineLength(end);
            } else {
                return null;
            }
            return new CommentAnnotatedPosition(offset, endOffset - offset);
        }
        return null;
    }

    private boolean isInComment(IStructuredDocument document, int offset) throws BadLocationException {
        IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(offset);
        ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (textRegion == null) {
            return false;
        }
        IStructuredDocumentRegion container = sdRegion;
        if (textRegion instanceof ITextRegionContainer) {
            container = (ITextRegionContainer)textRegion;
            textRegion = container.getRegionAtCharacterOffset(offset);
        }
        if (textRegion.getType() == "PHP_OPEN") {
            return false;
        }
        if (textRegion.getType() == "PHP_CLOSE") {
            if (container.getStartOffset(textRegion) == offset) {
                ITextRegion regionBefore = container.getRegionAtCharacterOffset(offset - 1);
                if (regionBefore instanceof IPhpScriptRegion) {
                    textRegion = regionBefore;
                }
            } else {
                return false;
            }
        }
        IPhpScriptRegion phpScriptRegion = null;
        String partitionType = null;
        int internalOffset = 0;
        if (textRegion instanceof IPhpScriptRegion) {
            String regionType;
            phpScriptRegion = (IPhpScriptRegion)textRegion;
            internalOffset = offset - container.getStartOffset() - phpScriptRegion.getStart();
            partitionType = phpScriptRegion.getPartition(internalOffset);
            if (!(partitionType != "org.eclipse.php.PHP_MULTI_LINE_COMMENT" && partitionType != "org.eclipse.php.PHP_DOC" || (regionType = phpScriptRegion.getPhpToken(internalOffset).getType()) != "PHP_COMMENT_START" && regionType != "PHPDOC_COMMENT_START" || phpScriptRegion.getPhpToken(internalOffset).getStart() != internalOffset)) {
                partitionType = phpScriptRegion.getPartition(internalOffset - 1);
            }
            return partitionType == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || partitionType == "org.eclipse.php.PHP_DOC";
        }
        return false;
    }

    public void dataCleared() {
    }

    public void fileDataAdded(PHPFileData fileData) {
        IStructuredModel sModel = null;
        try {
            try {
                DOMModelForPHP editorModel;
                sModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
                if (sModel != null && sModel instanceof DOMModelForPHP && (editorModel = (DOMModelForPHP)sModel).getFileData() == fileData) {
                    this.updateFolds();
                }
            }
            catch (Throwable throwable) {
                if (sModel != null) {
                    sModel.releaseFromRead();
                }
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
    }

    public void fileDataChanged(PHPFileData fileData) {
    }

    public void fileDataRemoved(PHPFileData fileData) {
    }

    private class AnnotatedPosition
    extends Position {
        private ProjectionAnnotation annotation;

        public AnnotatedPosition(int offset, int length) {
            super(offset, length);
        }

        public AnnotatedPosition(int offset, int length, ProjectionAnnotation annotation) {
            super(offset, length);
            this.annotation = annotation;
        }

        public ProjectionAnnotation getAnnotation() {
            return this.annotation;
        }

        public void setAnnotation(ProjectionAnnotation annotation) {
            this.annotation = annotation;
        }

        public String toString() {
            return "[AnnotatedPosition (" + this.getOffset() + ", " + this.getLength() + ")]";
        }
    }

    private class CommentAnnotatedPosition
    extends AnnotatedPosition
    implements IProjectionPosition {
        public CommentAnnotatedPosition(int offset, int length) {
            super(offset, length);
        }

        public CommentAnnotatedPosition(int offset, int length, ProjectionAnnotation annotation) {
            super(offset, length, annotation);
        }

        public int computeCaptionOffset(IDocument document) throws BadLocationException {
            return this.findFirstContent(document, this.getOffset(), this.getLength());
        }

        public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
            Region preRegion;
            int contentStart = this.findFirstContent(document, this.getOffset(), this.getLength());
            int firstLine = document.getLineOfOffset(this.getOffset());
            int captionLine = document.getLineOfOffset(this.getOffset() + contentStart);
            int lastLine = document.getLineOfOffset(this.getOffset() + this.getLength());
            if (firstLine < captionLine) {
                int preOffset = document.getLineOffset(firstLine);
                IRegion preEndLineInfo = document.getLineInformation(captionLine);
                int preEnd = preEndLineInfo.getOffset();
                preRegion = new Region(preOffset, preEnd - preOffset);
            } else {
                preRegion = null;
            }
            if (captionLine < lastLine) {
                int postOffset = document.getLineOffset(captionLine + 1);
                Region postRegion = new Region(postOffset, this.getOffset() + this.getLength() - postOffset);
                if (preRegion == null) {
                    return new IRegion[]{postRegion};
                }
                return new IRegion[]{preRegion, postRegion};
            }
            if (preRegion != null) {
                return new IRegion[]{preRegion};
            }
            return null;
        }

        private int findFirstContent(IDocument document, int offset, int length) throws BadLocationException {
            int index = 0;
            while (index < length) {
                char currentChar = document.getChar(offset + index);
                if (Character.isUnicodeIdentifierPart(currentChar)) {
                    return index;
                }
                ++index;
            }
            return 0;
        }
    }

    private class FoldingTimerTask
    extends TimerTask {
        private FoldingTimerTask() {
        }

        public void run() {
            DefaultPHPFoldingStructureProvider.this.updateFolds();
            DefaultPHPFoldingStructureProvider.this.timer.cancel();
        }
    }

    private class PHPModelStateListener
    implements IModelStateListener {
        private PHPModelStateListener() {
        }

        public void modelChanged(IStructuredModel model) {
            if (DefaultPHPFoldingStructureProvider.this.timer != null) {
                DefaultPHPFoldingStructureProvider.this.timer.cancel();
            }
            DefaultPHPFoldingStructureProvider.this.timer = new Timer(false);
            DefaultPHPFoldingStructureProvider.this.timer.schedule((TimerTask)new FoldingTimerTask(), 1000L);
        }

        public void modelAboutToBeChanged(IStructuredModel model) {
        }

        public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
        }

        public void modelResourceDeleted(IStructuredModel model) {
        }

        public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
        }

        public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
        }

        public void modelReinitialized(IStructuredModel structuredModel) {
        }
    }

    private static final class PHPProjectionAnnotation
    extends ProjectionAnnotation {
        private Object phpElement;
        private boolean isComment;

        public PHPProjectionAnnotation(Object phpElement, boolean isCollapsed, boolean isComment) {
            super(isCollapsed);
            this.phpElement = phpElement;
            this.isComment = isComment;
        }

        public Object getElement() {
            return this.phpElement;
        }

        public void setElement(PHPCodeData phpElement) {
            this.phpElement = phpElement;
        }

        public boolean isComment() {
            return this.isComment;
        }

        public void setIsComment(boolean isComment) {
            this.isComment = isComment;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof PHPProjectionAnnotation) {
                return this.phpElement.equals(((PHPProjectionAnnotation)((Object)other)).phpElement);
            }
            return false;
        }

        public String toString() {
            return "PHPProjectionAnnotation:\n\telement: \t" + this.phpElement.toString() + "\n" + "\tcollapsed: \t" + this.isCollapsed() + "\n" + "\tcomment: \t" + this.isComment + "\n";
        }
    }
}

