/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.projection;

import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterFactoryHTML;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterPHP;
import org.eclipse.php.internal.ui.folding.projection.ProjectionViewerInformation;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ProjectionModelNodeAdapterFactoryPHP
extends ProjectionModelNodeAdapterFactoryHTML {
    private boolean foldingClasses;
    private boolean foldingFunctions;
    private boolean foldingPhpDoc;

    public ProjectionModelNodeAdapterFactoryPHP() {
        this(ProjectionModelNodeAdapterPHP.class);
    }

    public ProjectionModelNodeAdapterFactoryPHP(Object adapterKey, boolean registerAdapters) {
        super(adapterKey, registerAdapters);
        this.initializePreference();
    }

    public ProjectionModelNodeAdapterFactoryPHP(Object adapterKey) {
        super(adapterKey);
        this.initializePreference();
    }

    public void initializePreference() {
        IPreferenceStore store = PHPUiPlugin.getDefault().getPreferenceStore();
        this.foldingClasses = store.getBoolean("foldClasses");
        this.foldingFunctions = store.getBoolean("foldFunctions");
        this.foldingPhpDoc = store.getBoolean("foldPHPDoc");
    }

    boolean isFoldingClasses() {
        return this.foldingClasses;
    }

    boolean isFoldingFunctions() {
        return this.foldingFunctions;
    }

    boolean isFoldingPhpDoc() {
        return this.foldingPhpDoc;
    }

    protected INodeAdapter createAdapter(INodeNotifier target) {
        Document document;
        if (this.isActive() && target instanceof Node && ((Node)target).getNodeType() == 9 && (document = (Document)target) instanceof INodeNotifier) {
            INodeNotifier documentNotifier = (INodeNotifier)document;
            ProjectionModelNodeAdapterPHP documentAdapter = (ProjectionModelNodeAdapterPHP)documentNotifier.getExistingAdapter(ProjectionModelNodeAdapterPHP.class);
            if (documentAdapter == null) {
                documentAdapter = new ProjectionModelNodeAdapterPHP(this);
                documentNotifier.addAdapter((INodeAdapter)documentAdapter);
            }
            documentAdapter.updateAdapter(document);
        }
        return null;
    }

    public ProjectionViewerInformation getInformation(ProjectionViewer viewer) {
        return (ProjectionViewerInformation)this.fProjectionViewers.get(viewer);
    }

    public ProjectionViewer findViewer(DOMModelForPHP phpModel) {
        if (this.fProjectionViewers == null) {
            return null;
        }
        for (Map.Entry entry : this.fProjectionViewers.entrySet()) {
            ProjectionViewer viewer = (ProjectionViewer)entry.getKey();
            if (viewer.getDocument() != phpModel.getStructuredDocument()) continue;
            return (ProjectionViewer)entry.getKey();
        }
        throw new IllegalStateException(PHPUIMessages.getString("ProjectionModelNodeAdapterFactoryPHP.0"));
    }
}

