/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.folding.projection;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.php.internal.ui.folding.projection.ProjectionModelNodeAdapterFactoryHTML;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Node;

public class ProjectionModelNodeAdapterHTML
implements INodeAdapter {
    private static final boolean debugProjectionPerf = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.html.ui/projectionperf"));
    ProjectionModelNodeAdapterFactoryHTML fAdapterFactory;
    protected Map<ProjectionAnnotation, Position> previousAnnotations = new HashMap<ProjectionAnnotation, Position>();

    public ProjectionModelNodeAdapterHTML(ProjectionModelNodeAdapterFactoryHTML factory) {
        this.fAdapterFactory = factory;
    }

    private Position createProjectionPosition(Node node) {
        Position pos = null;
        if (this.fAdapterFactory.isNodeProjectable(node) && node instanceof IndexedRegion) {
            IndexedRegion inode = (IndexedRegion)node;
            int start = inode.getStartOffset();
            int end = inode.getEndOffset();
            if (start >= 0 && start < end) {
                pos = new Position(start, end - start);
            }
        }
        return pos;
    }

    private TagProjectionAnnotation getExistingAnnotation(Node node) {
        TagProjectionAnnotation anno = null;
        if (node != null && !this.previousAnnotations.isEmpty()) {
            Iterator<ProjectionAnnotation> it = this.previousAnnotations.keySet().iterator();
            while (it.hasNext() && anno == null) {
                TagProjectionAnnotation a = (TagProjectionAnnotation)it.next();
                Node n = a.getNode();
                if (!node.equals(n)) continue;
                anno = a;
            }
        }
        return anno;
    }

    public boolean isAdapterForType(Object type) {
        return type == ProjectionModelNodeAdapterHTML.class;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        if (!this.fAdapterFactory.isActive()) {
            return;
        }
        if (eventType == 4 && notifier instanceof Node) {
            this.updateAdapter((Node)notifier);
        }
    }

    public void updateAdapter(Node node) {
        this.updateAdapter(node, null);
    }

    void updateAdapter(Node node, ProjectionViewer viewer) {
        long start = System.currentTimeMillis();
        HashMap<TagProjectionAnnotation, Position> additions = new HashMap<TagProjectionAnnotation, Position>();
        HashMap<ProjectionAnnotation, Position> projectionAnnotations = new HashMap<ProjectionAnnotation, Position>();
        if (node != null) {
            Node childNode = node.getFirstChild();
            while (childNode != null) {
                Position newPos = this.createProjectionPosition(childNode);
                if (newPos != null) {
                    TagProjectionAnnotation newAnnotation = new TagProjectionAnnotation(childNode, false);
                    TagProjectionAnnotation existing = this.getExistingAnnotation(childNode);
                    if (existing == null) {
                        projectionAnnotations.put(newAnnotation, newPos);
                        additions.put(newAnnotation, newPos);
                    } else {
                        projectionAnnotations.put(existing, newPos);
                        this.previousAnnotations.remove((Object)existing);
                    }
                }
                childNode = childNode.getNextSibling();
            }
            ProjectionAnnotation[] oldList = null;
            if (!this.previousAnnotations.isEmpty()) {
                oldList = this.previousAnnotations.keySet().toArray(new ProjectionAnnotation[0]);
            }
            projectionAnnotations.isEmpty();
            if (viewer != null && !projectionAnnotations.isEmpty()) {
                this.fAdapterFactory.queueAnnotationModelChanges(node, null, projectionAnnotations, null, viewer);
            }
            if (oldList != null && oldList.length > 0 || !additions.isEmpty()) {
                this.fAdapterFactory.queueAnnotationModelChanges(node, (Annotation[])oldList, additions, new HashMap());
            }
        }
        this.previousAnnotations = projectionAnnotations;
        if (debugProjectionPerf) {
            long end = System.currentTimeMillis();
            String nodeName = node != null ? node.getNodeName() : "null";
            System.out.println("ProjectionModelNodeAdapterHTML.updateAdapter (" + nodeName + "):" + (end - start));
        }
    }

    private static class TagProjectionAnnotation
    extends ProjectionAnnotation {
        private boolean fIsVisible = false;
        private Node fNode;

        public TagProjectionAnnotation(Node node, boolean isCollapsed) {
            super(isCollapsed);
            this.fNode = node;
        }

        public Node getNode() {
            return this.fNode;
        }

        public void setNode(Node node) {
            this.fNode = node;
        }

        public void paint(GC gc, Canvas canvas, Rectangle rectangle) {
            FontMetrics metrics;
            if (!this.isCollapsed() && (metrics = gc.getFontMetrics()) != null && rectangle.height / metrics.getHeight() <= 1) {
                this.fIsVisible = false;
                return;
            }
            this.fIsVisible = true;
            super.paint(gc, canvas, rectangle);
        }

        public void markCollapsed() {
            if (this.fIsVisible) {
                super.markCollapsed();
            }
        }
    }
}

