/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.outline;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.core.documentModel.dom.Utils;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.SortAction;
import org.eclipse.php.internal.ui.outline.ChangeOutlineModeAction;
import org.eclipse.php.internal.ui.outline.PHPNodeActionManager;
import org.eclipse.php.internal.ui.outline.PHPOutlineContentProvider;
import org.eclipse.php.internal.ui.outline.PHPOutlineLabelProvider;
import org.eclipse.php.internal.ui.outline.ShowGroupsAction;
import org.eclipse.php.internal.ui.treecontent.TreeProvider;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.internal.ui.util.PHPElementLabels;
import org.eclipse.php.internal.ui.util.PHPOutlineElementComparer;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.html.ui.views.contentoutline.HTMLContentOutlineConfiguration;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.eclipse.wst.xml.ui.internal.contentoutline.XMLNodeActionManager;

public class PHPContentOutlineConfiguration
extends HTMLContentOutlineConfiguration {
    protected PHPOutlineContentProvider fContentProvider = null;
    protected PHPOutlineLabelProvider fLabelProvider = null;
    IPHPTreeContentProvider[] treeProviders;
    private IPropertyChangeListener propertyChangeListener;
    private ChangeOutlineModeAction changeOutlineModeActionPHP;
    private ChangeOutlineModeAction changeOutlineModeActionHTML;
    DoubleClickListener doubleClickListener = new DoubleClickListener();
    private SortAction sortAction;
    private JFaceNodeLabelProvider fSimpleLabelProvider;
    private ShowGroupsAction fShowGroupsAction;

    protected IContributionItem[] createMenuContributions(TreeViewer viewer) {
        this.changeOutlineModeActionPHP = new ChangeOutlineModeAction(PHPUIMessages.getString("PHPOutlinePage_mode_php"), 1, viewer);
        ActionContributionItem showPHPItem = new ActionContributionItem((IAction)this.changeOutlineModeActionPHP);
        this.changeOutlineModeActionHTML = new ChangeOutlineModeAction(PHPUIMessages.getString("PHPOutlinePage_mode_html"), 2, viewer);
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("checked")) {
                    boolean checked = (Boolean)event.getNewValue();
                    if (PHPContentOutlineConfiguration.this.sortAction != null) {
                        PHPContentOutlineConfiguration.this.sortAction.setEnabled(!checked);
                    }
                }
            }
        };
        this.changeOutlineModeActionHTML.addPropertyChangeListener(this.propertyChangeListener);
        ActionContributionItem showHTMLItem = new ActionContributionItem((IAction)this.changeOutlineModeActionHTML);
        IContributionItem[] items = super.createMenuContributions(viewer);
        if (items == null) {
            items = new IContributionItem[]{showPHPItem, showHTMLItem};
        } else {
            IContributionItem[] combinedItems = new IContributionItem[items.length + 2];
            System.arraycopy(items, 0, combinedItems, 0, items.length);
            combinedItems[items.length] = showPHPItem;
            combinedItems[items.length + 1] = showHTMLItem;
            items = combinedItems;
        }
        if (this.changeOutlineModeActionHTML.isChecked()) {
            this.sortAction.setEnabled(false);
        }
        return items;
    }

    public DoubleClickListener getDoubleClickListener() {
        return this.doubleClickListener;
    }

    protected IContributionItem[] createToolbarContributions(TreeViewer viewer) {
        this.fShowGroupsAction = new ShowGroupsAction("Show Groups", viewer);
        ActionContributionItem showGroupsItem = new ActionContributionItem((IAction)this.fShowGroupsAction);
        IContributionItem[] menuContributions = super.createMenuContributions(viewer);
        IContributionItem toggleLinking = menuContributions[0];
        int i = 1;
        while (i < menuContributions.length) {
            menuContributions[i].dispose();
            ++i;
        }
        this.sortAction = new SortAction(viewer);
        ActionContributionItem sortItem = new ActionContributionItem((IAction)this.sortAction);
        IContributionItem[] items = super.createToolbarContributions(viewer);
        if (items == null) {
            items = new IContributionItem[]{sortItem, showGroupsItem};
        } else {
            IContributionItem[] combinedItems = new IContributionItem[items.length + 3];
            System.arraycopy(items, 0, combinedItems, 0, items.length);
            combinedItems[items.length] = sortItem;
            combinedItems[items.length + 1] = showGroupsItem;
            combinedItems[items.length + 2] = toggleLinking;
            items = combinedItems;
        }
        return items;
    }

    public void unconfigure(TreeViewer viewer) {
        if (this.fShowGroupsAction != null) {
            this.fShowGroupsAction.dispose();
        }
        if (this.changeOutlineModeActionHTML != null && this.propertyChangeListener != null) {
            this.changeOutlineModeActionHTML.removePropertyChangeListener(this.propertyChangeListener);
        }
        super.unconfigure(viewer);
    }

    public IContentProvider getContentProvider(TreeViewer viewer) {
        if (this.fContentProvider == null) {
            viewer.setComparer((IElementComparer)new PHPOutlineElementComparer());
            PHPOutlineLabelProvider labelProvider = (PHPOutlineLabelProvider)this.getLabelProvider(viewer);
            this.fContentProvider = new PHPOutlineContentProvider(viewer, labelProvider);
            this.fContentProvider.phpContentProvider.setTreeProviders(this.getTreeProviders());
        }
        return this.fContentProvider;
    }

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new PHPOutlineLabelProvider();
            this.fLabelProvider.setTreeProviders(this.getTreeProviders());
        }
        return this.fLabelProvider;
    }

    public ISelection getSelection(TreeViewer viewer, ISelection selection) {
        IContentProvider contentProvider = viewer.getContentProvider();
        if (contentProvider instanceof PHPOutlineContentProvider) {
            PHPCodeData codeData;
            IStructuredSelection structuredSelection;
            Object obj;
            PHPOutlineContentProvider phpOutline = (PHPOutlineContentProvider)contentProvider;
            if (phpOutline.mode == 1 && selection instanceof IStructuredSelection && selection instanceof TextSelection && (obj = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof NodeImpl && (codeData = Utils.getPHPCodeData((NodeImpl)((NodeImpl)obj), (int)((TextSelection)selection).getOffset())) != null) {
                return new StructuredSelection((Object)codeData);
            }
        }
        return super.getSelection(viewer, selection);
    }

    protected IPHPTreeContentProvider[] getTreeProviders() {
        if (this.treeProviders == null) {
            this.treeProviders = TreeProvider.getTreeProviders("org.eclipse.ui.views.ContentOutline");
        }
        return this.treeProviders;
    }

    public ILabelProvider getStatusLineLabelProvider(TreeViewer treeViewer) {
        if (this.fSimpleLabelProvider == null) {
            this.fSimpleLabelProvider = new StatusLineLabelProvider(treeViewer);
        }
        return this.fSimpleLabelProvider;
    }

    protected XMLNodeActionManager createNodeActionManager(TreeViewer treeViewer) {
        return new PHPNodeActionManager((IStructuredModel)treeViewer.getInput(), (Viewer)treeViewer);
    }

    protected void enableShowAttributes(boolean showAttributes, TreeViewer treeViewer) {
        super.enableShowAttributes(showAttributes, treeViewer);
        ((PHPOutlineLabelProvider)this.getLabelProvider(treeViewer)).setShowAttributes(showAttributes);
    }

    public static class DoubleClickListener
    implements IDoubleClickListener {
        private boolean enabled;

        public void doubleClick(DoubleClickEvent event) {
            ISelection selection = event.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (!(element instanceof PHPCodeData)) {
                return;
            }
            try {
                IEditorPart editor = EditorUtility.openInEditor(element, true);
                if (editor != null) {
                    EditorUtility.revealInEditor(editor, (PHPCodeData)element);
                }
            }
            catch (PartInitException partInitException) {}
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    private class StatusLineLabelProvider
    extends JFaceNodeLabelProvider {
        TreeViewer treeViewer = null;

        public StatusLineLabelProvider(TreeViewer viewer) {
            this.treeViewer = viewer;
        }

        public String getText(Object element) {
            if (element == null) {
                return null;
            }
            return PHPElementLabels.getTextLabel(element, 1090519051L);
        }
    }
}

