/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.outline;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.StandardPHPElementContentProvider;
import org.eclipse.php.internal.ui.SuperClassTreeContentProvider;
import org.eclipse.php.internal.ui.outline.PHPOutlineLabelProvider;
import org.eclipse.php.internal.ui.treecontent.PHPTreeNode;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeContentProvider;

public class PHPOutlineContentProvider
extends JFaceNodeContentProvider
implements ModelListener {
    private static final Image CLASSES_GROUP_IMAGE = PHPPluginImages.DESC_OBJ_PHP_CLASSES_GROUP.createImage();
    private static final Image CONSTANTS_GROUP_IMAGE = PHPPluginImages.DESC_OBJ_PHP_CONSTANTS_GROUP.createImage();
    private static final Image FUNCTIONS_GROUP_IMAGE = PHPPluginImages.DESC_OBJ_PHP_FUNCTIONS_GROUP.createImage();
    public static final int GROUP_CLASSES = 3;
    public static final int GROUP_CONSTANTS = 2;
    public static final int GROUP_FUNCTIONS = 4;
    public static final int GROUP_INCLUDES = 1;
    private static final Image INCLUDES_GROUP_IMAGE = PHPPluginImages.DESC_OBJS_INCLUDE.createImage();
    public static final int MODE_HTML = 2;
    public static final int MODE_MIXED = 3;
    public static final int MODE_PHP = 1;
    DOMModelForPHP editorModel;
    private ISelectionListener fSelectionListener = null;
    GroupNode[] groupNodes;
    private PHPOutlineLabelProvider labelProvider;
    int mode;
    StandardPHPElementContentProvider phpContentProvider = new StandardPHPElementContentProvider(true);
    boolean showGroups;
    ITreeContentProvider superClassContentProvider = new SuperClassTreeContentProvider((ITreeContentProvider)this);
    TreeViewer viewer;

    public PHPOutlineContentProvider(TreeViewer viewer, PHPOutlineLabelProvider labelProvider) {
        this.viewer = viewer;
        this.labelProvider = labelProvider;
        this.mode = PHPUiPlugin.getDefault().getPreferenceStore().getInt("ChangeOutlineModeAction.selectedMode");
        if (this.mode == 0) {
            this.mode = 1;
            PHPUiPlugin.getDefault().getPreferenceStore().setValue("ChangeOutlineModeAction.selectedMode", this.mode);
        }
        this.showGroups = PHPUiPlugin.getDefault().getPreferenceStore().getBoolean("ShowGroupsAction.show");
        PHPUiPlugin.getActiveWorkbenchWindow().getSelectionService().addPostSelectionListener(this.getSelectionServiceListener());
        this.registerMouseTrackListener();
    }

    public void dataCleared() {
    }

    public void dispose() {
        PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
        PHPUiPlugin.getActiveWorkbenchWindow().getSelectionService().removePostSelectionListener(this.getSelectionServiceListener());
        super.dispose();
    }

    public void fileDataAdded(PHPFileData fileData) {
        if (this.editorModel != null && this.editorModel.getFileData() != null && this.editorModel.getFileData().getComparableName().equals(fileData.getComparableName())) {
            this.postRefresh(true);
        }
    }

    public void fileDataChanged(PHPFileData fileData) {
        if (this.editorModel != null && this.editorModel.getFileData() != null && this.editorModel.getFileData().getComparableName().equals(fileData.getComparableName())) {
            if (this.groupNodes == null) {
                this.postRefresh(true);
            } else {
                int i = 0;
                while (i < this.groupNodes.length) {
                    this.groupNodes[i].reset(fileData);
                    this.postRefresh(this.groupNodes[i], true);
                    ++i;
                }
            }
        }
    }

    public void fileDataRemoved(PHPFileData fileData) {
    }

    public Object[] getChildren(Object object) {
        if (object instanceof PHPCodeData) {
            ArrayList children = new ArrayList(Arrays.asList(this.phpContentProvider.getChildren(object)));
            children.addAll(Arrays.asList(this.superClassContentProvider.getChildren(object)));
            return children.toArray();
        }
        if (object instanceof DOMModelForPHP && this.mode == 1) {
            Object[] groupNodes;
            this.editorModel = (DOMModelForPHP)object;
            this.editorModel.getDocument().getAdapterFor(IJFaceNodeAdapter.class);
            PHPFileData fileData = this.editorModel.getFileData();
            if (fileData != null && (groupNodes = this.getGroupNodes(fileData)) != null) {
                return groupNodes;
            }
            return this.getChildren(fileData);
        }
        if (object instanceof GroupNode) {
            return ((GroupNode)object).getChildren();
        }
        if (object instanceof PHPTreeNode) {
            return ((PHPTreeNode)object).getChildren();
        }
        return super.getChildren(object);
    }

    public Object[] getElements(Object object) {
        if (object instanceof PHPCodeData) {
            return this.phpContentProvider.getChildren(object);
        }
        if (object instanceof DOMModelForPHP && this.mode == 1) {
            this.editorModel = (DOMModelForPHP)object;
            this.editorModel.getDocument().getAdapterFor(IJFaceNodeAdapter.class);
            PHPFileData fileData = this.editorModel.getFileData();
            Object[] groupNodes = this.getGroupNodes(fileData);
            if (groupNodes != null) {
                return groupNodes;
            }
            return this.getElements(fileData);
        }
        return super.getElements(object);
    }

    GroupNode[] getGroupNodes(PHPFileData fileData) {
        if (this.showGroups) {
            if (this.groupNodes != null) {
                int i = 0;
                while (i < this.groupNodes.length) {
                    this.groupNodes[i].setFileData(fileData);
                    ++i;
                }
            } else {
                this.groupNodes = new GroupNode[]{new GroupNode(1, "include files", fileData), new GroupNode(2, "constants", fileData), new GroupNode(3, "classes", fileData), new GroupNode(4, "functions", fileData)};
            }
        } else {
            this.groupNodes = null;
        }
        return this.groupNodes;
    }

    public int getMode() {
        return this.mode;
    }

    public Object getParent(Object object) {
        if (object instanceof PHPCodeData) {
            Object parent = this.superClassContentProvider.getParent(object);
            if (parent != null) {
                return parent;
            }
            PHPCodeData codeData = (PHPCodeData)object;
            PHPCodeData container = codeData.getContainer();
            if (container instanceof PHPFileData && this.showGroups) {
                int i = 0;
                while (i < this.groupNodes.length) {
                    Object[] children = this.groupNodes[i].getChildren();
                    int j = 0;
                    while (j < children.length) {
                        if (children[j] == object) {
                            return this.groupNodes[i];
                        }
                        ++j;
                    }
                    ++i;
                }
            } else {
                return container;
            }
        }
        return super.getParent(object);
    }

    private ISelectionListener getSelectionServiceListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new PostSelectionServiceListener();
        }
        return this.fSelectionListener;
    }

    public boolean getShowGroups() {
        return this.showGroups;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof PHPCodeData) {
            if (this.superClassContentProvider.hasChildren(object)) {
                return true;
            }
            Object[] phpChildren = this.getChildren(object);
            return phpChildren.length > 0;
        }
        if (object instanceof GroupNode) {
            return ((GroupNode)object).hasChildren();
        }
        if (object instanceof PHPTreeNode) {
            return ((PHPTreeNode)object).hasChildren();
        }
        return super.hasChildren(object);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (oldInput == null && newInput != null) {
            PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this);
            this.postRefresh(newInput, true);
        } else if (oldInput != null && newInput == null) {
            PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this);
            this.postRefresh(true);
        }
    }

    boolean isInside(int start, int end, PHPCodeData codeData) {
        UserData userData = codeData.getUserData();
        if (userData == null) {
            return false;
        }
        return start <= userData.getStartPosition() && end >= userData.getEndPosition();
    }

    private void postRefresh(boolean updateLabels) {
        this.postRefresh(null, updateLabels);
    }

    private void postRefresh(final Object element, final boolean updateLabels) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (PHPOutlineContentProvider.this.viewer == null) {
                    return;
                }
                Control control = PHPOutlineContentProvider.this.viewer.getControl();
                if (control == null || control.isDisposed()) {
                    return;
                }
                if (element == null) {
                    PHPOutlineContentProvider.this.viewer.refresh(updateLabels);
                } else {
                    PHPOutlineContentProvider.this.viewer.refresh(element, updateLabels);
                }
                if (element instanceof DOMModelForPHP) {
                    PHPOutlineContentProvider.this.viewer.expandToLevel(2);
                }
            }
        };
        Control control = this.viewer.getControl();
        if (control != null && !control.isDisposed()) {
            this.viewer.getControl().getDisplay().asyncExec(runnable);
        }
    }

    private void registerMouseTrackListener() {
        final Tree tree = this.viewer.getTree();
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                Object o;
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item != null && (o = item.getData()) instanceof PHPCodeData) {
                    tree.setToolTipText(PHPOutlineContentProvider.this.labelProvider.getTooltipText(o));
                }
            }
        });
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setShowGroups(boolean show) {
        this.showGroups = show;
        this.postRefresh(true);
    }

    public static class GroupNode
    implements Comparable {
        Object[] children;
        PHPFileData fileData;
        String text;
        int type;

        GroupNode(int type, String text, PHPFileData fileData) {
            this.type = type;
            this.text = text;
            this.fileData = fileData;
        }

        public int compareTo(Object other) {
            if (this == other) {
                return 0;
            }
            if (other instanceof GroupNode) {
                GroupNode otherNode = (GroupNode)other;
                return this.type - otherNode.type;
            }
            return 0;
        }

        public Object[] getChildren() {
            if (this.children == null) {
                this.loadChildren();
            }
            return this.children;
        }

        public Image getImage() {
            switch (this.type) {
                case 3: {
                    return CLASSES_GROUP_IMAGE;
                }
                case 4: {
                    return FUNCTIONS_GROUP_IMAGE;
                }
                case 2: {
                    return CONSTANTS_GROUP_IMAGE;
                }
                case 1: {
                    return INCLUDES_GROUP_IMAGE;
                }
            }
            return null;
        }

        public String getText() {
            return this.text;
        }

        public boolean hasChildren() {
            if (this.children == null) {
                this.loadChildren();
            }
            return this.children.length > 0;
        }

        void loadChildren() {
            if (this.fileData != null) {
                switch (this.type) {
                    case 3: {
                        this.children = this.fileData.getClasses();
                        break;
                    }
                    case 4: {
                        this.children = this.fileData.getFunctions();
                        break;
                    }
                    case 2: {
                        this.children = this.fileData.getConstants();
                        break;
                    }
                    case 1: {
                        this.children = this.fileData.getIncludeFiles();
                    }
                }
            }
            if (this.children == null) {
                this.children = new Object[0];
            }
        }

        public void reset(PHPFileData fileData) {
            this.fileData = fileData;
            this.children = null;
        }

        public void setFileData(PHPFileData fileData) {
            this.fileData = fileData;
            this.loadChildren();
        }
    }

    private class PostSelectionServiceListener
    implements ISelectionListener {
        private PostSelectionServiceListener() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        }
    }
}

