/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.outline;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.outline.PHPOutlineContentProvider;
import org.eclipse.php.internal.ui.util.PHPPluginImages;

public class ShowGroupsAction
extends Action {
    public static final String PREF_SHOW_GROUPS = "ShowGroupsAction.show";
    private TreeViewer treeViewer;
    private IPropertyChangeListener propertyChangeListener;

    public ShowGroupsAction(String label, TreeViewer treeViewer) {
        super(label, 2);
        this.treeViewer = treeViewer;
        PHPPluginImages.setLocalImageDescriptors((IAction)this, "showGroups.gif");
        this.setToolTipText(PHPUIMessages.getString("ShowGroupsAction.1"));
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("ChangeOutlineModeAction.selectedMode")) {
                    ShowGroupsAction.this.setEnabled(ShowGroupsAction.this.isEnabled());
                }
            }
        };
        PHPUiPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
        boolean show = PHPUiPlugin.getDefault().getPreferenceStore().getBoolean(PREF_SHOW_GROUPS);
        this.setChecked(show);
    }

    public void dispose() {
        PHPUiPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
    }

    public void run() {
        IContentProvider contentProvider = this.treeViewer.getContentProvider();
        if (contentProvider instanceof PHPOutlineContentProvider) {
            PHPOutlineContentProvider phpContentProvider = (PHPOutlineContentProvider)contentProvider;
            phpContentProvider.setShowGroups(this.isChecked());
            this.treeViewer.refresh(false);
            this.treeViewer.expandToLevel(2);
            PHPUiPlugin.getDefault().getPreferenceStore().setValue(PREF_SHOW_GROUPS, this.isChecked());
        }
    }

    public boolean isEnabled() {
        IContentProvider contentProvider = this.treeViewer.getContentProvider();
        if (contentProvider instanceof PHPOutlineContentProvider) {
            PHPOutlineContentProvider phpContentProvider = (PHPOutlineContentProvider)contentProvider;
            return 1 == phpContentProvider.getMode();
        }
        return super.isEnabled();
    }
}

