/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.internal.core.IncludePathContainerInitializer;
import org.eclipse.php.internal.core.project.IIncludePathContainer;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.includepath.ArchieveFileFilter;
import org.eclipse.php.internal.ui.preferences.includepath.IPListElement;
import org.eclipse.php.internal.ui.preferences.includepath.IPListElementAttribute;
import org.eclipse.php.internal.ui.preferences.includepath.IPUserLibraryElement;
import org.eclipse.php.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.php.internal.ui.util.PHPElementImageDescriptor;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class IPListLabelProvider
extends LabelProvider {
    private String fNewLabel = PHPUIMessages.getString("CPListLabelProvider_new");
    private String fClassLabel = PHPUIMessages.getString("CPListLabelProvider_container");
    private String fCreateLabel = PHPUIMessages.getString("CPListLabelProvider_willbecreated");
    private ImageDescriptor fZipIcon;
    private ImageDescriptor fExtZipIcon;
    private ImageDescriptor fJarWSrcIcon;
    private ImageDescriptor fExtZipWSrcIcon;
    private ImageDescriptor fFolderImage;
    private ImageDescriptor fProjectImage;
    private ImageDescriptor fVariableImage;
    private ImageDescriptor fContainerImage;
    private ImageDescriptorRegistry fRegistry = PHPUiPlugin.getImageDescriptorRegistry();

    public IPListLabelProvider() {
        this.fZipIcon = PHPPluginImages.DESC_OBJS_ZIP;
        this.fExtZipIcon = PHPPluginImages.DESC_OBJS_EXTZIP;
        this.fFolderImage = PHPPluginImages.DESC_OBJS_PHP_FOLDER;
        this.fContainerImage = PHPPluginImages.DESC_OBJS_LIBRARY;
        this.fVariableImage = PHPPluginImages.DESC_OBJS_ENV_VAR;
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.fProjectImage = workbench.getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
    }

    public String getText(Object element) {
        if (element instanceof IPListElement) {
            return this.getCPListElementText((IPListElement)element);
        }
        if (element instanceof IPListElementAttribute) {
            IPListElementAttribute attribute = (IPListElementAttribute)element;
            String text = this.getCPListElementAttributeText(attribute);
            if (attribute.isInNonModifiableContainer()) {
                return MessageFormat.format(PHPUIMessages.getString("CPListLabelProvider_non_modifiable_attribute"), text);
            }
            return text;
        }
        if (element instanceof IPUserLibraryElement) {
            return this.getCPUserLibraryText((IPUserLibraryElement)element);
        }
        return super.getText(element);
    }

    public String getCPUserLibraryText(IPUserLibraryElement element) {
        String name = element.getName();
        if (element.isSystemLibrary()) {
            name = MessageFormat.format(PHPUIMessages.getString("CPListLabelProvider_systemlibrary"), name);
        }
        return name;
    }

    public String getCPListElementAttributeText(IPListElementAttribute attrib) {
        String notAvailable = PHPUIMessages.getString("CPListLabelProvider_none");
        attrib.getKey();
        return notAvailable;
    }

    public String getCPListElementText(IPListElement cpentry) {
        IPath path = cpentry.getPath();
        switch (cpentry.getEntryKind()) {
            case 1: {
                IResource resource = cpentry.getResource();
                if (resource instanceof IContainer) {
                    StringBuffer buf = new StringBuffer(path.makeRelative().toString());
                    buf.append(' ');
                    buf.append(this.fClassLabel);
                    if (!resource.exists()) {
                        buf.append(' ');
                        if (cpentry.isMissing()) {
                            buf.append(this.fCreateLabel);
                        } else {
                            buf.append(this.fNewLabel);
                        }
                    }
                    return buf.toString();
                }
                if (ArchieveFileFilter.isZipPath(path)) {
                    return this.getPathString(path, resource == null);
                }
                return this.getPathString(path, resource == null);
            }
            case 4: {
                return this.getVariableString(path);
            }
            case 2: {
                return path.lastSegment();
            }
            case 5: {
                IIncludePathContainer container = PHPProjectOptions.getIncludePathContainer((IPath)path, (IProject)cpentry.getProject());
                if (container != null) {
                    return container.getDescription();
                }
                IncludePathContainerInitializer initializer = PHPProjectOptions.getIncludePathContainerInitializer((String)path.segment(0));
                if (initializer != null) {
                    String description = initializer.getDescription(path, cpentry.getProject());
                    return MessageFormat.format(PHPUIMessages.getString("CPListLabelProvider_unbound_library"), description);
                }
                return path.toString();
            }
            case 3: {
                StringBuffer buf = new StringBuffer(path.makeRelative().toString());
                IResource resource = cpentry.getResource();
                if (resource != null && !resource.exists()) {
                    buf.append(' ');
                    if (cpentry.isMissing()) {
                        buf.append(this.fCreateLabel);
                    } else {
                        buf.append(this.fNewLabel);
                    }
                }
                return buf.toString();
            }
        }
        return PHPUIMessages.getString("CPListLabelProvider_unknown_element_label");
    }

    private String getPathString(IPath path, boolean isExternal) {
        if (ArchieveFileFilter.isZipPath(path)) {
            IPath appendedPath = path.removeLastSegments(1);
            String appended = isExternal ? appendedPath.toOSString() : appendedPath.makeRelative().toString();
            return MessageFormat.format(PHPUIMessages.getString("CPListLabelProvider_twopart"), path.lastSegment(), appended);
        }
        return isExternal ? path.toOSString() : path.makeRelative().toString();
    }

    private String getVariableString(IPath path) {
        String name = path.makeRelative().toString();
        IPath entryPath = PHPProjectOptions.getIncludePathVariable((String)path.segment(0));
        if (entryPath != null) {
            String appended = entryPath.append(path.removeFirstSegments(1)).toOSString();
            return MessageFormat.format(PHPUIMessages.getString("CPListLabelProvider_twopart"), name, appended);
        }
        return name;
    }

    private ImageDescriptor getCPListElementBaseImage(IPListElement cpentry) {
        switch (cpentry.getEntryKind()) {
            case 3: {
                if (cpentry.getPath().segmentCount() == 1) {
                    return this.fProjectImage;
                }
                return this.fFolderImage;
            }
            case 1: 
            case 6: {
                IResource res = cpentry.getResource();
                if (res == null) {
                    if (cpentry.getContentKind() == 2) {
                        return this.fExtZipIcon;
                    }
                    return this.fContainerImage;
                }
                if (res instanceof IFile) {
                    return this.fZipIcon;
                }
                return this.fFolderImage;
            }
            case 2: {
                return this.fProjectImage;
            }
            case 4: {
                return this.fVariableImage;
            }
            case 5: {
                return this.fContainerImage;
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof IPListElement) {
            IPListElement cpentry = (IPListElement)element;
            Object imageDescriptor = this.getCPListElementBaseImage(cpentry);
            if (imageDescriptor != null) {
                if (cpentry.isMissing()) {
                    imageDescriptor = new PHPElementImageDescriptor((ImageDescriptor)imageDescriptor, 32, PHPElementImageDescriptor.SMALL_SIZE);
                }
                return this.fRegistry.get((ImageDescriptor)imageDescriptor);
            }
        } else {
            if (element instanceof IPListElementAttribute) {
                ((IPListElementAttribute)element).getKey();
                return this.fRegistry.get(this.fVariableImage);
            }
            if (element instanceof IPUserLibraryElement) {
                return this.fRegistry.get(PHPPluginImages.DESC_OBJS_LIBRARY);
            }
        }
        return null;
    }
}

