/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.php.internal.core.project.IIncludePathContainer;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.ui.preferences.includepath.IPListElement;

public class IPUserLibraryElement {
    private String fName;
    private List fChildren;
    private boolean fIsSystemLibrary;

    public IPUserLibraryElement(String name, IIncludePathContainer container, IProject project) {
        this.fName = name;
        this.fChildren = new ArrayList();
        if (container != null) {
            IIncludePathEntry[] entries = container.getIncludePathEntries();
            IPListElement[] res = new IPListElement[entries.length];
            int i = 0;
            while (i < res.length) {
                IIncludePathEntry curr = entries[i];
                IPListElement elem = IPListElement.createFromExisting(this, curr, project);
                this.fChildren.add(elem);
                ++i;
            }
            this.fIsSystemLibrary = container.getKind() == 2;
        } else {
            this.fIsSystemLibrary = false;
        }
    }

    public IPUserLibraryElement(String name, boolean isSystemLibrary, IPListElement[] children) {
        this.fName = name;
        this.fChildren = new ArrayList();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.fChildren.add(children[i]);
                ++i;
            }
        }
        this.fIsSystemLibrary = isSystemLibrary;
    }

    public IPListElement[] getChildren() {
        return this.fChildren.toArray(new IPListElement[this.fChildren.size()]);
    }

    public String getName() {
        return this.fName;
    }

    public IPath getPath() {
        return new Path("org.eclipse.php.USER_LIBRARY").append(this.fName);
    }

    public boolean isSystemLibrary() {
        return this.fIsSystemLibrary;
    }

    public void add(IPListElement element) {
        if (!this.fChildren.contains(element)) {
            this.fChildren.add(element);
        }
    }

    private List moveUp(List elements, List move) {
        int nElements = elements.size();
        ArrayList res = new ArrayList(nElements);
        Object floating = null;
        int i = 0;
        while (i < nElements) {
            Object curr = elements.get(i);
            if (move.contains(curr)) {
                res.add(curr);
            } else {
                if (floating != null) {
                    res.add(floating);
                }
                floating = curr;
            }
            ++i;
        }
        if (floating != null) {
            res.add(floating);
        }
        return res;
    }

    public void moveUp(List toMoveUp) {
        if (toMoveUp.size() > 0) {
            this.fChildren = this.moveUp(this.fChildren, toMoveUp);
        }
    }

    public void moveDown(List toMoveDown) {
        if (toMoveDown.size() > 0) {
            Collections.reverse(this.fChildren);
            this.fChildren = this.moveUp(this.fChildren, toMoveDown);
            Collections.reverse(this.fChildren);
        }
    }

    public void remove(IPListElement element) {
        this.fChildren.remove(element);
    }

    public void replace(IPListElement existingElement, IPListElement element) {
        if (this.fChildren.contains(element)) {
            this.fChildren.remove(existingElement);
        } else {
            int index = this.fChildren.indexOf(existingElement);
            if (index != -1) {
                this.fChildren.set(index, element);
            } else {
                this.fChildren.add(element);
            }
        }
    }

    public IIncludePathContainer getUpdatedContainer() {
        return new UpdatedIncludePathContainer();
    }

    public boolean hasChanges(IIncludePathContainer oldContainer) {
        if (oldContainer == null || oldContainer.getKind() == 2 != this.fIsSystemLibrary) {
            return true;
        }
        IIncludePathEntry[] oldEntries = oldContainer.getIncludePathEntries();
        if (this.fChildren.size() != oldEntries.length) {
            return true;
        }
        int i = 0;
        while (i < oldEntries.length) {
            IPListElement child = (IPListElement)this.fChildren.get(i);
            if (!child.getIncludePathEntry().equals(oldEntries[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class UpdatedIncludePathContainer
    implements IIncludePathContainer {
        private UpdatedIncludePathContainer() {
        }

        public IIncludePathEntry[] getIncludePathEntries() {
            IPListElement[] children = IPUserLibraryElement.this.getChildren();
            IIncludePathEntry[] entries = new IIncludePathEntry[children.length];
            int i = 0;
            while (i < entries.length) {
                entries[i] = children[i].getIncludePathEntry();
                ++i;
            }
            return entries;
        }

        public String getDescription() {
            return IPUserLibraryElement.this.getName();
        }

        public int getKind() {
            return IPUserLibraryElement.this.isSystemLibrary() ? 2 : 1;
        }

        public IPath getPath() {
            return IPUserLibraryElement.this.getPath();
        }
    }
}

