/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.includepath.IPListElement;
import org.eclipse.php.internal.ui.preferences.includepath.IPListElementAttribute;
import org.eclipse.php.internal.ui.preferences.includepath.IPListLabelProvider;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathBasePage;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathOrderingWorkbookPage;
import org.eclipse.php.internal.ui.preferences.includepath.LibrariesWorkbookPage;
import org.eclipse.php.internal.ui.preferences.includepath.ProjectsWorkbookPage;
import org.eclipse.php.internal.ui.util.ImageDisposer;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.ListDialogField;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class IncludePathBlock {
    private IWorkspaceRoot fWorkspaceRoot;
    private ListDialogField fIncludePathList;
    private StatusInfo fIncludePathStatus;
    private IProject fCurrProject;
    private PHPProjectOptions phpOptions = null;
    private IStatusChangeListener fContext;
    private Control fSWTWidget;
    private TabFolder fTabFolder;
    private int fPageIndex;
    private ProjectsWorkbookPage fProjectsPage;
    private LibrariesWorkbookPage fLibrariesPage;
    private IncludePathBasePage fCurrPage;
    private String fUserSettingsTimeStamp;
    private long fFileTimeStamp;
    private IRunnableContext fRunnableContext;
    private boolean fUseNewPage;
    private final IWorkbenchPreferenceContainer fPageContainer;

    public IncludePathBlock(IRunnableContext runnableContext, IStatusChangeListener context, int pageToShow, boolean useNewPage, IWorkbenchPreferenceContainer pageContainer) {
        this.fPageContainer = pageContainer;
        this.fWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.fContext = context;
        this.fUseNewPage = useNewPage;
        this.fPageIndex = pageToShow;
        this.fLibrariesPage = null;
        this.fProjectsPage = null;
        this.fCurrPage = null;
        this.fRunnableContext = runnableContext;
        IncludePathAdapter adapter = new IncludePathAdapter();
        String[] buttonLabels = new String[]{PHPUIMessages.getString("IncludePathsBlock_includepath_up_button"), PHPUIMessages.getString("IncludePathsBlock_includepath_down_button")};
        this.fIncludePathList = new ListDialogField(null, buttonLabels, (ILabelProvider)new IPListLabelProvider());
        this.fIncludePathList.setDialogFieldListener(adapter);
        this.fIncludePathList.setLabelText(PHPUIMessages.getString("IncludePathsBlock_includepath_label"));
        this.fIncludePathList.setUpButtonIndex(0);
        this.fIncludePathList.setDownButtonIndex(1);
        this.fIncludePathStatus = new StatusInfo();
        this.fCurrProject = null;
        this.phpOptions = null;
    }

    public Control createControl(Composite parent) {
        this.fSWTWidget = parent;
        new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayoutData((Object)new GridData(1808));
        folder.setFont(composite.getFont());
        IWorkbench workbench = PHPUiPlugin.getDefault().getWorkbench();
        Image projectImage = workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.fProjectsPage = new ProjectsWorkbookPage(this.fIncludePathList, this.fPageContainer);
        TabItem item = new TabItem(folder, 0);
        item.setText(PHPUIMessages.getString("IncludePathsBlock_tab_projects"));
        item.setImage(projectImage);
        item.setData((Object)this.fProjectsPage);
        item.setControl(this.fProjectsPage.getControl((Composite)folder));
        this.fLibrariesPage = new LibrariesWorkbookPage(this.fIncludePathList, this.fPageContainer);
        item = new TabItem(folder, 0);
        item.setText(PHPUIMessages.getString("IncludePathsBlock_tab_libraries"));
        item.setImage(PHPPluginImages.get("org.eclipse.php.ui.library_obj.gif"));
        item.setData((Object)this.fLibrariesPage);
        item.setControl(this.fLibrariesPage.getControl((Composite)folder));
        Image cpoImage = PHPPluginImages.DESC_TOOL_INCLUDEPATH_ORDER.createImage();
        composite.addDisposeListener((DisposeListener)new ImageDisposer(cpoImage));
        IncludePathOrderingWorkbookPage ordpage = new IncludePathOrderingWorkbookPage(this.fIncludePathList);
        item = new TabItem(folder, 0);
        item.setText(PHPUIMessages.getString("IncludePathsBlock_tab_order"));
        item.setImage(cpoImage);
        item.setData((Object)ordpage);
        item.setControl(ordpage.getControl((Composite)folder));
        if (this.fCurrProject != null) {
            this.fLibrariesPage.init(this.fCurrProject);
            this.fProjectsPage.init(this.fCurrProject);
        }
        folder.setSelection(this.fPageIndex);
        this.fCurrPage = (IncludePathBasePage)folder.getItem(this.fPageIndex).getData();
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IncludePathBlock.this.tabChanged(e.item);
            }
        });
        this.fTabFolder = folder;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.php.help.adding_elements_to_a_project_s_include_path");
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return PHPUiPlugin.getActiveWorkbenchShell();
    }

    public void init(IProject phpProject, IIncludePathEntry[] includepathEntries) {
        this.fCurrProject = phpProject;
        this.phpOptions = PHPProjectOptions.forProject((IProject)this.fCurrProject);
        List newIncludePath = null;
        IProject project = this.fCurrProject.getProject();
        if (project.exists() && includepathEntries == null) {
            includepathEntries = this.phpOptions.readRawIncludePath();
        }
        if (includepathEntries != null) {
            newIncludePath = this.getExistingEntries(includepathEntries);
        }
        if (newIncludePath == null) {
            newIncludePath = this.getDefaultIncludePath(phpProject);
        }
        this.fIncludePathList.setElements(newIncludePath);
        this.initializeTimeStamps();
        this.updateUI();
    }

    protected void updateUI() {
        if (this.fSWTWidget == null || this.fSWTWidget.isDisposed()) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.doUpdateUI();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (IncludePathBlock.this.fSWTWidget == null || IncludePathBlock.this.fSWTWidget.isDisposed()) {
                        return;
                    }
                    IncludePathBlock.this.doUpdateUI();
                }
            });
        }
    }

    protected void doUpdateUI() {
        this.fIncludePathList.refresh();
        if (this.fProjectsPage != null) {
            this.fProjectsPage.init(this.fCurrProject);
            this.fLibrariesPage.init(this.fCurrProject);
        }
        this.doStatusLineUpdate();
    }

    private String getEncodedSettings() {
        StringBuffer buf = new StringBuffer();
        int nElements = this.fIncludePathList.getSize();
        buf.append('[').append(nElements).append(']');
        int i = 0;
        while (i < nElements) {
            IPListElement elem = (IPListElement)this.fIncludePathList.getElement(i);
            elem.appendEncodedSettings(buf);
            ++i;
        }
        return buf.toString();
    }

    public boolean hasChangesInDialog() {
        String currSettings = this.getEncodedSettings();
        return !currSettings.equals(this.fUserSettingsTimeStamp);
    }

    public void initializeTimeStamps() {
        this.fUserSettingsTimeStamp = this.getEncodedSettings();
    }

    private ArrayList getExistingEntries(IIncludePathEntry[] includepathEntries) {
        ArrayList<IPListElement> newIncludePath = new ArrayList<IPListElement>();
        int i = 0;
        while (i < includepathEntries.length) {
            IIncludePathEntry curr = includepathEntries[i];
            newIncludePath.add(IPListElement.createFromExisting(curr, this.fCurrProject));
            ++i;
        }
        return newIncludePath;
    }

    public IProject getProject() {
        return this.fCurrProject;
    }

    public IIncludePathEntry[] getRawIncludePath() {
        List elements = this.fIncludePathList.getElements();
        int nElements = elements.size();
        IIncludePathEntry[] entries = new IIncludePathEntry[elements.size()];
        int i = 0;
        while (i < nElements) {
            IPListElement currElement = (IPListElement)elements.get(i);
            entries[i] = currElement.getIncludePathEntry();
            ++i;
        }
        return entries;
    }

    public int getPageIndex() {
        return this.fPageIndex;
    }

    private List getDefaultIncludePath(IProject jproj) {
        ArrayList list = new ArrayList();
        return list;
    }

    private void includePathDialogFieldChanged(DialogField field) {
        if (field == this.fIncludePathList) {
            this.updateIncludePathStatus();
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        if (Display.getCurrent() != null) {
            StatusInfo res = this.fIncludePathStatus;
            this.fContext.statusChanged((IStatus)res);
        }
    }

    public void updateIncludePathStatus() {
        this.fIncludePathStatus.setOK();
        List elements = this.fIncludePathList.getElements();
        IPListElement entryMissing = null;
        int nEntriesMissing = 0;
        IIncludePathEntry[] entries = new IIncludePathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            IPListElement currElement = (IPListElement)elements.get(i);
            entries[i] = currElement.getIncludePathEntry();
            if (currElement.isMissing()) {
                ++nEntriesMissing;
                if (entryMissing == null) {
                    entryMissing = currElement;
                }
            }
            --i;
        }
        if (nEntriesMissing > 0) {
            if (nEntriesMissing == 1) {
                this.fIncludePathStatus.setWarning(MessageFormat.format(PHPUIMessages.getString("IncludePathsBlock_warning_EntryMissing"), entryMissing.getPath().toString()));
            } else {
                this.fIncludePathStatus.setWarning(MessageFormat.format(PHPUIMessages.getString("IncludePathsBlock_warning_EntriesMissing"), String.valueOf(nEntriesMissing)));
            }
        }
    }

    public static void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(PHPUIMessages.getString("IncludePathsBlock_operationdesc_project"), 10);
        try {
            if (!project.exists()) {
                IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
                if (Platform.getLocation().equals((Object)locationPath)) {
                    locationPath = null;
                }
                desc.setLocation(locationPath);
                project.create(desc, monitor);
                monitor = null;
            }
            if (!project.isOpen()) {
                project.open(monitor);
                monitor = null;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public static void addPHPNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!project.hasNature("org.eclipse.php.core.PHPNature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "org.eclipse.php.core.PHPNature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else {
            monitor.worked(1);
        }
    }

    public void configurePHPProject(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(PHPUIMessages.getString("IncludePathsBlock_operationdesc_php"));
        monitor.beginTask("", 10);
        try {
            this.internalConfigurePHPProject(this.fIncludePathList.getElements(), monitor);
        }
        finally {
            monitor.done();
        }
        this.updateUI();
    }

    public IIncludePathEntry[] getIncludepathEntries() {
        List includePathEntries = this.fIncludePathList.getElements();
        int nEntries = includePathEntries.size();
        IIncludePathEntry[] includepath = new IIncludePathEntry[nEntries];
        int i = 0;
        while (i < nEntries) {
            IPListElement entry = (IPListElement)includePathEntries.get(i);
            includepath[i] = entry.getIncludePathEntry();
            ++i;
        }
        return includepath;
    }

    private void internalConfigurePHPProject(List includePathEntries, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        monitor.worked(2);
        int nEntries = includePathEntries.size();
        IIncludePathEntry[] includepath = new IIncludePathEntry[nEntries];
        int i = 0;
        while (i < nEntries) {
            IPListElement entry = (IPListElement)includePathEntries.get(i);
            IResource res = entry.getResource();
            if (res instanceof IFolder && !res.exists()) {
                this.createFolder((IFolder)res, true, true, null);
            }
            includepath[i] = entry.getIncludePathEntry();
            ++i;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        monitor.worked(1);
        this.phpOptions.setRawIncludePath(includepath, new SubProgressMonitor(monitor, 7));
        this.initializeTimeStamps();
    }

    private void createFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                this.createFolder((IFolder)parent, force, local, null);
            }
            folder.create(force, local, monitor);
        }
    }

    public static boolean hasClassfiles(IResource resource) throws CoreException {
        if (resource.isDerived()) {
            return true;
        }
        if (resource instanceof IContainer) {
            IResource[] members = ((IContainer)resource).members();
            int i = 0;
            while (i < members.length) {
                if (IncludePathBlock.hasClassfiles(members[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void removeOldClassfiles(IResource resource) throws CoreException {
        if (resource.isDerived()) {
            resource.delete(false, null);
        } else if (resource instanceof IContainer) {
            IResource[] members = ((IContainer)resource).members();
            int i = 0;
            while (i < members.length) {
                IncludePathBlock.removeOldClassfiles(members[i]);
                ++i;
            }
        }
    }

    private void tabChanged(Widget widget) {
        if (widget instanceof TabItem) {
            List selection;
            TabItem tabItem = (TabItem)widget;
            IncludePathBasePage newPage = (IncludePathBasePage)tabItem.getData();
            if (this.fCurrPage != null && !(selection = this.fCurrPage.getSelection()).isEmpty()) {
                newPage.setSelection(selection, false);
            }
            this.fCurrPage = newPage;
            this.fPageIndex = tabItem.getParent().getSelectionIndex();
        }
    }

    private int getPageIndex(int entryKind) {
        switch (entryKind) {
            case 1: 
            case 4: 
            case 5: {
                return 1;
            }
            case 2: {
                return 0;
            }
        }
        return 0;
    }

    private IPListElement findElement(IIncludePathEntry entry) {
        int i = 0;
        int len = this.fIncludePathList.getSize();
        while (i < len) {
            IPListElement curr = (IPListElement)this.fIncludePathList.getElement(i);
            if (curr.getEntryKind() == entry.getEntryKind() && curr.getPath().equals((Object)entry.getPath())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public void setElementToReveal(IIncludePathEntry entry, String attributeKey) {
        int pageIndex = this.getPageIndex(entry.getEntryKind());
        if (this.fTabFolder == null) {
            this.fPageIndex = pageIndex;
        } else {
            this.fTabFolder.setSelection(pageIndex);
            IPListElement element = this.findElement(entry);
            if (element != null) {
                IPListElementAttribute attrib;
                Object elementToSelect = element;
                if (attributeKey != null && (attrib = element.findAttributeElement(attributeKey)) != null) {
                    elementToSelect = attrib;
                }
                IncludePathBasePage page = (IncludePathBasePage)this.fTabFolder.getItem(pageIndex).getData();
                ArrayList<Object> selection = new ArrayList<Object>(1);
                selection.add(elementToSelect);
                page.setSelection(selection, true);
            }
        }
    }

    public void dispose() {
        this.fLibrariesPage.dispose();
    }

    private class IncludePathAdapter
    implements IDialogFieldListener {
        private IncludePathAdapter() {
        }

        public void changeControlPressed(DialogField field) {
        }

        public void dialogFieldChanged(DialogField field) {
            IncludePathBlock.this.includePathDialogFieldChanged(field);
        }
    }
}

