/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.ui.preferences.includepath.IIncludePathContainerPage;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathContainerDefaultPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.osgi.framework.Bundle;

public class IncludePathContainerDescriptor {
    private IConfigurationElement fConfigElement;
    private IIncludePathContainerPage fPage;
    private static final String ATT_EXTENSION = "includepathContainerPage";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_PAGE_CLASS = "class";

    public IncludePathContainerDescriptor(IConfigurationElement configElement) throws CoreException {
        this.fConfigElement = configElement;
        this.fPage = null;
        String id = this.fConfigElement.getAttribute(ATT_ID);
        String name = configElement.getAttribute(ATT_NAME);
        String pageClassName = configElement.getAttribute(ATT_PAGE_CLASS);
        if (name == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Invalid extension (missing name): " + id, null));
        }
        if (pageClassName == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Invalid extension (missing page class name): " + id, null));
        }
    }

    public IIncludePathContainerPage createPage() throws CoreException {
        if (this.fPage == null) {
            Object elem = IncludePathContainerDescriptor.createExtension(this.fConfigElement, ATT_PAGE_CLASS);
            if (elem instanceof IIncludePathContainerPage) {
                this.fPage = (IIncludePathContainerPage)elem;
            } else {
                String id = this.fConfigElement.getAttribute(ATT_ID);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.php.ui", 0, "Invalid extension (page not of type IIncludePathContainerPage): " + id, null));
            }
        }
        return this.fPage;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        String pluginId = element.getNamespaceIdentifier();
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null && bundle.getState() == 32) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    public IIncludePathContainerPage getPage() {
        return this.fPage;
    }

    public void setPage(IIncludePathContainerPage page) {
        this.fPage = page;
    }

    public void dispose() {
        if (this.fPage != null) {
            this.fPage.dispose();
            this.fPage = null;
        }
    }

    public String getName() {
        return this.fConfigElement.getAttribute(ATT_NAME);
    }

    public String getPageClass() {
        return this.fConfigElement.getAttribute(ATT_PAGE_CLASS);
    }

    public boolean canEdit(IIncludePathEntry entry) {
        String id = this.fConfigElement.getAttribute(ATT_ID);
        if (entry.getEntryKind() == 5) {
            String type = entry.getPath().segment(0);
            return id.equals(type);
        }
        return false;
    }

    public static IncludePathContainerDescriptor[] getDescriptors() {
        ArrayList<IncludePathContainerDescriptor> containers = new ArrayList<IncludePathContainerDescriptor>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.php.ui", ATT_EXTENSION);
        if (extensionPoint != null) {
            IncludePathContainerDescriptor defaultPage = null;
            String defaultPageName = IncludePathContainerDefaultPage.class.getName();
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                try {
                    IncludePathContainerDescriptor curr = new IncludePathContainerDescriptor(elements[i]);
                    if (defaultPageName.equals(curr.getPageClass())) {
                        defaultPage = curr;
                    } else {
                        containers.add(curr);
                    }
                }
                catch (CoreException e) {
                    PHPCorePlugin.log((Throwable)e);
                }
                ++i;
            }
            if (defaultPageName != null && containers.isEmpty()) {
                containers.add(defaultPage);
            }
        }
        return containers.toArray(new IncludePathContainerDescriptor[containers.size()]);
    }
}

