/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathContainerDescriptor;
import org.eclipse.php.internal.ui.util.ListContentProvider;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class IncludePathContainerSelectionPage
extends WizardPage {
    private static final String DIALOGSTORE_SECTION = "IncludePathContainerSelectionPage";
    private static final String DIALOGSTORE_CONTAINER_IDX = "index";
    private ListViewer fListViewer;
    private IncludePathContainerDescriptor[] fContainers;
    private IDialogSettings fDialogSettings;

    protected IncludePathContainerSelectionPage(IncludePathContainerDescriptor[] containerPages) {
        super("IncludePathContainerWizardPage");
        this.setTitle(PHPUIMessages.getString("IncludePathContainerSelectionPage_title"));
        this.setDescription(PHPUIMessages.getString("IncludePathContainerSelectionPage_description"));
        this.setImageDescriptor(PHPPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fContainers = containerPages;
        IDialogSettings settings = PHPUiPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(DIALOGSTORE_SECTION);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(DIALOGSTORE_SECTION);
            this.fDialogSettings.put(DIALOGSTORE_CONTAINER_IDX, 0);
        }
        this.validatePage();
    }

    public void createControl(Composite parent) {
        this.fListViewer = new ListViewer(parent, 2052);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new IncludePathContainerLabelProvider());
        this.fListViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.fListViewer.setSorter((ViewerSorter)new IncludePathContainerSorter());
        this.fListViewer.setInput(Arrays.asList(this.fContainers));
        this.fListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IncludePathContainerSelectionPage.this.validatePage();
            }
        });
        this.fListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IncludePathContainerSelectionPage.this.doDoubleClick();
            }
        });
        int selectionIndex = this.fDialogSettings.getInt(DIALOGSTORE_CONTAINER_IDX);
        if (selectionIndex >= this.fContainers.length) {
            selectionIndex = 0;
        }
        this.fListViewer.getList().select(selectionIndex);
        this.validatePage();
        this.setControl((Control)this.fListViewer.getList());
        Dialog.applyDialogFont((Control)this.fListViewer.getList());
    }

    private void validatePage() {
        this.setPageComplete(this.getSelected() != null);
    }

    public IncludePathContainerDescriptor getSelected() {
        if (this.fListViewer != null) {
            ISelection selection = this.fListViewer.getSelection();
            return (IncludePathContainerDescriptor)IncludePathContainerSelectionPage.getSingleElement(selection);
        }
        return null;
    }

    public static Object getSingleElement(ISelection s) {
        if (!(s instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        if (selection.size() != 1) {
            return null;
        }
        return selection.getFirstElement();
    }

    public IncludePathContainerDescriptor[] getContainers() {
        return this.fContainers;
    }

    protected void doDoubleClick() {
        if (this.canFlipToNextPage()) {
            this.getContainer().showPage(this.getNextPage());
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void setVisible(boolean visible) {
        if (!visible && this.fListViewer != null) {
            this.fDialogSettings.put(DIALOGSTORE_CONTAINER_IDX, this.fListViewer.getList().getSelectionIndex());
        }
        super.setVisible(visible);
    }

    private static class IncludePathContainerLabelProvider
    extends LabelProvider {
        private IncludePathContainerLabelProvider() {
        }

        public String getText(Object element) {
            return ((IncludePathContainerDescriptor)element).getName();
        }
    }

    private static class IncludePathContainerSorter
    extends ViewerSorter {
        private IncludePathContainerSorter() {
        }
    }
}

