/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.includepath.IIncludePathContainerPage;
import org.eclipse.php.internal.ui.preferences.includepath.IIncludePathContainerPageExtension;
import org.eclipse.php.internal.ui.preferences.includepath.IIncludePathContainerPageExtension2;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathContainerDefaultPage;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathContainerDescriptor;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathContainerSelectionPage;
import org.eclipse.php.internal.ui.util.ExceptionHandler;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class IncludePathContainerWizard
extends Wizard {
    private IncludePathContainerDescriptor fPageDesc;
    private IIncludePathEntry fEntryToEdit;
    private IIncludePathEntry[] fNewEntries;
    private IIncludePathContainerPage fContainerPage;
    private IProject fCurrProject;
    private PHPProjectOptions fCurrOptions;
    private IIncludePathEntry[] fCurrIncludePath;
    private IncludePathContainerSelectionPage fSelectionWizardPage;

    public IncludePathContainerWizard(IIncludePathEntry entryToEdit, IProject currProject, IIncludePathEntry[] currEntries) {
        this(entryToEdit, null, currProject, currEntries);
    }

    public IncludePathContainerWizard(IncludePathContainerDescriptor pageDesc, IProject currProject, IIncludePathEntry[] currEntries) {
        this(null, pageDesc, currProject, currEntries);
    }

    private IncludePathContainerWizard(IIncludePathEntry entryToEdit, IncludePathContainerDescriptor pageDesc, IProject currProject, IIncludePathEntry[] currEntries) {
        this.fEntryToEdit = entryToEdit;
        this.fPageDesc = pageDesc;
        this.fNewEntries = null;
        this.fCurrProject = currProject;
        this.fCurrIncludePath = currEntries;
        String title = entryToEdit == null ? PHPUIMessages.getString("IncludePathContainerWizard_new_title") : PHPUIMessages.getString("IncludePathContainerWizard_edit_title");
        this.setWindowTitle(title);
    }

    public IIncludePathEntry getNewEntry() {
        IIncludePathEntry[] entries = this.getNewEntries();
        if (entries != null) {
            return entries[0];
        }
        return null;
    }

    public IIncludePathEntry[] getNewEntries() {
        return this.fNewEntries;
    }

    public boolean performFinish() {
        if (this.fContainerPage != null && this.fContainerPage.finish()) {
            if (this.fEntryToEdit == null && this.fContainerPage instanceof IIncludePathContainerPageExtension2) {
                this.fNewEntries = ((IIncludePathContainerPageExtension2)((Object)this.fContainerPage)).getNewContainers();
            } else {
                IIncludePathEntry[] iIncludePathEntryArray;
                IIncludePathEntry entry = this.fContainerPage.getSelection();
                if (entry != null) {
                    IIncludePathEntry[] iIncludePathEntryArray2 = new IIncludePathEntry[1];
                    iIncludePathEntryArray = iIncludePathEntryArray2;
                    iIncludePathEntryArray2[0] = entry;
                } else {
                    iIncludePathEntryArray = null;
                }
                this.fNewEntries = iIncludePathEntryArray;
            }
            return true;
        }
        return false;
    }

    public void addPages() {
        if (this.fPageDesc != null) {
            this.fContainerPage = this.getContainerPage(this.fPageDesc);
            this.addPage(this.fContainerPage);
        } else if (this.fEntryToEdit == null) {
            IncludePathContainerDescriptor[] containers = IncludePathContainerDescriptor.getDescriptors();
            this.fSelectionWizardPage = new IncludePathContainerSelectionPage(containers);
            this.addPage((IWizardPage)this.fSelectionWizardPage);
            this.fContainerPage = new IncludePathContainerDefaultPage();
            this.addPage(this.fContainerPage);
        } else {
            IncludePathContainerDescriptor[] containers = IncludePathContainerDescriptor.getDescriptors();
            IncludePathContainerDescriptor descriptor = this.findDescriptorPage(containers, this.fEntryToEdit);
            this.fContainerPage = this.getContainerPage(descriptor);
            this.addPage(this.fContainerPage);
        }
        super.addPages();
    }

    private IIncludePathContainerPage getContainerPage(IncludePathContainerDescriptor pageDesc) {
        IIncludePathContainerPage containerPage = null;
        if (pageDesc != null) {
            IIncludePathContainerPage page = pageDesc.getPage();
            if (page != null) {
                return page;
            }
            try {
                containerPage = pageDesc.createPage();
            }
            catch (CoreException e) {
                this.handlePageCreationFailed(e);
                containerPage = null;
            }
        }
        if (containerPage == null) {
            containerPage = new IncludePathContainerDefaultPage();
            if (pageDesc != null) {
                pageDesc.setPage(containerPage);
            }
        }
        if (containerPage instanceof IIncludePathContainerPageExtension) {
            ((IIncludePathContainerPageExtension)((Object)containerPage)).initialize(this.fCurrProject, this.fCurrIncludePath);
        }
        containerPage.setSelection(this.fEntryToEdit);
        containerPage.setWizard((IWizard)this);
        return containerPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.fSelectionWizardPage) {
            IncludePathContainerDescriptor selected = this.fSelectionWizardPage.getSelected();
            this.fContainerPage = this.getContainerPage(selected);
            return this.fContainerPage;
        }
        return super.getNextPage(page);
    }

    private void handlePageCreationFailed(CoreException e) {
        String title = PHPUIMessages.getString("IncludePathContainerWizard_pagecreationerror_title");
        String message = PHPUIMessages.getString("IncludePathContainerWizard_pagecreationerror_message");
        ExceptionHandler.handle(e, this.getShell(), title, message);
    }

    private IncludePathContainerDescriptor findDescriptorPage(IncludePathContainerDescriptor[] containers, IIncludePathEntry entry) {
        int i = 0;
        while (i < containers.length) {
            if (containers[i].canEdit(entry)) {
                return containers[i];
            }
            ++i;
        }
        return null;
    }

    public void dispose() {
        if (this.fSelectionWizardPage != null) {
            IncludePathContainerDescriptor[] descriptors = this.fSelectionWizardPage.getContainers();
            int i = 0;
            while (i < descriptors.length) {
                descriptors[i].dispose();
                ++i;
            }
        }
        super.dispose();
    }

    public boolean canFinish() {
        if (this.fSelectionWizardPage != null && !this.fContainerPage.isPageComplete()) {
            return false;
        }
        if (this.fContainerPage != null) {
            return this.fContainerPage.isPageComplete();
        }
        return false;
    }

    public static int openWizard(Shell shell, IncludePathContainerWizard wizard) {
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        PixelConverter converter = new PixelConverter((Control)shell);
        dialog.setMinimumPageSize(converter.convertWidthInCharsToPixels(70), converter.convertHeightInCharsToPixels(20));
        dialog.create();
        return dialog.open();
    }
}

