/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.includepath.EditVariableEntryDialog;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathContainerWizard;
import org.eclipse.php.internal.ui.preferences.includepath.MultipleFolderSelectionDialog;
import org.eclipse.php.internal.ui.preferences.includepath.NewVariableEntryDialog;
import org.eclipse.php.internal.ui.util.TypedViewerFilter;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public final class IncludePathDialogAccess {
    public static final String DIALOGSTORE_LASTVARIABLE = "org.eclipse.php.ui.lastvariable";
    public static final String DIALOGSTORE_LASTINCLUDEFOLDER = "org.eclipse.php.ui.lastincludefolder";

    private IncludePathDialogAccess() {
    }

    public static IPath configureVariableEntry(Shell shell, IPath initialEntryPath, IPath[] existingPaths) {
        if (existingPaths == null) {
            throw new IllegalArgumentException();
        }
        EditVariableEntryDialog dialog = new EditVariableEntryDialog(shell, initialEntryPath, existingPaths);
        if (dialog.open() == 0) {
            return dialog.getPath();
        }
        return null;
    }

    public static IPath[] chooseVariableEntries(Shell shell, IPath[] existingPaths) {
        if (existingPaths == null) {
            throw new IllegalArgumentException();
        }
        NewVariableEntryDialog dialog = new NewVariableEntryDialog(shell);
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    public static IIncludePathEntry configureContainerEntry(Shell shell, IIncludePathEntry initialEntry, IProject project, IIncludePathEntry[] currentIncludePath) {
        IIncludePathEntry[] created;
        if (initialEntry == null || currentIncludePath == null) {
            throw new IllegalArgumentException();
        }
        IncludePathContainerWizard wizard = new IncludePathContainerWizard(initialEntry, project, currentIncludePath);
        if (IncludePathContainerWizard.openWizard(shell, wizard) == 0 && (created = wizard.getNewEntries()) != null && created.length == 1) {
            return created[0];
        }
        return null;
    }

    public static IIncludePathEntry[] chooseContainerEntries(Shell shell, IProject project, IIncludePathEntry[] currentIncludePath) {
        if (currentIncludePath == null) {
            throw new IllegalArgumentException();
        }
        IncludePathContainerWizard wizard = new IncludePathContainerWizard(null, project, currentIncludePath);
        if (IncludePathContainerWizard.openWizard(shell, wizard) == 0) {
            return wizard.getNewEntries();
        }
        return null;
    }

    public static IPath[] chooseIncludePathFoldersEntries(Shell shell) {
        String lastUsedPath = PHPUiPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LASTINCLUDEFOLDER);
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        DirectoryDialog dialog = new DirectoryDialog(shell, 4);
        dialog.setText(PHPUIMessages.getString("IncludePathDialogAccess_IncludePathFolderDialog_new_title"));
        dialog.setMessage(PHPUIMessages.getString("IncludePathDialogAccess_IncludePathFolderDialog_new_description"));
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        IPath path = new Path(res).makeAbsolute();
        PHPUiPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LASTINCLUDEFOLDER, path.removeLastSegments(1).toOSString());
        return new IPath[]{path};
    }

    public static IPath configureIncludePathFolderEntry(Shell shell, IPath initialEntry) {
        if (initialEntry == null) {
            throw new IllegalArgumentException();
        }
        String lastUsedPath = initialEntry.removeLastSegments(1).toOSString();
        DirectoryDialog dialog = new DirectoryDialog(shell, 4);
        dialog.setText(PHPUIMessages.getString("IncludePathDialogAccess_0"));
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        IPath path = new Path(res).makeAbsolute();
        PHPUiPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LASTINCLUDEFOLDER, path.removeLastSegments(1).toOSString());
        return path;
    }

    public static IPath[] chooseFolderEntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        String title = PHPUIMessages.getString("IncludePathDialogAccess_ExistingPHPFolderDialog_new_title");
        String message = PHPUIMessages.getString("IncludePathDialogAccess_ExistingPHPFolderDialog_new_description");
        return IncludePathDialogAccess.internalChooseFolderEntry(shell, initialSelection, usedEntries, title, message);
    }

    public static IPath[] chooseSourceFolderEntries(Shell shell, IPath initialSelection, IPath[] usedEntries) {
        if (usedEntries == null) {
            throw new IllegalArgumentException();
        }
        String title = PHPUIMessages.getString("IncludePathDialogAccess_ExistingSourceFolderDialog_new_title");
        String message = PHPUIMessages.getString("IncludePathDialogAccess_ExistingSourceFolderDialog_new_description");
        return IncludePathDialogAccess.internalChooseFolderEntry(shell, initialSelection, usedEntries, title, message);
    }

    private static IPath[] internalChooseFolderEntry(Shell shell, IPath initialSelection, IPath[] usedEntries, String title, String message) {
        Class[] acceptedClasses = new Class[]{IProject.class, IFolder.class};
        ArrayList<IResource> usedContainers = new ArrayList<IResource>(usedEntries.length);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < usedEntries.length) {
            IResource resource = root.findMember(usedEntries[i]);
            if (resource instanceof IContainer) {
                usedContainers.add(resource);
            }
            ++i;
        }
        IResource focus = initialSelection != null ? root.findMember(initialSelection) : null;
        Object[] used = usedContainers.toArray();
        MultipleFolderSelectionDialog dialog = new MultipleFolderSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setExisting(used);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter(new TypedViewerFilter(acceptedClasses, used));
        dialog.setInput(root);
        dialog.setInitialFocus(focus);
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            IPath[] res = new IPath[elements.length];
            int i2 = 0;
            while (i2 < res.length) {
                IResource elem = (IResource)elements[i2];
                res[i2] = elem.getFullPath();
                ++i2;
            }
            return res;
        }
        return null;
    }
}

