/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathBlock;
import org.eclipse.php.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class IncludePathPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    public static final String PROP_ID = "org.eclipse.php.ui.propertyPages.IncludePathPropertyPage";
    private static final String PAGE_SETTINGS = "IncludePathPropertyPage";
    private static final String INDEX = "pageIndex";
    public static final Object DATA_REVEAL_ENTRY = "select_includepath_entry";
    public static final Object DATA_REVEAL_ATTRIBUTE_KEY = "select_includepath_attribute_key";
    private IncludePathBlock fIncludePathsBlock;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        IProject project = this.getProject();
        Control result = project == null || !this.isPHPProject(project) ? this.createWithoutPHP(parent) : (!project.isOpen() ? this.createForClosedProject(parent) : this.createWithPHP(parent, project));
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.adding_elements_to_a_project_s_include_path");
        return result;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.php.help.adding_elements_to_a_project_s_include_path");
    }

    private IDialogSettings getSettings() {
        IDialogSettings phpSettings = PHPUiPlugin.getDefault().getDialogSettings();
        IDialogSettings pageSettings = phpSettings.getSection(PAGE_SETTINGS);
        if (pageSettings == null) {
            pageSettings = phpSettings.addNewSection(PAGE_SETTINGS);
            pageSettings.put(INDEX, 0);
        }
        return pageSettings;
    }

    public void setVisible(boolean visible) {
        if (this.fIncludePathsBlock != null && !visible && this.fIncludePathsBlock.hasChangesInDialog()) {
            String title = PHPUIMessages.getString("IncludePathsPropertyPage_unsavedchanges_title");
            String message = PHPUIMessages.getString("IncludePathsPropertyPage_unsavedchanges_message");
            String[] buttonLabels = new String[]{PHPUIMessages.getString("IncludePathsPropertyPage_unsavedchanges_button_save"), PHPUIMessages.getString("IncludePathsPropertyPage_unsavedchanges_button_discard"), PHPUIMessages.getString("IncludePathsPropertyPage_unsavedchanges_button_ignore")};
            MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, buttonLabels, 0);
            int res = dialog.open();
            if (res == 0) {
                this.performOk();
            } else if (res == 1) {
                this.fIncludePathsBlock.init(this.getProject(), null);
            }
        }
        super.setVisible(visible);
    }

    private Control createWithPHP(Composite parent, IProject project) {
        IWorkbenchPreferenceContainer pageContainer = null;
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof IWorkbenchPreferenceContainer) {
            pageContainer = (IWorkbenchPreferenceContainer)container;
        }
        this.fIncludePathsBlock = new IncludePathBlock(new BusyIndicatorRunnableContext(), this, this.getSettings().getInt(INDEX), false, pageContainer);
        this.fIncludePathsBlock.init(project, null);
        return this.fIncludePathsBlock.createControl(parent);
    }

    private Control createWithoutPHP(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PHPUIMessages.getString("IncludePathsPropertyPage_no_php_project_message"));
        this.fIncludePathsBlock = null;
        this.setValid(true);
        return label;
    }

    private Control createForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PHPUIMessages.getString("IncludePathsPropertyPage_closed_project_message"));
        this.fIncludePathsBlock = null;
        this.setValid(true);
        return label;
    }

    private IProject getProject() {
        IAdaptable adaptable = this.getElement();
        if (adaptable != null && adaptable instanceof IProject) {
            return (IProject)adaptable;
        }
        return null;
    }

    private boolean isPHPProject(IProject proj) {
        try {
            return proj.hasNature("org.eclipse.php.core.PHPNature");
        }
        catch (CoreException e) {
            PHPCorePlugin.log((Throwable)e);
            return false;
        }
    }

    public boolean performOk() {
        if (this.fIncludePathsBlock != null) {
            this.getSettings().put(INDEX, this.fIncludePathsBlock.getPageIndex());
            if (this.fIncludePathsBlock.hasChangesInDialog()) {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                        IncludePathPropertyPage.this.fIncludePathsBlock.configurePHPProject(monitor);
                    }
                };
                WorkbenchRunnableAdapter op = new WorkbenchRunnableAdapter(runnable);
                op.runAsUserJob(PHPUIMessages.getString("IncludePathsPropertyPage_job_title"), null);
            }
        }
        return true;
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        IncludePathPropertyPage.applyToStatusLine((DialogPage)this, status);
    }

    public static void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    public void applyData(Object data) {
        Map map;
        Object selectedLibrary;
        if (data instanceof Map && (selectedLibrary = (map = (Map)data).get(DATA_REVEAL_ENTRY)) instanceof IIncludePathEntry) {
            String attributeKey;
            IIncludePathEntry entry = (IIncludePathEntry)selectedLibrary;
            Object attr = map.get(DATA_REVEAL_ATTRIBUTE_KEY);
            String string = attributeKey = attr instanceof String ? (String)attr : null;
            if (this.fIncludePathsBlock != null) {
                this.fIncludePathsBlock.setElementToReveal(entry, attributeKey);
            }
        }
    }

    public void dispose() {
        this.fIncludePathsBlock.dispose();
    }
}

