/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariablesListener;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.php.internal.ui.preferences.includepath.IPListElement;
import org.eclipse.php.internal.ui.preferences.includepath.IPListElementAttribute;
import org.eclipse.php.internal.ui.preferences.includepath.IPListElementSorter;
import org.eclipse.php.internal.ui.preferences.includepath.IPListLabelProvider;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathBasePage;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathDialogAccess;
import org.eclipse.php.internal.ui.preferences.includepath.NewContainerDialog;
import org.eclipse.php.internal.ui.util.ExceptionHandler;
import org.eclipse.php.internal.ui.util.PixelConverter;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.ITreeListAdapter;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.ListDialogField;
import org.eclipse.php.internal.ui.wizards.fields.TreeListDialogField;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class LibrariesWorkbookPage
extends IncludePathBasePage
implements IncludePathVariablesListener {
    private ListDialogField fIncludePathList;
    private IProject fCurrJProject;
    private TreeListDialogField fLibrariesList;
    private Control fSWTControl;
    private final IWorkbenchPreferenceContainer fPageContainer;
    private final int IDX_ADDVAR = 0;
    private final int IDX_ADDFOL = 1;
    private final int IDX_EDIT = 2;
    private final int IDX_REMOVE = 3;
    private int currentActionIdx = -1;

    public LibrariesWorkbookPage(ListDialogField includePathList, IWorkbenchPreferenceContainer pageContainer) {
        this.fIncludePathList = includePathList;
        this.fPageContainer = pageContainer;
        this.fSWTControl = null;
        String[] buttonLabels = new String[]{PHPUIMessages.getString("LibrariesWorkbookPage_libraries_addvariable_button"), PHPUIMessages.getString("LibrariesWorkbookPage_libraries_addincludepathfolder_button"), PHPUIMessages.getString("LibrariesWorkbookPage_libraries_edit_button"), PHPUIMessages.getString("LibrariesWorkbookPage_libraries_remove_button")};
        LibrariesAdapter adapter = new LibrariesAdapter();
        this.fLibrariesList = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new IPListLabelProvider());
        this.fLibrariesList.setDialogFieldListener(adapter);
        this.fLibrariesList.setLabelText(PHPUIMessages.getString("LibrariesWorkbookPage_libraries_label"));
        this.fLibrariesList.enableButton(3, false);
        this.fLibrariesList.enableButton(2, false);
        this.fLibrariesList.setViewerSorter(new IPListElementSorter());
        IncludePathVariableManager.instance().addListener((IncludePathVariablesListener)this);
    }

    public void init(IProject jproject) {
        this.fCurrJProject = jproject;
        this.updateLibrariesList();
    }

    private void updateLibrariesList() {
        List cpelements = this.fIncludePathList.getElements();
        ArrayList<IPListElement> libelements = new ArrayList<IPListElement>(cpelements.size());
        int nElements = cpelements.size();
        int i = 0;
        while (i < nElements) {
            IPListElement cpe = (IPListElement)cpelements.get(i);
            if (this.isEntryKind(cpe.getEntryKind())) {
                libelements.add(cpe);
            }
            ++i;
        }
        this.fLibrariesList.setElements(libelements);
    }

    public Control getControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibrariesList}, true, -1, -1);
        LayoutUtil.setHorizontalGrabbing(this.fLibrariesList.getTreeControl(null));
        int buttonBarWidth = converter.convertWidthInCharsToPixels(24);
        this.fLibrariesList.setButtonsMinWidth(buttonBarWidth);
        this.fLibrariesList.getTreeViewer().setSorter((ViewerSorter)new IPListElementSorter());
        this.fSWTControl = composite;
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTControl != null) {
            return this.fSWTControl.getShell();
        }
        return PHPUiPlugin.getActiveWorkbenchShell();
    }

    private void libaryPageCustomButtonPressed(DialogField field, int index) {
        Object[] libentries = null;
        switch (index) {
            case 0: {
                this.currentActionIdx = 0;
                libentries = this.openVariableSelectionDialog(null);
                break;
            }
            case 1: {
                this.currentActionIdx = 1;
                libentries = this.openIncludeFolderDialog(null);
                break;
            }
            case 2: {
                this.currentActionIdx = 2;
                this.editEntry();
                return;
            }
            case 3: {
                this.currentActionIdx = 3;
                this.removeEntry();
                return;
            }
        }
        if (libentries != null) {
            int nElementsChosen = libentries.length;
            List cplist = this.fLibrariesList.getElements();
            ArrayList<IPListElement> elementsToAdd = new ArrayList<IPListElement>(nElementsChosen);
            int i = 0;
            while (i < nElementsChosen) {
                IPListElement curr = libentries[i];
                if (!cplist.contains(curr) && !elementsToAdd.contains(curr)) {
                    elementsToAdd.add(curr);
                }
                ++i;
            }
            if (!elementsToAdd.isEmpty() && index == 1) {
                this.askForAddingExclusionPatternsDialog(elementsToAdd);
            }
            this.fLibrariesList.addElements(elementsToAdd);
            this.fLibrariesList.postSetSelection((ISelection)new StructuredSelection(libentries));
        }
    }

    private void askForAddingExclusionPatternsDialog(List newEntries) {
        HashSet modified = new HashSet();
        LibrariesWorkbookPage.fixNestingConflicts(newEntries, this.fIncludePathList.getElements(), modified);
        if (!modified.isEmpty()) {
            String title = PHPUIMessages.getString("LibrariesWorkbookPage_exclusion_added_title");
            String message = PHPUIMessages.getString("LibrariesWorkbookPage_exclusion_added_message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    protected void libaryPageDoubleClicked(TreeListDialogField field) {
        List selection = this.fLibrariesList.getSelectedElements();
        if (this.canEdit(selection)) {
            this.editEntry();
        }
    }

    protected void libaryPageKeyPressed(TreeListDialogField field, KeyEvent event) {
        List selection;
        if (field == this.fLibrariesList && event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.removeEntry();
        }
    }

    private void removeEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        HashSet<IPListElement> containerEntriesToUpdate = new HashSet<IPListElement>();
        int i = selElements.size() - 1;
        while (i >= 0) {
            Object elem = selElements.get(i);
            if (elem instanceof IPListElementAttribute) {
                IPListElementAttribute attrib = (IPListElementAttribute)elem;
                String key = attrib.getKey();
                Object value = null;
                attrib.getParent().setAttribute(key, value);
                selElements.remove(i);
                if (attrib.getParent().getParentContainer() instanceof IPListElement) {
                    containerEntriesToUpdate.add(attrib.getParent());
                }
            }
            --i;
        }
        if (selElements.isEmpty()) {
            this.fLibrariesList.refresh();
            this.fIncludePathList.dialogFieldChanged();
        } else {
            this.fLibrariesList.removeElements(selElements);
        }
        for (IPListElement curr : containerEntriesToUpdate) {
            IIncludePathEntry updatedEntry = curr.getIncludePathEntry();
            this.updateContainerEntry(updatedEntry, this.fCurrJProject, ((IPListElement)curr.getParentContainer()).getPath());
        }
    }

    private boolean canRemove(List selElements) {
        if (selElements.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < selElements.size()) {
            Object elem = selElements.get(i);
            if (elem instanceof IPListElementAttribute) {
                IPListElementAttribute attrib = (IPListElementAttribute)elem;
                if (attrib.isInNonModifiableContainer()) {
                    return false;
                }
                if (attrib.getValue() == null) {
                    return false;
                }
            } else if (elem instanceof IPListElement) {
                IPListElement curr = (IPListElement)elem;
                if (curr.getParentContainer() != null) {
                    return false;
                }
            } else {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void editEntry() {
        List selElements = this.fLibrariesList.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        Object elem = selElements.get(0);
        if (this.fLibrariesList.getIndexOfElement(elem) != -1) {
            this.editElementEntry((IPListElement)elem);
        } else if (elem instanceof IPListElementAttribute) {
            this.editAttributeEntry((IPListElementAttribute)elem);
        }
    }

    private void editAttributeEntry(IPListElementAttribute elem) {
        elem.getKey();
        elem.getParent();
    }

    private void attributeUpdated(IPListElement selElement) {
        Object parentContainer = selElement.getParentContainer();
        if (parentContainer instanceof IPListElement) {
            IIncludePathEntry updatedEntry = selElement.getIncludePathEntry();
            this.updateContainerEntry(updatedEntry, this.fCurrJProject, ((IPListElement)parentContainer).getPath());
        }
    }

    private void updateContainerEntry(final IIncludePathEntry newEntry, final IProject project, final IPath containerPath) {
        try {
            IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    PHPProjectOptions options = PHPProjectOptions.forProject((IProject)project);
                    options.modifyIncludePathEntry(newEntry, project, containerPath, monitor);
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(runnable));
        }
        catch (InvocationTargetException e) {
            String title = PHPUIMessages.getString("LibrariesWorkbookPage_configurecontainer_error_title");
            String message = PHPUIMessages.getString("LibrariesWorkbookPage_configurecontainer_error_message");
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void editElementEntry(IPListElement elem) {
        IPListElement[] res = null;
        switch (elem.getEntryKind()) {
            case 5: {
                res = this.openContainerSelectionDialog(elem);
                break;
            }
            case 1: {
                IResource resource = elem.getResource();
                if (resource == null) {
                    res = this.openIncludeFolderDialog(elem);
                    break;
                }
                if (resource.getType() != 2) break;
                if (resource.exists()) {
                    res = this.openFolderDialog(elem);
                    break;
                }
                res = this.openNewFolderDialog(elem);
                break;
            }
            case 4: {
                res = this.openVariableSelectionDialog(elem);
            }
        }
        if (res != null && res.length > 0) {
            IPListElement curr = res[0];
            curr.setExported(elem.isExported());
            this.fLibrariesList.replaceElement(elem, curr);
        }
    }

    private void libaryPageSelectionChanged(DialogField field) {
        List selElements = this.fLibrariesList.getSelectedElements();
        this.fLibrariesList.enableButton(2, this.canEdit(selElements));
        this.fLibrariesList.enableButton(3, this.canRemove(selElements));
        boolean noAttributes = this.containsOnlyTopLevelEntries(selElements);
        this.fLibrariesList.enableButton(1, noAttributes);
        this.fLibrariesList.enableButton(0, noAttributes);
    }

    private boolean canEdit(List selElements) {
        if (selElements.size() != 1) {
            return false;
        }
        Object elem = selElements.get(0);
        if (elem instanceof IPListElement) {
            IPListElement curr = (IPListElement)elem;
            return !(curr.getResource() instanceof IFolder) && curr.getParentContainer() == null;
        }
        if (elem instanceof IPListElementAttribute) {
            IPListElementAttribute attrib = (IPListElementAttribute)elem;
            return !attrib.isInNonModifiableContainer();
        }
        return false;
    }

    private void libaryPageDialogFieldChanged(DialogField field) {
        if (this.fCurrJProject != null) {
            this.updateIncludePathList();
        }
    }

    private void updateIncludePathList() {
        int nEntries;
        List projelements = this.fLibrariesList.getElements();
        List cpelements = this.fIncludePathList.getElements();
        int lastRemovePos = nEntries = cpelements.size();
        int i = nEntries - 1;
        while (i >= 0) {
            IPListElement cpe = (IPListElement)cpelements.get(i);
            int kind = cpe.getEntryKind();
            if (this.isEntryKind(kind) && !projelements.remove(cpe)) {
                cpelements.remove(i);
                lastRemovePos = i;
            }
            --i;
        }
        cpelements.addAll(lastRemovePos, projelements);
        if (lastRemovePos != nEntries || !projelements.isEmpty()) {
            this.fIncludePathList.setElements(cpelements);
        }
    }

    private IPListElement[] openNewFolderDialog(IPListElement existing) {
        String title = existing == null ? PHPUIMessages.getString("LibrariesWorkbookPage_NewIncludePathDialog_new_title") : PHPUIMessages.getString("LibrariesWorkbookPage_NewIncludePathDialog_edit_title");
        IProject currProject = this.fCurrJProject.getProject();
        NewContainerDialog dialog = new NewContainerDialog(this.getShell(), title, currProject, this.getUsedContainers(existing), existing);
        IPath projpath = currProject.getFullPath();
        dialog.setMessage(MessageFormat.format(PHPUIMessages.getString("LibrariesWorkbookPage_NewIncludePathDialog_description"), projpath.toString()));
        if (dialog.open() == 0) {
            IFolder folder = dialog.getFolder();
            return new IPListElement[]{this.newCPLibraryElement((IResource)folder)};
        }
        return null;
    }

    private IPListElement[] openFolderDialog(IPListElement existing) {
        IPath[] selected;
        if (existing == null && (selected = IncludePathDialogAccess.chooseFolderEntries(this.getShell(), this.fCurrJProject.getLocation(), this.getUsedContainers(existing))) != null) {
            IWorkspaceRoot root = this.fCurrJProject.getProject().getWorkspace().getRoot();
            ArrayList<IPListElement> res = new ArrayList<IPListElement>();
            int i = 0;
            while (i < selected.length) {
                IPath curr = selected[i];
                IResource resource = root.findMember(curr);
                if (resource instanceof IContainer) {
                    res.add(this.newCPLibraryElement(resource));
                }
                ++i;
            }
            return res.toArray(new IPListElement[res.size()]);
        }
        return null;
    }

    private IPListElement[] openIncludeFolderDialog(IPListElement existing) {
        if (existing == null) {
            IPath[] selected = IncludePathDialogAccess.chooseIncludePathFoldersEntries(this.getShell());
            if (selected != null) {
                ArrayList<IPListElement> res = new ArrayList<IPListElement>();
                int i = 0;
                while (i < selected.length) {
                    res.add(new IPListElement(this.fCurrJProject, 1, 1, selected[i], null));
                    ++i;
                }
                return res.toArray(new IPListElement[res.size()]);
            }
        } else {
            IPath configured = IncludePathDialogAccess.configureIncludePathFolderEntry(this.getShell(), existing.getPath());
            if (configured != null) {
                IPListElement elem = new IPListElement(this.fCurrJProject, 1, 1, configured, null);
                return new IPListElement[]{elem};
            }
        }
        return null;
    }

    private IPath[] getUsedContainers(IPListElement existing) {
        ArrayList<IPath> res = new ArrayList<IPath>();
        List cplist = this.fLibrariesList.getElements();
        int i = 0;
        while (i < cplist.size()) {
            IResource resource;
            IPListElement elem = (IPListElement)cplist.get(i);
            if (elem.getEntryKind() == 1 && elem != existing && (resource = elem.getResource()) instanceof IContainer && !resource.equals((Object)existing)) {
                res.add(resource.getFullPath());
            }
            ++i;
        }
        return res.toArray(new IPath[res.size()]);
    }

    private IPListElement newCPLibraryElement(IResource res) {
        return new IPListElement(this.fCurrJProject, 1, 2, res.getFullPath(), res);
    }

    private IPListElement[] openVariableSelectionDialog(IPListElement existing) {
        List existingElements = this.fLibrariesList.getElements();
        ArrayList<IPath> existingPaths = new ArrayList<IPath>(existingElements.size());
        int i = 0;
        while (i < existingElements.size()) {
            IPListElement elem = (IPListElement)existingElements.get(i);
            if (elem.getEntryKind() == 4) {
                existingPaths.add(elem.getPath());
            }
            ++i;
        }
        IPath[] existingPathsArray = existingPaths.toArray(new IPath[existingPaths.size()]);
        if (existing == null) {
            IPath[] paths = IncludePathDialogAccess.chooseVariableEntries(this.getShell(), existingPathsArray);
            if (paths != null) {
                ArrayList<IPListElement> result = new ArrayList<IPListElement>();
                int i2 = 0;
                while (i2 < paths.length) {
                    IPListElement elem = new IPListElement(this.fCurrJProject, 4, 1, paths[i2], null);
                    IPath resolvedPath = PHPProjectOptions.getResolvedVariablePath((IPath)paths[i2]);
                    elem.setIsMissing(resolvedPath == null || !resolvedPath.toFile().exists());
                    if (!existingElements.contains(elem)) {
                        result.add(elem);
                    }
                    ++i2;
                }
                return result.toArray(new IPListElement[result.size()]);
            }
        } else {
            IPath path = IncludePathDialogAccess.configureVariableEntry(this.getShell(), existing.getPath(), existingPathsArray);
            if (path != null) {
                IPListElement elem = new IPListElement(this.fCurrJProject, 4, 1, path, null);
                return new IPListElement[]{elem};
            }
        }
        return null;
    }

    private IPListElement[] openContainerSelectionDialog(IPListElement existing) {
        if (existing == null) {
            IIncludePathEntry[] created = IncludePathDialogAccess.chooseContainerEntries(this.getShell(), this.fCurrJProject, this.getRawIncludePath());
            if (created != null) {
                IPListElement[] res = new IPListElement[created.length];
                int i = 0;
                while (i < res.length) {
                    res[i] = new IPListElement(this.fCurrJProject, 5, 1, created[i].getPath(), null);
                    ++i;
                }
                return res;
            }
        } else {
            IIncludePathEntry created = IncludePathDialogAccess.configureContainerEntry(this.getShell(), existing.getIncludePathEntry(), this.fCurrJProject, this.getRawIncludePath());
            if (created != null) {
                IPListElement elem = new IPListElement(this.fCurrJProject, 5, 1, created.getPath(), null);
                return new IPListElement[]{elem};
            }
        }
        return null;
    }

    private IIncludePathEntry[] getRawIncludePath() {
        IIncludePathEntry[] currEntries = new IIncludePathEntry[this.fIncludePathList.getSize()];
        int i = 0;
        while (i < currEntries.length) {
            IPListElement curr = (IPListElement)this.fIncludePathList.getElement(i);
            currEntries[i] = curr.getIncludePathEntry();
            ++i;
        }
        return currEntries;
    }

    public boolean isEntryKind(int kind) {
        return kind == 1 || kind == 4 || kind == 5;
    }

    public List getSelection() {
        return this.fLibrariesList.getSelectedElements();
    }

    public void setSelection(List selElements, boolean expand) {
        this.fLibrariesList.selectElements((ISelection)new StructuredSelection(selElements));
        if (expand) {
            int i = 0;
            while (i < selElements.size()) {
                this.fLibrariesList.expandElement(selElements.get(i), 1);
                ++i;
            }
        }
    }

    public void includePathVariablesChanged(String[] names, IPath[] paths) {
        ArrayList namesList = new ArrayList(Arrays.asList(names));
        ArrayList pathsList = new ArrayList(Arrays.asList(paths));
        ArrayList<IPListElement> elementsToRemove = new ArrayList<IPListElement>(0);
        for (IPListElement element : this.fLibrariesList.getElements()) {
            String name;
            if (element.getEntryKind() != 4 || namesList.contains(name = element.getPath().toString()) && pathsList.get(namesList.indexOf(name)) != null) continue;
            elementsToRemove.add(element);
        }
        if (this.currentActionIdx != 2) {
            final Object[] elementsToRemoveArray = elementsToRemove.toArray();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < elementsToRemoveArray.length) {
                        LibrariesWorkbookPage.this.fLibrariesList.removeElement(elementsToRemoveArray[i]);
                        ++i;
                    }
                }
            });
        }
    }

    public void dispose() {
        IncludePathVariableManager.instance().removeListener((IncludePathVariablesListener)this);
    }

    private class LibrariesAdapter
    implements IDialogFieldListener,
    ITreeListAdapter {
        private final Object[] EMPTY_ARR = new Object[0];

        private LibrariesAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            LibrariesWorkbookPage.this.libaryPageCustomButtonPressed(field, index);
        }

        public void selectionChanged(TreeListDialogField field) {
            LibrariesWorkbookPage.this.libaryPageSelectionChanged(field);
        }

        public void doubleClicked(TreeListDialogField field) {
            LibrariesWorkbookPage.this.libaryPageDoubleClicked(field);
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
            LibrariesWorkbookPage.this.libaryPageKeyPressed(field, event);
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element instanceof IPListElement) {
                return ((IPListElement)element).getChildren(false);
            }
            if (element instanceof IPListElementAttribute) {
                IPListElementAttribute cfr_ignored_0 = (IPListElementAttribute)element;
            }
            return this.EMPTY_ARR;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof IPListElementAttribute) {
                return ((IPListElementAttribute)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return this.getChildren(field, element).length > 0;
        }

        public void dialogFieldChanged(DialogField field) {
            LibrariesWorkbookPage.this.libaryPageDialogFieldChanged(field);
        }
    }
}

