/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.projectOutline;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.OpenAction;
import org.eclipse.php.internal.ui.editor.LinkingSelectionListener;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.explorer.IMultiElementTreeContentProvider;
import org.eclipse.php.internal.ui.explorer.PHPTreeViewer;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.projectOutline.ProjectOutlineContentProvider;
import org.eclipse.php.internal.ui.projectOutline.ProjectOutlineLabelProvider;
import org.eclipse.php.internal.ui.projectOutline.ProjectOutlineViewGroup;
import org.eclipse.php.internal.ui.treecontent.TreeProvider;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.internal.ui.util.MultiElementSelection;
import org.eclipse.php.internal.ui.util.PHPElementLabels;
import org.eclipse.php.internal.ui.util.PHPElementSorter;
import org.eclipse.php.internal.ui.util.PHPOutlineElementComparer;
import org.eclipse.php.internal.ui.util.StatusBarUpdater;
import org.eclipse.php.internal.ui.util.TreePath;
import org.eclipse.php.ui.treecontent.IPHPTreeContentProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ViewPart;

public class ProjectOutlinePart
extends ViewPart
implements IMenuListener,
FocusListener {
    final String MEMENTO_KEY_PROJECT = "ProjectOutlinePart.storedProjectName";
    protected ProjectOutlineViewGroup actionGroup;
    protected IProject currentProject;
    private String initProjectName;
    protected ProjectOutlineContentProvider fContentProvider;
    private Menu fContextMenu;
    protected ProjectOutlineLabelProvider fLabelProvider;
    private ISelection fLastOpenSelection;
    private boolean fLinkingEnabled;
    private final IPartListener fPartListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part == ProjectOutlinePart.this) {
                return;
            }
            PHPStructuredEditor structuredEditor = EditorUtility.getPHPStructuredEditor(part);
            if (ProjectOutlinePart.this.getViewer().getTree().getVisible() && structuredEditor != null) {
                ProjectOutlinePart.this.updateInputForCurrentEditor((IEditorPart)structuredEditor);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            PHPStructuredEditor structuredEditor = EditorUtility.getPHPStructuredEditor(part);
            if (ProjectOutlinePart.this.getViewer().getTree().getVisible() && structuredEditor != null) {
                ProjectOutlinePart.this.updateInputForCurrentEditor((IEditorPart)structuredEditor);
            }
        }
    };
    private ISelectionChangedListener fPostSelectionListener;
    private final LinkingSelectionListener fSelectionListener = new LinkingSelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            Object firstElement;
            IStructuredSelection structuredSelection;
            if (part instanceof IEditorPart) {
                ProjectOutlinePart.this.handleUpdateInput((IEditorPart)part);
            }
            if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() > 0 && (firstElement = structuredSelection.getFirstElement()) instanceof IProject) {
                ProjectOutlinePart.this.setProject((IProject)firstElement);
                return;
            }
            super.selectionChanged(part, selection);
        }
    };
    protected PHPTreeViewer fViewer;
    private String fWorkingSetName;
    OpenAction openEditorAction;
    private boolean showAll = false;
    private UpdateViewJob updateViewJob;

    public void focusGained(FocusEvent e) {
        ((ProjectOutlineContentProvider)this.fViewer.getContentProvider()).postRefresh(this.fViewer.getInput(), true);
    }

    public void focusLost(FocusEvent e) {
    }

    private void addMouseTrackListener() {
        final Tree tree = this.fViewer.getTree();
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                Object o;
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item != null && (o = item.getData()) instanceof PHPCodeData) {
                    tree.setToolTipText(ProjectOutlinePart.this.fLabelProvider.getTooltipText(o));
                }
            }
        });
    }

    public void collapseAll() {
        try {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
            this.fLastOpenSelection = null;
        }
        finally {
            this.fViewer.getControl().setRedraw(true);
        }
    }

    protected ProjectOutlineViewGroup createActionGroup() {
        return new ProjectOutlineViewGroup(this);
    }

    public ProjectOutlineContentProvider createContentProvider() {
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        boolean showCUChildren = store.getBoolean("explorerCuchildren");
        return new ProjectOutlineContentProvider(this, showCUChildren);
    }

    protected ProjectOutlineLabelProvider createLabelProvider() {
        return new ProjectOutlineLabelProvider(1090519051, 3, this.fContentProvider);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.initProjectName = memento.getString("ProjectOutlinePart.storedProjectName");
        }
    }

    public void saveState(IMemento memento) {
        if (this.currentProject != null) {
            memento.putString("ProjectOutlinePart.storedProjectName", this.currentProject.getName());
        }
        super.saveState(memento);
    }

    public void createPartControl(Composite parent) {
        this.getSite().getPage().addPartListener(this.fPartListener);
        this.fViewer = this.createViewer(parent);
        PHPElementSorter sorter = new PHPElementSorter();
        sorter.setUsingCategories(false);
        sorter.setUsingLocation(true);
        this.fViewer.setSorter(sorter);
        this.fViewer.getControl().addFocusListener((FocusListener)this);
        this.fSelectionListener.setViewer(this.getViewer());
        this.fSelectionListener.setResetEmptySelection(false);
        this.setProviders();
        this.fViewer.setUseHashlookup(true);
        this.setUpPopupMenu();
        this.initLinkingEnabled();
        this.actionGroup = this.createActionGroup();
        this.fPostSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectOutlinePart.this.handlePostSelectionChanged(event);
            }
        };
        this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        this.addMouseTrackListener();
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                ProjectOutlinePart.this.fLastOpenSelection = event.getSelection();
                ProjectOutlinePart.this.openEditorAction.run((IStructuredSelection)ProjectOutlinePart.this.fLastOpenSelection);
            }
        });
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener(new StatusBarUpdater(slManager));
        this.updateTitle();
        IEditorPart editorPart = this.getViewSite().getPage().getActiveEditor();
        this.updateInputForCurrentEditor(editorPart);
        this.openEditorAction = new OpenAction((IWorkbenchSite)this.getSite());
        this.fillActionBars();
        this.setLinkingEnabled(this.isLinkingEnabled());
        if (this.initProjectName != null) {
            this.setProject(ResourcesPlugin.getWorkspace().getRoot().getProject(this.initProjectName));
        }
        PHPWorkspaceModelManager.getInstance().addModelListener((ModelListener)this.fContentProvider);
        this.fViewer.refresh();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.php_project_outline_view");
    }

    private PHPTreeViewer createViewer(Composite composite) {
        return new ProjectOutlineTreeViewer(composite, 772);
    }

    public void dispose() {
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        this.getSite().getPage().removePartListener(this.fPartListener);
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this.fSelectionListener);
        PHPWorkspaceModelManager.getInstance().removeModelListener((ModelListener)this.fContentProvider);
        super.dispose();
    }

    void editorActivated(IEditorPart editor) {
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.actionGroup.fillActionBars(actionBars);
    }

    String getFrameName(Object element) {
        if (element instanceof PHPCodeData) {
            return ((PHPCodeData)element).getName();
        }
        return this.fLabelProvider.getText(element);
    }

    String getToolTipText(Object element) {
        IPath path;
        String result = !(element instanceof IResource) ? (element instanceof PHPWorkspaceModelManager ? PHPUIMessages.getString("PHPExplorerPart_workspace") : (element instanceof PHPCodeData ? PHPElementLabels.getTextLabel(element, 1090519051L) : this.fLabelProvider.getText(element))) : ((path = ((IResource)element).getFullPath()).isRoot() ? PHPUIMessages.getString("PHPExplorer_title") : path.makeRelative().toString());
        if (this.fWorkingSetName == null) {
            return result;
        }
        String wsstr = MessageFormat.format(PHPUIMessages.getString("PHPExplorer_toolTip"), this.fWorkingSetName);
        if (result.length() == 0) {
            return wsstr;
        }
        return MessageFormat.format(PHPUIMessages.getString("PHPExplorer_toolTip2"), result, this.fWorkingSetName);
    }

    public PHPTreeViewer getViewer() {
        return this.fViewer;
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    private void handlePostSelectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (this.isLinkingEnabled() && !selection.equals(this.fLastOpenSelection)) {
            this.linkToEditor((IStructuredSelection)selection);
        }
        this.fLastOpenSelection = selection;
    }

    public void handleUpdateInput(IEditorPart editorPart) {
        IProject project = null;
        if (editorPart != null) {
            PHPStructuredEditor phpEditor = editorPart instanceof PHPStructuredEditor ? (PHPStructuredEditor)editorPart : EditorUtility.getPHPStructuredEditor((IWorkbenchPart)editorPart);
            if (phpEditor != null) {
                PHPFileData fileData = phpEditor.getPHPFileData();
                project = PHPWorkspaceModelManager.getInstance().getProjectForFileData(fileData, this.currentProject);
            } else {
                IEditorInput editorInput = editorPart.getEditorInput();
                if (editorInput instanceof FileEditorInput) {
                    FileEditorInput fileEditorInput = (FileEditorInput)editorInput;
                    project = fileEditorInput.getFile().getProject();
                }
            }
        }
        if (project != null) {
            this.setProject(project);
        }
    }

    private void initLinkingEnabled() {
        this.setLinkingEnabled(PreferenceConstants.getPreferenceStore().getBoolean("browsingProjectstoeditor"));
    }

    public boolean isInCurrentProject(Object element) {
        if (this.currentProject != null) {
            return this.currentProject.equals((Object)PHPModelUtil.getResource((Object)element).getProject());
        }
        return false;
    }

    boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    private void linkToEditor(IStructuredSelection selection) {
        IEditorPart part;
        if (this != this.getSite().getPage().getActivePart()) {
            return;
        }
        Object obj = selection.getFirstElement();
        if (selection.size() == 1 && (part = EditorUtility.isOpenInEditor(obj)) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            page.bringToTop((IWorkbenchPart)part);
            if (obj instanceof PHPCodeData) {
                EditorUtility.revealInEditor(part, (PHPCodeData)obj);
            }
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        PHPUiPlugin.createStandardGroups(menu);
        this.actionGroup.setContext(new ActionContext(this.fViewer.getSelection()));
        this.actionGroup.fillContextMenu(menu);
        this.actionGroup.setContext(null);
    }

    void projectStateChanged(Object root) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed() && ctrl.isVisible()) {
            this.fViewer.refresh(root, true);
            this.fViewer.setSelection(this.fViewer.getSelection());
        }
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    public void setLinkingEnabled(boolean enabled) {
        this.fLinkingEnabled = enabled;
        PreferenceConstants.getPreferenceStore().setValue("browsingProjectstoeditor", enabled);
        IWorkbenchPartSite site = this.getSite();
        if (site == null) {
            return;
        }
        IWorkbenchPage page = site.getPage();
        if (page == null) {
            return;
        }
        if (enabled) {
            page.addPostSelectionListener((ISelectionListener)this.fSelectionListener);
            IEditorPart editor = page.getActiveEditor();
            if (editor != null) {
                this.editorActivated(editor);
            }
        } else {
            page.removePostSelectionListener((ISelectionListener)this.fSelectionListener);
        }
    }

    public void setProject(IProject project) {
        if (project == this.currentProject) {
            return;
        }
        this.currentProject = project;
        if (this.updateViewJob == null) {
            this.updateViewJob = new UpdateViewJob();
        }
        this.updateViewJob.schedule();
        this.actionGroup.updateActions();
    }

    private void setProviders() {
        this.fContentProvider = this.createContentProvider();
        IPHPTreeContentProvider[] treeProviders = TreeProvider.getTreeProviders(this.getViewSite().getId());
        this.fContentProvider.setTreeProviders(treeProviders);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = this.createLabelProvider();
        this.fLabelProvider.setTreeProviders(treeProviders);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
    }

    public void setShowAll(boolean showAll) {
        if (showAll != this.showAll) {
            this.showAll = showAll;
            if (this.updateViewJob == null) {
                this.updateViewJob = new UpdateViewJob();
            }
            this.updateViewJob.schedule();
        }
    }

    private void setUpPopupMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuMgr.createContextMenu((Control)this.fViewer.getTree());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ISelection selection = ProjectOutlinePart.this.fViewer.getSelection();
                if (!selection.isEmpty()) {
                    IStructuredSelection s = (IStructuredSelection)selection;
                    boolean cfr_ignored_0 = s.getFirstElement() instanceof PHPFunctionData;
                }
            }
        });
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite site = this.getSite();
        site.registerContextMenu(menuMgr, (ISelectionProvider)this.fViewer);
        site.setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    private void updateInputForCurrentEditor(IEditorPart editorPart) {
        this.handleUpdateInput(editorPart);
    }

    void updateTitle() {
        Object input = this.fViewer.getInput();
        if (input == null || input instanceof PHPWorkspaceModelManager) {
            this.setContentDescription("");
            this.setTitleToolTip("");
        } else {
            String inputText = PHPElementLabels.getTextLabel(input, 1090519051L);
            this.setContentDescription(inputText);
            this.setTitleToolTip(this.getToolTipText(input));
        }
    }

    private class ProjectOutlineTreeViewer
    extends PHPTreeViewer {
        List fPendingGetChildren;

        public ProjectOutlineTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.fPendingGetChildren = Collections.synchronizedList(new ArrayList());
            this.setComparer(new PHPOutlineElementComparer());
        }

        public void add(Object parentElement, Object[] childElements) {
            if (this.fPendingGetChildren.contains(parentElement)) {
                return;
            }
            super.add(parentElement, childElements);
        }

        private TreePath createTreePath(TreeItem item) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(item.getData());
            TreeItem parent = item.getParentItem();
            while (parent != null) {
                result.add(parent.getData());
                parent = parent.getParentItem();
            }
            Collections.reverse(result);
            return new TreePath(result.toArray());
        }

        private Object filter(Object object, Object parent, ViewerFilter[] filters) {
            ViewerFilter[] viewerFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                if (!filter.select((Viewer)ProjectOutlinePart.this.fViewer, parent, object)) {
                    return null;
                }
                ++n2;
            }
            return object;
        }

        protected Object[] filter(Object[] elements) {
            ViewerFilter[] filters = this.getFilters();
            if (filters == null || filters.length == 0) {
                return elements;
            }
            ArrayList<Object> filtered = new ArrayList<Object>(elements.length);
            Object root = this.getRoot();
            int i = 0;
            while (i < elements.length) {
                boolean add = true;
                if (!this.isEssential(elements[i])) {
                    ViewerFilter[] viewerFilterArray = filters;
                    int n = filters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ViewerFilter element = viewerFilterArray[n2];
                        add = element.select((Viewer)this, root, elements[i]);
                        if (!add) break;
                        ++n2;
                    }
                }
                if (add) {
                    filtered.add(elements[i]);
                }
                ++i;
            }
            return filtered.toArray();
        }

        private Object getElement(TreeItem item) {
            Object result = item.getData();
            if (result == null) {
                return null;
            }
            return result;
        }

        protected Object[] getFilteredChildren(Object parent) {
            ArrayList<Object> list = new ArrayList<Object>();
            ViewerFilter[] filters = ProjectOutlinePart.this.fViewer.getFilters();
            if (ProjectOutlinePart.this.fViewer.getContentProvider() == null) {
                return new Object[0];
            }
            Object[] children = ((ITreeContentProvider)ProjectOutlinePart.this.fViewer.getContentProvider()).getChildren(parent);
            int i = 0;
            while (children != null && i < children.length) {
                Object object = children[i];
                if (!this.isEssential(object)) {
                    if ((object = this.filter(object, parent, filters)) != null) {
                        list.add(object);
                    }
                } else {
                    list.add(object);
                }
                ++i;
            }
            return list.toArray();
        }

        protected Object[] getRawChildren(Object parent) {
            try {
                this.fPendingGetChildren.add(parent);
                Object[] objectArray = super.getRawChildren(parent);
                return objectArray;
            }
            finally {
                this.fPendingGetChildren.remove(parent);
            }
        }

        public ISelection getSelection() {
            IContentProvider cp = this.getContentProvider();
            Control control = this.getControl();
            if (control == null || control.isDisposed()) {
                return StructuredSelection.EMPTY;
            }
            if (!(cp instanceof IMultiElementTreeContentProvider)) {
                return super.getSelection();
            }
            Tree tree = this.getTree();
            TreeItem[] selection = tree.getSelection();
            ArrayList<Object> result = new ArrayList<Object>(selection.length);
            ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
            TreeItem[] treeItemArray = selection;
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                Object element = this.getElement(item);
                if (element != null) {
                    if (!result.contains(element)) {
                        result.add(element);
                    }
                    treePaths.add(this.createTreePath(item));
                }
                ++n2;
            }
            return new MultiElementSelection((StructuredViewer)this, result, treePaths.toArray(new TreePath[treePaths.size()]));
        }

        protected void handleInvalidSelection(ISelection invalidSelection, ISelection newSelection) {
            IStructuredSelection is = (IStructuredSelection)invalidSelection;
            ArrayList<Object> ns = null;
            ns = newSelection instanceof IStructuredSelection ? new ArrayList(((IStructuredSelection)newSelection).toList()) : new ArrayList<IProject>();
            boolean changed = false;
            for (Object element : is) {
                IProject project;
                if (element instanceof PHPProjectModel) {
                    project = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)element);
                    if (project.isOpen()) continue;
                    ns.add(project);
                    changed = true;
                    continue;
                }
                if (!(element instanceof IProject) || !(project = (IProject)element).isOpen()) continue;
                changed = true;
            }
            if (changed) {
                newSelection = new StructuredSelection(ns);
                this.setSelection(newSelection, true);
            }
            super.handleInvalidSelection(invalidSelection, newSelection);
        }

        private boolean isEssential(Object object) {
            if (object instanceof IContainer) {
                IContainer folder = (IContainer)object;
                try {
                    return folder.members().length > 0;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }

        public boolean isExpandable(Object parent) {
            Object[] children;
            ViewerFilter[] filters = ProjectOutlinePart.this.fViewer.getFilters();
            Object[] objectArray = children = ((ITreeContentProvider)ProjectOutlinePart.this.fViewer.getContentProvider()).getChildren(parent);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (this.isEssential(object)) {
                    return true;
                }
                if ((object = this.filter(object, parent, filters)) != null) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    class UpdateViewJob
    extends Job {
        public UpdateViewJob() {
            super(PHPUIMessages.getString("ProjectOutlinePart.1"));
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (ProjectOutlinePart.this.getViewer().getInput() != ((UpdateViewJob)UpdateViewJob.this).ProjectOutlinePart.this.currentProject) {
                        ProjectOutlinePart.this.getViewer().setInput(((UpdateViewJob)UpdateViewJob.this).ProjectOutlinePart.this.currentProject);
                    }
                }
            });
            ProjectOutlinePart.this.fContentProvider.postRefresh(ProjectOutlinePart.this.currentProject, true);
            return Status.OK_STATUS;
        }
    }
}

