/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class PHPSearchEditorOpener {
    private IEditorPart fEditor;

    public IEditorPart openElement(Object element) throws PartInitException {
        IWorkbenchPage wbPage = PHPUiPlugin.getActivePage();
        if (NewSearchUI.reuseEditor()) {
            return this.showWithReuse(element, wbPage);
        }
        return this.showWithoutReuse(element, wbPage);
    }

    public IEditorPart openMatch(Match match) throws PartInitException {
        Object element = this.getElementToOpen(match);
        return this.openElement(element);
    }

    protected Object getElementToOpen(Match match) {
        return match.getElement();
    }

    private IEditorPart showWithoutReuse(Object element, IWorkbenchPage wbPage) throws PartInitException {
        return EditorUtility.openInEditor(element, false);
    }

    private IEditorPart showWithReuse(Object element, IWorkbenchPage wbPage) throws PartInitException {
        IFile file = this.getFile(element);
        if (file != null) {
            String editorID = this.getEditorID(file);
            return this.showInEditor(wbPage, (IEditorInput)new FileEditorInput(file), editorID);
        }
        return null;
    }

    private IFile getFile(Object element) {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        if (element instanceof IAdaptable) {
            return (IFile)((IAdaptable)element).getAdapter(IResource.class);
        }
        return null;
    }

    private String getEditorID(IFile file) throws PartInitException {
        IEditorDescriptor desc = IDE.getEditorDescriptor((IFile)file);
        if (desc == null) {
            return PHPUiPlugin.getDefault().getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor").getId();
        }
        return desc.getId();
    }

    private boolean isPinned(IEditorPart editor) {
        if (editor == null) {
            return false;
        }
        IEditorReference[] editorRefs = editor.getEditorSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            if (editor.equals(editorRefs[i].getEditor(false))) {
                return editorRefs[i].isPinned();
            }
            ++i;
        }
        return false;
    }

    private IEditorPart showInEditor(IWorkbenchPage page, IEditorInput input, String editorId) {
        IEditorPart editor = page.findEditor(input);
        if (editor != null) {
            page.bringToTop((IWorkbenchPart)editor);
        } else {
            boolean showsSameInputType;
            boolean isOpen = false;
            if (this.fEditor != null) {
                IEditorReference[] parts = page.getEditorReferences();
                int i = 0;
                while (!isOpen && i < parts.length) {
                    boolean bl = isOpen = this.fEditor == parts[i++].getEditor(false);
                }
            }
            boolean canBeReused = isOpen && !this.fEditor.isDirty() && !this.isPinned(this.fEditor);
            boolean bl = showsSameInputType = this.fEditor != null && this.fEditor.getSite().getId().equals(editorId);
            if (canBeReused && !showsSameInputType) {
                page.closeEditor(this.fEditor, false);
                this.fEditor = null;
            }
            if (canBeReused && showsSameInputType) {
                ((IReusableEditor)this.fEditor).setInput(input);
                page.bringToTop((IWorkbenchPart)this.fEditor);
                editor = this.fEditor;
            } else {
                try {
                    editor = page.openEditor(input, editorId, false);
                    this.fEditor = editor instanceof IReusableEditor ? editor : null;
                }
                catch (PartInitException partInitException) {
                    MessageDialog.openError((Shell)PHPUiPlugin.getActiveWorkbenchShell(), (String)PHPUIMessages.getString("Search_Error_openEditor_title"), (String)PHPUIMessages.getString("Search_Error_openEditor_message"));
                    return null;
                }
            }
        }
        return editor;
    }
}

