/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.search.IPHPSearchScope;
import org.eclipse.php.internal.ui.search.PHPSearchResult;
import org.eclipse.php.internal.ui.search.PHPSearchScope;
import org.eclipse.php.internal.ui.search.PHPWorspaceScope;
import org.eclipse.php.internal.ui.search.decorators.PHPClassConstantDataDecorator;
import org.eclipse.php.internal.ui.search.decorators.PHPClassDataDecorator;
import org.eclipse.php.internal.ui.search.decorators.PHPConstantDataDecorator;
import org.eclipse.php.internal.ui.search.decorators.PHPFunctionDataDecorator;
import org.eclipse.php.internal.ui.util.SearchPattern;
import org.eclipse.search.ui.text.Match;

public class PHPSearchEngine {
    public static IPHPSearchScope createPHPSearchScope(int searchFor, Object[] elements) {
        PHPSearchScope scope = new PHPSearchScope(searchFor);
        int i = 0;
        int length = elements.length;
        while (i < length) {
            Object element = elements[i];
            if (element != null) {
                try {
                    if (element instanceof IProject) {
                        scope.add((IProject)element);
                    } else if (element instanceof IResource) {
                        scope.add((IResource)element);
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
        return scope;
    }

    public static IPHPSearchScope createWorkspaceScope(int searchFor) {
        IWorkspace workspace = PHPUiPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        PHPWorspaceScope scope = new PHPWorspaceScope(searchFor);
        int i = 0;
        while (i < projects.length) {
            try {
                if (projects[i].isAccessible() && projects[i].hasNature("org.eclipse.php.core.PHPNature")) {
                    scope.add(projects[i]);
                }
            }
            catch (CoreException e) {
                PHPUiPlugin.log(e);
            }
            ++i;
        }
        return scope;
    }

    public void search(String stringPattern, IPHPSearchScope scope, PHPSearchResult textResult, boolean caseSensitive, IProgressMonitor monitor) {
        IProject[] projectsInScope = scope.getFullScopeProjects();
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (monitor != null) {
            monitor.beginTask(PHPUIMessages.getString("PHPEngine_searching"), -1);
        }
        int i = 0;
        while (i < projectsInScope.length) {
            if (monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(projectsInScope[i]);
            if (projectModel == null) {
                return;
            }
            PHPUserModel userModel = projectModel.getPHPUserModel();
            PHPClassData[] fClasses = (PHPClassData[])userModel.getClasses();
            switch (scope.getSearchFor()) {
                case 0: {
                    this.addResultsFor(projectsInScope[i], (PHPClassData[])userModel.getClasses(), stringPattern, caseSensitive, scope, textResult, monitor);
                    break;
                }
                case 1: {
                    this.addResultsFor(projectsInScope[i], (PHPFunctionData[])userModel.getFunctions(), stringPattern, caseSensitive, scope, textResult, monitor);
                    int j = 0;
                    while (j < fClasses.length) {
                        this.addResultsFor(projectsInScope[i], fClasses[j].getFunctions(), stringPattern, caseSensitive, scope, textResult, monitor);
                        ++j;
                    }
                    break;
                }
                case 2: {
                    this.addResultsFor(projectsInScope[i], (PHPConstantData[])userModel.getConstants(), stringPattern, caseSensitive, scope, textResult, monitor);
                    int j = 0;
                    while (j < fClasses.length) {
                        this.addResultsFor(projectsInScope[i], fClasses[j].getConsts(), stringPattern, caseSensitive, scope, textResult, monitor);
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        IProject[] partialProjects = scope.getPartialScopeProjects();
        int i2 = 0;
        while (i2 < partialProjects.length) {
            if (monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PHPProjectModel projectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(partialProjects[i2]);
            if (projectModel == null) {
                return;
            }
            PHPUserModel userModel = projectModel.getPHPUserModel();
            IPath[] paths = scope.getPartialResourcesPaths(partialProjects[i2]);
            int j = 0;
            while (j < paths.length) {
                PHPFileData fileData = userModel.getFileData(paths[j].toString());
                if (fileData != null) {
                    PHPClassData[] fClasses = fileData.getClasses();
                    switch (scope.getSearchFor()) {
                        case 0: {
                            this.addResultsFor(partialProjects[i2], fileData.getClasses(), stringPattern, caseSensitive, scope, textResult, monitor);
                            break;
                        }
                        case 1: {
                            this.addResultsFor(partialProjects[i2], fileData.getFunctions(), stringPattern, caseSensitive, scope, textResult, monitor);
                            int k = 0;
                            while (k < fClasses.length) {
                                this.addResultsFor(partialProjects[i2], fClasses[k].getFunctions(), stringPattern, caseSensitive, scope, textResult, monitor);
                                ++k;
                            }
                            break;
                        }
                        case 2: {
                            this.addResultsFor(partialProjects[i2], fileData.getConstants(), stringPattern, caseSensitive, scope, textResult, monitor);
                            int z = 0;
                            while (z < fClasses.length) {
                                this.addResultsFor(partialProjects[i2], fClasses[z].getConsts(), stringPattern, caseSensitive, scope, textResult, monitor);
                                ++z;
                            }
                            break;
                        }
                    }
                }
                ++j;
            }
            ++i2;
        }
        if (monitor != null && !monitor.isCanceled()) {
            monitor.done();
        }
    }

    private void addResultsFor(IProject project, PHPClassData[] classes, String stringPattern, boolean caseSensitive, IPHPSearchScope scope, PHPSearchResult textResult, IProgressMonitor monitor) {
        int i = 0;
        while (i < classes.length) {
            if (i % 100 == 0 && monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PHPClassData classData = classes[i];
            if (SearchPattern.match(stringPattern, classData.getName(), caseSensitive, true)) {
                int start = classData.getUserData().getStopPosition();
                textResult.addMatch(new Match((Object)new PHPClassDataDecorator(classData, project), start, classData.getName().length()));
            }
            monitor.worked(1);
            ++i;
        }
    }

    private void addResultsFor(IProject project, PHPFunctionData[] functions, String stringPattern, boolean caseSensitive, IPHPSearchScope scope, PHPSearchResult textResult, IProgressMonitor monitor) {
        int i = 0;
        while (i < functions.length) {
            if (i % 100 == 0 && monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PHPFunctionData functionData = functions[i];
            if (SearchPattern.match(stringPattern, functionData.getName(), caseSensitive, true)) {
                int start = functionData.getUserData().getStopPosition();
                textResult.addMatch(new Match((Object)new PHPFunctionDataDecorator(functionData, project), start, functionData.getName().length()));
            }
            monitor.worked(1);
            ++i;
        }
    }

    private void addResultsFor(IProject project, PHPConstantData[] constants, String stringPattern, boolean caseSensitive, IPHPSearchScope scope, PHPSearchResult textResult, IProgressMonitor monitor) {
        int i = 0;
        while (i < constants.length) {
            if (i % 100 == 0 && monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PHPConstantData constantData = constants[i];
            if (SearchPattern.match(stringPattern, constantData.getName(), caseSensitive, true)) {
                int start = constantData.getUserData().getStopPosition() + 1;
                textResult.addMatch(new Match((Object)new PHPConstantDataDecorator(constantData, project), start, constantData.getName().length()));
            }
            monitor.worked(1);
            ++i;
        }
    }

    private void addResultsFor(IProject project, PHPClassConstData[] constants, String stringPattern, boolean caseSensitive, IPHPSearchScope scope, PHPSearchResult textResult, IProgressMonitor monitor) {
        int i = 0;
        while (i < constants.length) {
            if (i % 100 == 0 && monitor != null && monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PHPClassConstData constantData = constants[i];
            if (SearchPattern.match(stringPattern, constantData.getName(), caseSensitive, true)) {
                int start = constantData.getUserData().getStopPosition();
                textResult.addMatch(new Match((Object)new PHPClassConstantDataDecorator(constantData, project), start, constantData.getName().length()));
            }
            monitor.worked(1);
            ++i;
        }
    }
}

